var app = angular.module('myApp', ['ngSanitize', "xeditable"]);

app.controller('dashController',function($scope, $filter, $http, $q){
	// Meta data, mostly created on initial load
	$scope.initialData={
		tempID:0,
		dataLoading:true
	};

	// Data gathered via get in initialLoad function
	$scope.getData={};

	// Lists for static drop-downs
	$scope.static={
		ipRegex:RegExp("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"),
		intTypes:[
            {value:'None',text:'None'},
            {value:'logical:mgmt',text:'logical:mgmt'},
            {value:'physical:data',text:'physical:data'},
            {value:'logical:data',text:'logical:data'},
            {value:'physical:power',text:'physical:power'},
            {value:'physical:outlet',text:'physical:outlet'},
            {value:'physical:console',text:'physical:console'},
            {value:'physical:serial',text:'physical:serial'}
		],
		connectorTypes:[
			{value:'None',text:'None'},
			{value:'LC',text:'LC'},
			{value:'SC',text:'SC'},
			{value:'MTP',text:'MTP'},
			{value:'C20',text:'C20'},
			{value:'C16',text:'C16'},
			{value:'C14',text:'C14'},
			{value:'RJ45',text:'RJ45'}
		],
		interfacePositions:[
			{value:'None',text:'None'},
			{value:'face',text:'device face'},
			{value:'rear',text:'device rear'}
		],
		status:[
			{value:'current',text:'current'},
			{value:'upcomming',text:'upcomming'},
			{value:'decommissioned',text:'decommissioned'},
			{value:'ordered',text:'ordered'},
			{value:'reserved',text:'reserved'},
			{value:'maintance',text:'maintance'},
			{value:'observe',text:'observe'},
			{value:'imageable',text:'imageable'},
			{value:'unreachable',text:'unreachable'}
		]
	};

	// Go to webpage (javascript based link)
	$scope.goTo = function(base,element) {
		window.location.href = base + element;
	};

	// Go to webpage (javascript based link)
	$scope.goToRack = function(base,ele1,var2,ele2) {
		window.location.href = base + ele1 + var2 + ele2;
	};

	// Check if field is empty text
	$scope.checkEmptyText = function(str,valueName) {
		if(!str || 0 == str.length){
			return (valueName+" cannot be empty");
		}
	};

	// Check if field is empty selectable
	$scope.checkEmptySelect = function(str,valueName) {
		if(!str || 0 == str.length || str=='None'){
			return (valueName+" cannot be empty");
		}
	};

	// Check if field matches IP address
	$scope.checkIPAddress = function(str) {
		if(str != null && 0 != str.length && $scope.static.ipRegex.test(str) == false) {	
			return ("Must be an IP address");
		}
	};

	// Gather initial data based off of provided html
	$scope.initialLoad = function(requestString,key,subPri) {
		$scope.initialData.getString = requestString;
		$scope.initialData.subListName = key;
		$scope.initialData.subListPriKey = subPri;
		$http.get('/api2/all/'+$scope.initialData.getString).success(function(data) {
			console.log("Loaded initial data for " + $scope.initialData.getString);
			$scope.initialData.dataLoading=false;
			$scope.getData = data;
			$scope.loadDeviceTypes();
		});
	};

	// Handle static drop-down multi-select
	// Interface Type Dropdown (device_details and interface_details only)
	$scope.showIntType = function(element) {
		var selected = [];
		if(element.intType) {
			selected = $filter('filter')($scope.static.intTypes, {value: element.intType});
		}
		return selected.length ? selected[0].text : 'Not set';
	};

	// Handle dynamic drop-down multi-select
	// Device Type Dropdown (rack_details and device_details only)
	$scope.deviceTypes = [];
	$scope.loadDeviceTypes = function() {
		if ($scope.deviceTypes.length == 0){
			$http.get('/api2/resource/devicetype').success(function(data) {
				$scope.deviceTypes = data['deviceTypes'];
			});
		}
	};
	$scope.showDeviceType = function() {
		if($scope.deviceTypes.length <= 0 ){
			$http.get('/api2/resource/devicetype').success(function(data) {
				$scope.deviceTypes = data['deviceTypes'];
				for (var i = $scope.deviceTypes.length; i--;) {
					if ($scope.deviceTypes[i]['deviceTypeID'] == $scope.getData.deviceTypeID){
						$scope.initialData.showDeviceType = $scope.deviceTypes[i]['deviceTypeName'];
						return $scope.initialData.showDeviceType;
						console.log($scope.initialData.showDeviceType);
					}
				}
			});
		} else {
			for (var i = $scope.deviceTypes.length; i--;) {
				if ($scope.deviceTypes[i]['deviceTypeID'] == $scope.getData.deviceTypeID){
					$scope.initialData.showDeviceType =$scope.deviceTypes[i]['deviceTypeName'];
					return $scope.initialData.showDeviceType;
				}
			}
		}
	};
	$scope.showDeviceTypeShort = function(deviceDict) {
		console.log('Show Device Type function')
		console.log(deviceDict)
		console.log($scope.deviceTypes.length)
		if ($scope.deviceTypes.length == 0) {
			$http.get('/api2/resource/devicetype').success(function(data) {
				$scope.deviceTypes = data['deviceTypes'];
				for (var i = $scope.deviceTypes.length; i--;) {
					if ($scope.deviceTypes[i]['deviceTypeID'] == deviceDict.deviceTypeID){
						return $scope.deviceTypes[i]['deviceTypeName'];
					}
				}
			});	
		} else {
			for (var i = $scope.deviceTypes.length; i--;) {
				if ($scope.deviceTypes[i]['deviceTypeID'] == deviceDict.deviceTypeID){
					return $scope.deviceTypes[i]['deviceTypeName'];
				}
			}
		}
	};

	// Add new element and mark as 'isNew'
	// Establish different base keys/values based off of specific data structure
	$scope.addElement = function() {
		if ($scope.initialData.subListName == 'interfaces') {
			newElement={
				intID: $scope.initialData.tempID,
				intName: '',
				intType: null,
				ipv4address: null,
				intLabel: null,
				isNew: true
			};
			$scope.getData.interfaces.push(newElement);
			$scope.initialData.tempID++;
		}
		if ($scope.initialData.subListName == 'devices') {
			newElement={
				deviceID: $scope.initialData.tempID,
				deviceName: '',
				deviceTypeID: null,
				deviceSerial: null,
				isNew: true
			};
			$scope.getData.devices.push(newElement);
			$scope.initialData.tempID++;
		}
		if ($scope.initialData.subListName == 'racks') {
			newElement={
				rackID: $scope.initialData.tempID,
				rackName: '',
				uCount: null,
				rackSubnet: null,
				rackNotes: null,
				rackStatus: null,
				isNew: true
			};
			$scope.getData.devices.push(newElement);
			$scope.initialData.tempID++;
		}
	};

	// Filter to only show non-deleted elements (hides row when 'delete' button is used)
	$scope.filterElement = function(element) {
		return element.isDeleted !== true;
	};


	// Mark an element as deleted
	$scope.deleteElement = function(key,value) {
		for (var i = $scope.getData[$scope.initialData.subListName].length; i--;) {
			if ($scope.getData[$scope.initialData.subListName][i][key] === value) {
				$scope.getData[$scope.initialData.subListName][i].isDeleted = true;
			}
		};
	};

	// cancel all changes
	$scope.Cancel = function() {
		console.log('Used Cancel function');
		for (var i = $scope.getData[$scope.initialData.subListName].length; i--;) {
			var element = $scope.getData[$scope.initialData.subListName][i];
			// undelete
			if (element.isDeleted) {
				delete element.isDeleted;
				console.log('CANCEL: Readded deleted element')
			}
			// remove new 
			if (element.isNew) {
				console.log('CANCEL: Removing new element')
				$scope.getData[$scope.initialData.subListName].splice(i, 1);
			}      
		};
	};

	// save edits
	$scope.saveData = function() {
		var results = [];
		console.log('Save Data Function:');
		for (var i = $scope.getData[$scope.initialData.subListName].length; i--;) {
			var element = $scope.getData[$scope.initialData.subListName][i];
			// actually delete elements
			if (element.isDeleted) {
				$scope.getData[$scope.initialData.subListName].splice(i, 1);
			}
			// mark as not new 
			if (element.isNew) {
				delete element.isNew;
				if ($scope.initialData.subListName == 'interfaces') {
					delete element.intID;
				}
				if ($scope.initialData.subListName == 'devices') {
					delete element.deviceID;
				}
				if ($scope.initialData.subListName == 'racks') {
					delete element.deviceID;
				}
			}
		}
		console.log($scope.getData)
		results.push($http.post('/api2/all/'+$scope.initialData.getString, $scope.getData));//.success(location.reload()));
		return $q.all(results);
	};
});