import sys, ldap, subprocess, threading, pexpect, time, getpass
import mysql.connector

##########################################
# Currently configured to work
#   with an initial command
#   then a follow up command
#   that has contingent input
#
# This is currently used to update
#   radius configuration but
#   the same process can be used
#   for user updates or any
#   other command
##########################################

##########################################
# Appears to be a bug with setting
#   input values in main function
#   within the threadedCommand
#   object.  To be sure the command
#   completes correctly, you may want
#   manually update the input values
#   within the threadedCommand
#   class temporarily.  Please be sure
#   not to push the change to git
#   if passwords are included in
#   plain text
##########################################


data_database_username = "testUser"
data_database_password = "test123"
data_database_dbname = "dcm_data"

class threadedCommand(object):
        statusDict = {'success':[],'failure':{}}
        hosts = []
        thread_count = 16
        lock = threading.Lock()
        username = None
        password = None
        input_01 = 'set radius secondary server 10.195.122.6'
        input_02 = 'set radius secondary secret'
        input_03 = None
        ssh_newkey = 'Are you sure you want to continue connecting \(yes\/no\)? '

        # function runs command
        def runCommand(self,host):
                success = [False,"Error: Unknown Failure"];
                try:
                        #start SSH session
                        sshSession = pexpect.spawn('ssh %s@%s' % (self.username,host))
                        responseIndex = sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

                        # accept new ssh key
                        if responseIndex == 0:
                                sshSession.sendline('yes')
                                # re-run expect to process failure or password
                                responseIndex=sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

                        # respond to password request
                        if responseIndex == 1:
                                sshSession.sendline(self.password)
                        elif responseIndex == 2:
                                success = [False,"Error: Password Request error, found EOF"];

                        # expect standard CDU prompt
                        sshSession.expect("Switched CDU: ")

                        ##########################################
                        # Process commands
                        ##########################################
                        sshSession.sendline(self.input_01)
                        responseIndex_01 = sshSession.expect(['Command successful','Invalid'])
                        if responseIndex_01 == 0: #Command completed successfully
                                sshSession.sendline(self.input_02)
                                responseIndex_02 = sshSession.expect([r'Enter Shared Secret \(48 characters max\):','Invalid'])
                                if responseIndex_02 == 0: #Command completed successfully
                                        sshSession.sendline(self.input_03)
                                        responseIndex_03 = sshSession.expect(['Command successful','Invalid'])
                                        if responseIndex_03 == 0: #Command completed successfully
                                                success = [True];
                                        elif responseIndex_03 == 1:
                                                success = [False,"Error: Command 3 Failure on Device"];
                                elif responseIndex_02 == 1:
                                        success = [False,"Error: Command 2 Failure on Device"];
                        elif responseIndex_01 == 1:
                                success = [False,"Error: Command 1 Failure on Device"];

                        ##########################################
                        # End commands
                        ##########################################

                except pexpect.TIMEOUT:
                        success = [False,"Error: Timeout"];
                except (pexpect.EOF, pexpect.TIMEOUT), e:
                        success = [False,"Error: General Error with PExpect"];
                return success

        def popQueue(self):
                hostname = None
                self.lock.acquire()
                if self.hosts:
                        hostname = self.hosts.pop()
                self.lock.release()
                return hostname

        def deQueue(self):
                while True:
                        hostname = self.popQueue()
                        if not hostname:
                                return None

                        # place hostnames in appropraite dict keys upon run
                        print str("Running command(s) against host " + hostname)
                        response=self.runCommand(hostname)
                        if response[0]:
                                self.statusDict['success'].append(hostname)
                        elif not response[0]:
                                self.statusDict['failure'][hostname]=response[1]

        def start(self):
                threads = []
                for i in range(self.thread_count):
                        t = threading.Thread(target=self.deQueue)
                        t.start()
                        threads.append(t)
                [t.join() for t in threads]
                return self.statusDict

if __name__=='__main__':

        user = raw_input("Username:")
        passwd = getpass.getpass("Password for " + user + ":")
        tempInput1 = raw_input("Initial Command:")
        tempInput2 = raw_input("Second Command (which requires radius password):")
        tempInput3 = getpass.getpass("Secondary RADIUS password:")

        cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
        cursor = cnx.cursor(dictionary=True)
        cdu_query_string = str("SELECT INET_NTOA(ipv4address) as ipv4address " \
                + "FROM device " \
                + "JOIN interface on device.deviceID=interface.deviceID " \
                + "JOIN deviceType on device.deviceTypeID=deviceType.deviceTypeID " \
                + "WHERE deviceRole='CDU' " \
                + "AND deviceMake='ServerTech' " \
                + "AND softwareVersion='Sentry3-7.0t' " \
                + "AND intType='logical:mgmt'")


        try:
                cursor.execute(cdu_query_string)
                cdu_dict=cursor.fetchall()
        except:
                print "error: " + str(sys.exc_info())
                cursor.close()
                cnx.close()
                sys.exit()

        cdu_list=[]
        for entryDict in cdu_dict:
                cdu_list.append(entryDict['ipv4address'])

        #print cdu_list

        run = threadedCommand()
        run.threaded_count = 16
        run.hosts = cdu_list
        #run.hosts = ['10.26.5.11', '10.24.14.11']
        run.username = user
        run.password = passwd
        run.input_01 = tempInput1
        run.input_02 = tempInput2
        run.input_03 = tempInput3

        print run.start()