import sys, ldap, subprocess, threading, pexpect, time
from my_app import login_manager, db, app, data_database_username, data_database_password, \
	data_database_dbname, ipmi_username, ipmi_password, openGear_pub, openGear_priv
from my_app.auth.models import User, LoginForm
import mysql.connector
from flask import Flask, render_template, request, redirect, json, jsonify, send_from_directory, \
	flash, url_for, Blueprint, g, Response, make_response
from flask_login import current_user, login_user, \
	logout_user, login_required
from pysnmp.entity.rfc3413.oneliner import cmdgen
from flask_wtf import Form
from wtforms import TextField, PasswordField, validators, RadioField, StringField, \
	BooleanField, SubmitField, TextAreaField, SelectField
from wtforms.validators import DataRequired, InputRequired

tools = Blueprint('tools', __name__)

duet_040_core_42=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':42,'deviceName':'CP01'},
	{'deviceTypeID':12,'uStart':38,'deviceName':'PP01'},
	{'deviceTypeID':12,'uStart':34,'deviceName':'PP02'},
	{'deviceTypeID':21,'uStart':33,'deviceName':'Wire_manager_1'},
	{'deviceTypeID':6,'uStart':32,'deviceName':'ts01'},
	{'deviceTypeID':24,'uStart':29,'deviceName':'od01'},
	{'deviceTypeID':25,'uStart':28,'deviceName':'mux01'},
	{'deviceTypeID':11,'uStart':26,'deviceName':'PP03'},
	{'deviceTypeID':26,'uStart':25,'deviceName':'oa01'},
	{'deviceTypeID':21,'uStart':24,'deviceName':'Wire_manager_2'},
	{'deviceTypeID':26,'uStart':23,'deviceName':'oa02'},
	{'deviceTypeID':23,'uStart':22,'deviceName':'ats01'},
	{'deviceTypeID':23,'uStart':21,'deviceName':'ats02'},
	{'deviceTypeID':22,'uStart':19,'deviceName':'fan01'},
	{'deviceTypeID':27,'uStart':12,'deviceName':'br01'},
	{'deviceTypeID':23,'uStart':11,'deviceName':'ats03'},
	{'deviceTypeID':23,'uStart':10,'deviceName':'ats04'},
	{'deviceTypeID':22,'uStart':8,'deviceName':'fan02'},
	{'deviceTypeID':27,'uStart':1,'deviceName':'br02'}
]
duet_040_core_46=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':46,'deviceName':'CP01'},
	{'deviceTypeID':12,'uStart':42,'deviceName':'PP01'},
	{'deviceTypeID':12,'uStart':38,'deviceName':'PP02'},
	{'deviceTypeID':21,'uStart':33,'deviceName':'Wire_manager_1'},
	{'deviceTypeID':6,'uStart':32,'deviceName':'ts01'},
	{'deviceTypeID':24,'uStart':29,'deviceName':'od01'},
	{'deviceTypeID':25,'uStart':28,'deviceName':'mux01'},
	{'deviceTypeID':11,'uStart':26,'deviceName':'PP03'},
	{'deviceTypeID':26,'uStart':25,'deviceName':'oa01'},
	{'deviceTypeID':21,'uStart':24,'deviceName':'Wire_manager_2'},
	{'deviceTypeID':26,'uStart':23,'deviceName':'oa02'},
	{'deviceTypeID':23,'uStart':22,'deviceName':'ats01'},
	{'deviceTypeID':23,'uStart':21,'deviceName':'ats02'},
	{'deviceTypeID':22,'uStart':19,'deviceName':'fan01'},
	{'deviceTypeID':27,'uStart':12,'deviceName':'br01'},
	{'deviceTypeID':23,'uStart':11,'deviceName':'ats03'},
	{'deviceTypeID':23,'uStart':10,'deviceName':'ats04'},
	{'deviceTypeID':22,'uStart':8,'deviceName':'fan02'},
	{'deviceTypeID':27,'uStart':1,'deviceName':'br02'}
]
quartet_037_core1=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':46,'deviceName':'CP01'},
	{'deviceTypeID':11,'uStart':44,'deviceName':'PP01'},
	{'deviceTypeID':12,'uStart':40,'deviceName':'PP02'},
	{'deviceTypeID':11,'uStart':38,'deviceName':'PP03'},
	{'deviceTypeID':7,'uStart':35,'deviceName':'mds01'},
	{'deviceTypeID':9,'uStart':34,'deviceName':'ma01'},
	{'deviceTypeID':8,'uStart':23,'deviceName':'da01'},
	{'deviceTypeID':15,'uStart':22,'deviceName':'Shelf_for_DA01'},
	{'deviceTypeID':17,'uStart':1,'deviceName':'br01'}
]
quartet_040_core1=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':14,'uStart':46,'deviceName':'Brush_panel_1'},
	{'deviceTypeID':19,'uStart':45,'deviceName':'CP01'},
	{'deviceTypeID':18,'uStart':44,'deviceName':'PP01'},
	{'deviceTypeID':11,'uStart':42,'deviceName':'PP02'},
	{'deviceTypeID':14,'uStart':38,'deviceName':'Brush_panel_2'},
	{'deviceTypeID':6,'uStart':37,'deviceName':'ts01'},
	{'deviceTypeID':7,'uStart':36,'deviceName':'mds01'},
	{'deviceTypeID':8,'uStart':35,'deviceName':'ma01'},
	{'deviceTypeID':20,'uStart':34,'deviceName':'ds01'},
	{'deviceTypeID':20,'uStart':33,'deviceName':'ds03'},
	{'deviceTypeID':15,'uStart':32,'deviceName':'Shelf_for_DA01'},
	{'deviceTypeID':17,'uStart':1,'deviceName':'br01'}
]
quartet_037_core2=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':46,'deviceName':'CP01'},
	{'deviceTypeID':11,'uStart':44,'deviceName':'PP01'},
	{'deviceTypeID':12,'uStart':40,'deviceName':'PP02'},
	{'deviceTypeID':11,'uStart':38,'deviceName':'PP03'},
	{'deviceTypeID':6,'uStart':36,'deviceName':'ts01'},
	{'deviceTypeID':7,'uStart':35,'deviceName':'mds02'},
	{'deviceTypeID':9,'uStart':34,'deviceName':'ma01'},
	{'deviceTypeID':8,'uStart':23,'deviceName':'da02'},
	{'deviceTypeID':15,'uStart':22,'deviceName':'Shelf_for_DA01'},
	{'deviceTypeID':17,'uStart':1,'deviceName':'br02'}
]
quartet_040_core2=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':14,'uStart':46,'deviceName':'Brush_panel_1'},
	{'deviceTypeID':19,'uStart':45,'deviceName':'CP01'},
	{'deviceTypeID':18,'uStart':44,'deviceName':'PP01'},
	{'deviceTypeID':11,'uStart':42,'deviceName':'PP02'},
	{'deviceTypeID':14,'uStart':38,'deviceName':'Brush_panel_2'},
	{'deviceTypeID':6,'uStart':37,'deviceName':'ts02'},
	{'deviceTypeID':7,'uStart':36,'deviceName':'mds02'},
	{'deviceTypeID':8,'uStart':35,'deviceName':'ma01'},
	{'deviceTypeID':20,'uStart':34,'deviceName':'ds02'},
	{'deviceTypeID':20,'uStart':33,'deviceName':'ds04'},
	{'deviceTypeID':15,'uStart':32,'deviceName':'Shelf_for_DA01'},
	{'deviceTypeID':17,'uStart':1,'deviceName':'br02'}
]
quartet_037_dmarc=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'}
]
quartet_040_dmarc=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':46,'deviceName':'CP01'},
	{'deviceTypeID':14,'uStart':45,'deviceName':'Brush_panel_1'},
	{'deviceTypeID':12,'uStart':41,'deviceName':'PP01'},
	{'deviceTypeID':12,'uStart':37,'deviceName':'PP02'},
	{'deviceTypeID':12,'uStart':25,'deviceName':'PP05'},
	{'deviceTypeID':12,'uStart':21,'deviceName':'PP06'}
]
# Need to update dwdm DMARC with expected ciena installation
# (probably safe to do all wire management but only fist set of equipment)
quartet_037_dmarc_dwdm=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':11,'uStart':15,'deviceName':'pp07'},
	{'deviceTypeID':11,'uStart':5,'deviceName':'pp08'}
]
# ciena - 1U - starting:1 - oa04
# 2uManager - 2U - starting:2 - wire_manager
# ciena - 1U - starting:4 - oa03
# mux - 1U - starting:7 - mux2
# OD - 3U - starting:8 - od02
# ciena - 1U - starting:11 - oa02
# 2uManager - 2U - starting:12 - wire_manager
# ciena - 1U - starting:14 - oa01
# mux - 1U - starting:17 - mux1
# OD - 3U - starting:18 - od01
duet_040_server_42=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':42,'deviceName':'CP01'},
	{'deviceTypeID':14,'uStart':41,'deviceName':'Brush_panel_1'},
	{'deviceTypeID':20,'uStart':40,'deviceName':'da01'},
	{'deviceTypeID':20,'uStart':39,'deviceName':'da02'},
	{'deviceTypeID':8,'uStart':38,'deviceName':'ma01'},
	{'deviceTypeID':8,'uStart':37,'deviceName':'ma02'},
	{'deviceTypeID':16,'uStart':33,'deviceName':'s8'},
	{'deviceTypeID':16,'uStart':29,'deviceName':'s7'},
	{'deviceTypeID':28,'uStart':25,'deviceName':'drawer_1'},
	{'deviceTypeID':16,'uStart':21,'deviceName':'s6'},
	{'deviceTypeID':16,'uStart':17,'deviceName':'s5'},
	{'deviceTypeID':16,'uStart':13,'deviceName':'s4'},
	{'deviceTypeID':16,'uStart':9,'deviceName':'s3'},
	{'deviceTypeID':16,'uStart':5,'deviceName':'s2'},
	{'deviceTypeID':16,'uStart':1,'deviceName':'s1'}
]
duet_040_server_46=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':46,'deviceName':'CP01'},
	{'deviceTypeID':14,'uStart':45,'deviceName':'Brush_panel_1'},
	{'deviceTypeID':20,'uStart':44,'deviceName':'da01'},
	{'deviceTypeID':20,'uStart':43,'deviceName':'da02'},
	{'deviceTypeID':8,'uStart':42,'deviceName':'ma01'},
	{'deviceTypeID':8,'uStart':41,'deviceName':'ma02'},
	{'deviceTypeID':16,'uStart':33,'deviceName':'s8'},
	{'deviceTypeID':16,'uStart':29,'deviceName':'s7'},
	{'deviceTypeID':28,'uStart':25,'deviceName':'drawer_1'},
	{'deviceTypeID':16,'uStart':21,'deviceName':'s6'},
	{'deviceTypeID':16,'uStart':17,'deviceName':'s5'},
	{'deviceTypeID':16,'uStart':13,'deviceName':'s4'},
	{'deviceTypeID':16,'uStart':9,'deviceName':'s3'},
	{'deviceTypeID':16,'uStart':5,'deviceName':'s2'},
	{'deviceTypeID':16,'uStart':1,'deviceName':'s1'}
]
quartet_037_server=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':7,'uStart':42,'deviceName':'ma01'},
	{'deviceTypeID':7,'uStart':41,'deviceName':'ma02'},
	{'deviceTypeID':16,'uStart':29,'deviceName':'s8'},
	{'deviceTypeID':16,'uStart':25,'deviceName':'s7'},
	{'deviceTypeID':16,'uStart':21,'deviceName':'s6'},
	{'deviceTypeID':16,'uStart':17,'deviceName':'s5'},
	{'deviceTypeID':16,'uStart':13,'deviceName':'s4'},
	{'deviceTypeID':16,'uStart':9,'deviceName':'s3'},
	{'deviceTypeID':16,'uStart':5,'deviceName':'s2'},
	{'deviceTypeID':16,'uStart':1,'deviceName':'s1'}
]
quartet_040_server=[
	{'deviceTypeID':2,'uStart':None,'deviceName':'a'},
	{'deviceTypeID':2,'uStart':None,'deviceName':'b'},
	{'deviceTypeID':13,'uStart':46,'deviceName':'CP01'},
	{'deviceTypeID':14,'uStart':45,'deviceName':'Brush_panel_1'},
	{'deviceTypeID':20,'uStart':44,'deviceName':'da01'},
	{'deviceTypeID':20,'uStart':43,'deviceName':'da02'},
	{'deviceTypeID':7,'uStart':42,'deviceName':'ma01'},
	{'deviceTypeID':7,'uStart':41,'deviceName':'ma02'},
	{'deviceTypeID':16,'uStart':33,'deviceName':'s9'},
	{'deviceTypeID':16,'uStart':29,'deviceName':'s8'},
	{'deviceTypeID':16,'uStart':25,'deviceName':'s7'},
	{'deviceTypeID':16,'uStart':21,'deviceName':'s6'},
	{'deviceTypeID':16,'uStart':17,'deviceName':'s5'},
	{'deviceTypeID':16,'uStart':13,'deviceName':'s4'},
	{'deviceTypeID':16,'uStart':9,'deviceName':'s3'},
	{'deviceTypeID':16,'uStart':5,'deviceName':'s2'},
	{'deviceTypeID':16,'uStart':1,'deviceName':'s1'}
]
duet_040_ts=[
	{'intType':'physical:serial','intName':'s1','intLabel':'con.br01'},
	{'intType':'physical:serial','intName':'s2','intLabel':'con2.br01'},
	{'intType':'physical:serial','intName':'s3','intLabel':'con.br02'},
	{'intType':'physical:serial','intName':'s4','intLabel':'con2.br02'},
	{'intType':'physical:serial','intName':'s5','intLabel':None},
	{'intType':'physical:serial','intName':'s6','intLabel':None},
	{'intType':'physical:serial','intName':'s7','intLabel':None},
	{'intType':'physical:serial','intName':'s8','intLabel':None},
	{'intType':'physical:serial','intName':'s9','intLabel':'ma01'},
	{'intType':'physical:serial','intName':'s10','intLabel':'ma02'},
	{'intType':'physical:serial','intName':'s11','intLabel':None},
	{'intType':'physical:serial','intName':'s12','intLabel':None},
	{'intType':'physical:serial','intName':'s13','intLabel':None},
	{'intType':'physical:serial','intName':'s14','intLabel':None},
	{'intType':'physical:serial','intName':'s15','intLabel':None},
	{'intType':'physical:serial','intName':'s16','intLabel':None},
	{'intType':'physical:serial','intName':'s17','intLabel':'da01'},
	{'intType':'physical:serial','intName':'s18','intLabel':'da02'},
	{'intType':'physical:serial','intName':'s19','intLabel':None},
	{'intType':'physical:serial','intName':'s20','intLabel':None},
	{'intType':'physical:serial','intName':'s21','intLabel':None},
	{'intType':'physical:serial','intName':'s22','intLabel':None},
	{'intType':'physical:serial','intName':'s23','intLabel':None},
	{'intType':'physical:serial','intName':'s24','intLabel':None},
	{'intType':'physical:serial','intName':'s25','intLabel':None},
	{'intType':'physical:serial','intName':'s26','intLabel':None},
	{'intType':'physical:serial','intName':'s27','intLabel':None},
	{'intType':'physical:serial','intName':'s28','intLabel':None},
	{'intType':'physical:serial','intName':'s29','intLabel':'pdu1a'},
	{'intType':'physical:serial','intName':'s30','intLabel':'pdu2b'},
	{'intType':'physical:serial','intName':'s31','intLabel':'pdu2a'},
	{'intType':'physical:serial','intName':'s32','intLabel':'pdu2b'},
	{'intType':'physical:serial','intName':'s33','intLabel':'ats01'},
	{'intType':'physical:serial','intName':'s34','intLabel':'ats02'},
	{'intType':'physical:serial','intName':'s35','intLabel':'ats03'},
	{'intType':'physical:serial','intName':'s36','intLabel':'ats04'},
	{'intType':'physical:serial','intName':'s37','intLabel':None},
	{'intType':'physical:serial','intName':'s38','intLabel':None},
	{'intType':'physical:serial','intName':'s39','intLabel':None},
	{'intType':'physical:serial','intName':'s40','intLabel':None},
	{'intType':'physical:serial','intName':'s41','intLabel':None},
	{'intType':'physical:serial','intName':'s42','intLabel':None},
	{'intType':'physical:serial','intName':'s43','intLabel':None},
	{'intType':'physical:serial','intName':'s44','intLabel':None},
	{'intType':'physical:serial','intName':'s45','intLabel':'od01'},
	{'intType':'physical:serial','intName':'s46','intLabel':'oa01'},
	{'intType':'physical:serial','intName':'s47','intLabel':'oa02'},
	{'intType':'physical:serial','intName':'s48','intLabel':None}
]
quartet_037_ts=[
	{'intType':'physical:serial','intName':'s1','intLabel':'con.br01'},
	{'intType':'physical:serial','intName':'s2','intLabel':None},
	{'intType':'physical:serial','intName':'s3','intLabel':'con2.br01'},
	{'intType':'physical:serial','intName':'s4','intLabel':None},
	{'intType':'physical:serial','intName':'s5','intLabel':'con.br02'},
	{'intType':'physical:serial','intName':'s6','intLabel':None},
	{'intType':'physical:serial','intName':'s7','intLabel':'con2.br02'},
	{'intType':'physical:serial','intName':'s8','intLabel':None},
	{'intType':'physical:serial','intName':'s9','intLabel':'con.da01'},
	{'intType':'physical:serial','intName':'s10','intLabel':'con2.da01'},
	{'intType':'physical:serial','intName':'s11','intLabel':'con.da02'},
	{'intType':'physical:serial','intName':'s12','intLabel':'con2.da02'},
	{'intType':'physical:serial','intName':'s13','intLabel':'mds01'},
	{'intType':'physical:serial','intName':'s14','intLabel':'mds02'},
	{'intType':'physical:serial','intName':'s15','intLabel':'r01-ma01'},
	{'intType':'physical:serial','intName':'s16','intLabel':'r02-ma01'},
	{'intType':'physical:serial','intName':'s17','intLabel':'r04-ma01'},
	{'intType':'physical:serial','intName':'s18','intLabel':'r04-ma02'},
	{'intType':'physical:serial','intName':'s19','intLabel':'r05-ma01'},
	{'intType':'physical:serial','intName':'s20','intLabel':'r05-ma02'},
	{'intType':'physical:serial','intName':'s21','intLabel':'r06-ma01'},
	{'intType':'physical:serial','intName':'s22','intLabel':'r06-ma02'},
	{'intType':'physical:serial','intName':'s23','intLabel':'r07-ma01'},
	{'intType':'physical:serial','intName':'s24','intLabel':'r07-ma02'},
	{'intType':'physical:serial','intName':'s25','intLabel':'od01'},
	{'intType':'physical:serial','intName':'s26','intLabel':'od02'},
	{'intType':'physical:serial','intName':'s27','intLabel':'oa01'},
	{'intType':'physical:serial','intName':'s28','intLabel':'oa02'},
	{'intType':'physical:serial','intName':'s29','intLabel':'oa03'},
	{'intType':'physical:serial','intName':'s30','intLabel':'oa04'},
	{'intType':'physical:serial','intName':'s31','intLabel':None},
	{'intType':'physical:serial','intName':'s32','intLabel':None},
	{'intType':'physical:serial','intName':'s33','intLabel':None},
	{'intType':'physical:serial','intName':'s34','intLabel':None},
	{'intType':'physical:serial','intName':'s35','intLabel':'pdu1a'},
	{'intType':'physical:serial','intName':'s36','intLabel':'pdu1b'},
	{'intType':'physical:serial','intName':'s37','intLabel':'pdu2a'},
	{'intType':'physical:serial','intName':'s38','intLabel':'pdu2b'},
	{'intType':'physical:serial','intName':'s39','intLabel':'pdu3a'},
	{'intType':'physical:serial','intName':'s40','intLabel':'pdu3b'},
	{'intType':'physical:serial','intName':'s41','intLabel':'pdu4a'},
	{'intType':'physical:serial','intName':'s42','intLabel':'pdu4b'},
	{'intType':'physical:serial','intName':'s43','intLabel':'pdu5a'},
	{'intType':'physical:serial','intName':'s44','intLabel':'pdu5b'},
	{'intType':'physical:serial','intName':'s45','intLabel':'pdu6a'},
	{'intType':'physical:serial','intName':'s46','intLabel':'pdu6b'},
	{'intType':'physical:serial','intName':'s47','intLabel':'pdu7a'},
	{'intType':'physical:serial','intName':'s48','intLabel':'pdu7b'}
]
quartet_040_ts1=[
	{'intType':'physical:serial','intName':'s1','intLabel':'con.br01'},
	{'intType':'physical:serial','intName':'s2','intLabel':'con2.br01'},
	{'intType':'physical:serial','intName':'s3','intLabel':'da01'},
	{'intType':'physical:serial','intName':'s4','intLabel':'da03'},
	{'intType':'physical:serial','intName':'s5','intLabel':None},
	{'intType':'physical:serial','intName':'s6','intLabel':None},
	{'intType':'physical:serial','intName':'s7','intLabel':'mds01'},
	{'intType':'physical:serial','intName':'s8','intLabel':'r01-ma01'},
	{'intType':'physical:serial','intName':'s9','intLabel':'r04-ma01'},
	{'intType':'physical:serial','intName':'s10','intLabel':'r04-ma02'},
	{'intType':'physical:serial','intName':'s11','intLabel':'r06-ma01'},
	{'intType':'physical:serial','intName':'s12','intLabel':'r06-ma02'},
	{'intType':'physical:serial','intName':'s13','intLabel':None},
	{'intType':'physical:serial','intName':'s14','intLabel':None},
	{'intType':'physical:serial','intName':'s15','intLabel':None},
	{'intType':'physical:serial','intName':'s16','intLabel':None},
	{'intType':'physical:serial','intName':'s17','intLabel':'r04-da01'},
	{'intType':'physical:serial','intName':'s18','intLabel':'r04-da02'},
	{'intType':'physical:serial','intName':'s19','intLabel':'r06-da01'},
	{'intType':'physical:serial','intName':'s20','intLabel':'r06-da02'},
	{'intType':'physical:serial','intName':'s21','intLabel':None},
	{'intType':'physical:serial','intName':'s22','intLabel':None},
	{'intType':'physical:serial','intName':'s23','intLabel':None},
	{'intType':'physical:serial','intName':'s24','intLabel':None},
	{'intType':'physical:serial','intName':'s25','intLabel':None},
	{'intType':'physical:serial','intName':'s26','intLabel':None},
	{'intType':'physical:serial','intName':'s27','intLabel':None},
	{'intType':'physical:serial','intName':'s28','intLabel':None},
	{'intType':'physical:serial','intName':'s29','intLabel':'pdu1a'},
	{'intType':'physical:serial','intName':'s30','intLabel':'pdu1b'},
	{'intType':'physical:serial','intName':'s31','intLabel':'pdu3a'},
	{'intType':'physical:serial','intName':'s32','intLabel':'pdu3b'},
	{'intType':'physical:serial','intName':'s33','intLabel':'pdu4a'},
	{'intType':'physical:serial','intName':'s34','intLabel':'pdu4b'},
	{'intType':'physical:serial','intName':'s35','intLabel':'pdu6a'},
	{'intType':'physical:serial','intName':'s36','intLabel':'pdu6b'},
	{'intType':'physical:serial','intName':'s37','intLabel':None},
	{'intType':'physical:serial','intName':'s38','intLabel':None},
	{'intType':'physical:serial','intName':'s39','intLabel':None},
	{'intType':'physical:serial','intName':'s40','intLabel':None},
	{'intType':'physical:serial','intName':'s41','intLabel':None},
	{'intType':'physical:serial','intName':'s42','intLabel':None},
	{'intType':'physical:serial','intName':'s43','intLabel':"r02-ts02"},
	{'intType':'physical:serial','intName':'s44','intLabel':None},
	{'intType':'physical:serial','intName':'s45','intLabel':'od01'},
	{'intType':'physical:serial','intName':'s46','intLabel':'oa01'},
	{'intType':'physical:serial','intName':'s47','intLabel':'oa03'},
	{'intType':'physical:serial','intName':'s48','intLabel':None}
]
quartet_040_ts2=[
	{'intType':'physical:serial','intName':'s1','intLabel':'con.br02'},
	{'intType':'physical:serial','intName':'s2','intLabel':'con2.br02'},
	{'intType':'physical:serial','intName':'s3','intLabel':'da02'},
	{'intType':'physical:serial','intName':'s4','intLabel':'da04'},
	{'intType':'physical:serial','intName':'s5','intLabel':None},
	{'intType':'physical:serial','intName':'s6','intLabel':None},
	{'intType':'physical:serial','intName':'s7','intLabel':'mds02'},
	{'intType':'physical:serial','intName':'s8','intLabel':'r02-ma01'},
	{'intType':'physical:serial','intName':'s9','intLabel':'r05-ma01'},
	{'intType':'physical:serial','intName':'s10','intLabel':'r05-ma02'},
	{'intType':'physical:serial','intName':'s11','intLabel':'r07-ma01'},
	{'intType':'physical:serial','intName':'s12','intLabel':'r07-ma02'},
	{'intType':'physical:serial','intName':'s13','intLabel':None},
	{'intType':'physical:serial','intName':'s14','intLabel':None},
	{'intType':'physical:serial','intName':'s15','intLabel':None},
	{'intType':'physical:serial','intName':'s16','intLabel':None},
	{'intType':'physical:serial','intName':'s17','intLabel':'r05-da01'},
	{'intType':'physical:serial','intName':'s18','intLabel':'r05-da02'},
	{'intType':'physical:serial','intName':'s19','intLabel':'r07-da01'},
	{'intType':'physical:serial','intName':'s20','intLabel':'r07-da02'},
	{'intType':'physical:serial','intName':'s21','intLabel':None},
	{'intType':'physical:serial','intName':'s22','intLabel':None},
	{'intType':'physical:serial','intName':'s23','intLabel':None},
	{'intType':'physical:serial','intName':'s24','intLabel':None},
	{'intType':'physical:serial','intName':'s25','intLabel':None},
	{'intType':'physical:serial','intName':'s26','intLabel':None},
	{'intType':'physical:serial','intName':'s27','intLabel':None},
	{'intType':'physical:serial','intName':'s28','intLabel':None},
	{'intType':'physical:serial','intName':'s29','intLabel':'pdu2a'},
	{'intType':'physical:serial','intName':'s30','intLabel':'pdu2b'},
	{'intType':'physical:serial','intName':'s31','intLabel':None},
	{'intType':'physical:serial','intName':'s32','intLabel':None},
	{'intType':'physical:serial','intName':'s33','intLabel':'pdu5a'},
	{'intType':'physical:serial','intName':'s34','intLabel':'pdu5b'},
	{'intType':'physical:serial','intName':'s35','intLabel':'pdu7a'},
	{'intType':'physical:serial','intName':'s36','intLabel':'pdu7b'},
	{'intType':'physical:serial','intName':'s37','intLabel':None},
	{'intType':'physical:serial','intName':'s38','intLabel':None},
	{'intType':'physical:serial','intName':'s39','intLabel':None},
	{'intType':'physical:serial','intName':'s40','intLabel':None},
	{'intType':'physical:serial','intName':'s41','intLabel':None},
	{'intType':'physical:serial','intName':'s42','intLabel':None},
	{'intType':'physical:serial','intName':'s43','intLabel':"r01-ts01"},
	{'intType':'physical:serial','intName':'s44','intLabel':None},
	{'intType':'physical:serial','intName':'s45','intLabel':'od02'},
	{'intType':'physical:serial','intName':'s46','intLabel':'oa02'},
	{'intType':'physical:serial','intName':'s47','intLabel':'oa04'},
	{'intType':'physical:serial','intName':'s48','intLabel':None}
]

class snapshotSNMP(object):
	responseDict={'primary':{},'secondary':{}} # Populated while we are running
	deviceList = [] # Dictionary of all IPs (key) and the associated device name and sequence var (value)
	thread_count = 4
	lock = threading.Lock()

	def poll(self, tempDict):

		ip=tempDict['ipv4address']
		name=tempDict['deviceName']
		letter=tempDict['deviceSequence']

		# Create snmp command generator
		cmdGen = cmdgen.CommandGenerator()
		# Run snmp command
		errorIndication, errorStatus, errorIndex, varBinds = cmdGen.getCmd(
				cmdgen.CommunityData('jtv'),
				cmdgen.UdpTransportTarget((ip, 161)),
				'.1.3.6.1.4.1.1718.3.2.4.1.12.1',
				'.1.3.6.1.4.1.1718.3.2.5.1.6.1.1',
				'.1.3.6.1.4.1.1718.3.2.5.1.6.1.2',
				'.1.3.6.1.4.1.1718.3.2.5.1.10.1.1',
				'.1.3.6.1.4.1.1718.3.2.5.1.10.1.2',
				'.1.3.6.1.4.1.1718.3.2.2.1.7.1.1'
			)
		tempArray={}
		if errorIndication:
			tempArray['error']=({'ERROR':"Query Error",'message':str(errorIndication)})
		else:
			if errorStatus:
				tempArray['error']=({'ERROR':"Query Error",'message':('%s at %s' % (
					errorStatus.prettyPrint(),
					errorIndex and varBinds[int(errorIndex)-1] or '?'
				))})
			else:
				tempArray['tempreture']=[]
				tempArray['humidity']=[]
				tempArray['power']=[]
				for key, val in varBinds:
					if '1.3.6.1.4.1.1718.3.2.4.1.12' in str(key):
						tempArray['sensorCount']=(int(str(val)))
					if '1.3.6.1.4.1.1718.3.2.5.1.6' in str(key):
						tempArray['tempreture'].append(int(str(val)))
					if '1.3.6.1.4.1.1718.3.2.5.1.10' in str(key):
						tempArray['humidity'].append(int(str(val)))
					if '1.3.6.1.4.1.1718.3.2.2.1.7' in str(key):
						tempArray['power'].append(int(str(val)))
		if letter == 'a' or letter == 'c':
			self.responseDict['primary'][name]=tempArray
		else:
			self.responseDict['secondary'][name]=tempArray

	def pop_queue(self):
		deviceDict = None
		self.lock.acquire() # Grab the lock.
		if self.deviceList:
			deviceDict = self.deviceList.pop()
		self.lock.release() # Release the lock
		return deviceDict

	def dequeue(self):
	    while True:
			deviceDict = self.pop_queue()
			if not deviceDict:
				return None
			self.poll(deviceDict)

	def start(self):
		threads = []
		for i in range(self.thread_count):
			# add threads to the thread array
			t = threading.Thread(target=self.dequeue)
			t.start()
			threads.append(t)
		# Wait for all threads
		[ t.join() for t in threads ]
		return self.responseDict

class threadedCommand(object):
        statusDict = {'success':[],'failure':{}}
        hosts = []
        thread_count = 4
        lock = threading.Lock()
        username = None
        password = None
        command = 'ostat all'
        ssh_newkey = 'Are you sure you want to continue connecting \(yes\/no\)? '

        # function runs command
        def runCommand(self,host):
                success = [False,"Error: Unknown Failure"];
                try:
                        #start SSH session
                        sshSession = pexpect.spawn('ssh %s@%s' % (self.username,host))
                        responseIndex = sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

                        # accept new ssh key
                        if responseIndex == 0:
                                sshSession.sendline('yes')
                                # re-run expect to process failure or password
                                responseIndex=sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

                        # respond to password request
                        if responseIndex == 1:
                                sshSession.sendline(self.password)
                        elif responseIndex == 2:
                                success = [False,"Error: Password Request error, found EOF"];

                        sshSession.expect("Switched CDU: ")
                        sshSession.sendline(self.command)
                        responseIndex = sshSession.expect(['Command successful','Invalid'])

                        if responseIndex == 0: #Command completed successfully
                                success = [True];
                        elif responseIndex == 1:
                                success = [False,"Error: Command Failure on Device"];

                except pexpect.TIMEOUT:
                        success = [False,"Error: Timeout"];
                except (pexpect.EOF, pexpect.TIMEOUT), e:
                        success = [False,"Error: General Error with PExpect"];
                return success

        def popQueue(self):
                hostname = None
                self.lock.acquire()
                if self.hosts:
                        hostname = self.hosts.pop()
                self.lock.release()
                return hostname

        def deQueue(self):
                while True:
                        hostname = self.popQueue()
                        if not hostname:
                                return None

                        # place hostnames in appropraite dict keys upon run
                        print str("Running command '" + self.command + "' against host " + hostname)
                        response=self.runCommand(hostname)
                        if response[0]:
                                self.statusDict['success'].append(hostname)
                        elif not response[0]:
                                self.statusDict['failure'][hostname]=response[1]

        def start(self):
                threads = []
                for i in range(self.thread_count):
                        t = threading.Thread(target=self.deQueue)
                        t.start()
                        threads.append(t)
                [t.join() for t in threads]
                return self.statusDict

class massCommandForm(Form):
    username = TextField('Device Username', [InputRequired()])
    password = PasswordField('Device Password', [InputRequired()])
    commandString = TextField('Command', [InputRequired()])
    targetType = SelectField(
    	'Target Devices',
    	choices=[
    		('servertech_3_single','ServerTech CDUs (sentry3)')
    	]#,('cyclade','Cyclades'),('opengear','OpenGear')]
    )



def ipmiBlink(ip, user, passw, value):
	# note: value should be 'force' or an int >= 0
	ret = subprocess.call(['ipmitool', '-H', ip, '-U', user, '-P', passw, 'chassis', 'identify', str(value)], \
		stdout=open('/dev/null', 'w'), stderr=open('/dev/null', 'w'))
	# return boolean for success(true)/fail(false)
	return ret == 0

@tools.route('/tools/blinkStart', methods=['GET'])
def blinkStart():
	if current_user.is_authenticated:
		locationName = request.values.get('ip')
		success = ipmiBlink(locationName, ipmi_username, ipmi_password, 'force')
		return jsonify(success=success)
	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))

@tools.route('/tools/blinkStop', methods=['GET'])
def blinkStop():
	if current_user.is_authenticated:
		locationName = request.values.get('ip')
		success = ipmiBlink(locationName, ipmi_username, ipmi_password, 0)
		return jsonify(success=success)
	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))

def createBaseRecords(ipv4_address,full_name):
	baseRecordText = ("arecord," + full_name + "," + ipv4_address + "\n")
	ip_seg=ipv4_address.split('.')
	baseRecordText += ("ptrrecord," + str(ip_seg[3])+"."+str(ip_seg[2])+"."+str(ip_seg[1])+"."+str(ip_seg[0])+".in-addr.arpa,"+full_name+"\n")
	return str(baseRecordText)

def createCNAME(full_name,referenceName):
	return str("cnamerecord,"+full_name+","+referenceName+"\n")

def increment_IP_seg3(ipv4_address):
	ip_seg=ipv4_address.split('.')
	ip_seg[3]=int(ip_seg[3])+1
	return '.'.join([str(ip_seg[0]),str(ip_seg[1]),str(ip_seg[2]),str(ip_seg[3])])

def pop_exists(code):
	cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
	cursor = cnx.cursor(dictionary=True)
	locationQuery = ("select locationCode FROM location;")
	try:
		cursor.execute(locationQuery)
		locationFullResult=cursor.fetchall()
	except:
		return "error: " + str(sys.exc_info())
		cursor.close()
		cnx.close()
	locationCodeList=[]
	for itemDict in locationFullResult:
		locationCodeList.append(itemDict['locationCode'])
	if code in locationCodeList:
		return 1
	else:
		return 0


def db_insert(table,values_dict):
	cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
	cursor = cnx.cursor(dictionary=True)
	addString = "INSERT INTO " + str(table) + " ("
	keyString=""
	x=0
	for key,value in values_dict.iteritems():
		if (value != 'None') and (value is not None):
		    # add commas 
		    if x > 0:
		        addString+=", "
		        keyString+=", "
		    # add key to input field set
		    addString+=str(key)
		    # add values substitution fields based on keys (adjusting for IP formatting with INET)
		    if (key == 'ipv4Address') or (key=='ipv4Gateway'):
		        keyString+="INET_ATON(%("+str(key)+")s)"
		    else:
		        keyString+="%("+str(key)+")s"
		    x+=1
	addString+=") VALUES ("
	addString+=str(keyString)
	addString+=")"
	try:
		cursor.execute(addString,values_dict)
		cnx.commit()
		return cursor.lastrowid
	except:
		cursor.close()
		cnx.close()
		print 'ERROR: ' + str(sys.exc_info())
		return 0

@tools.route('/tools/pop_add', methods=['GET','POST'])
def pop_add():
	if current_user.is_authenticated:
		if request.method == 'POST':
			newPOPdict = {
				'code' : request.values.get('popCode'),
				'version' : str(request.values.get('popVersion')),
				'status' : request.values.get('popStatus'),
				'subnet' : request.values.get('popSubnet'),
				'count' : int(request.values.get('serverCount'))
			}
			newPOPdict['baseSubnetList'] = newPOPdict['subnet'].split('.')

			# Check if POP already exists
			if pop_exists(newPOPdict['code']):
				print "ERROR: " + str(current_user.username) + " attempted to add POP that already esists \(" + str(newPOPdict['code']) + "\)"
				return "Failed to add template - POP already exists"
			else:


				def addDevices(rackID,locationCode,deviceList,version,rackNumber,subnetString,incrementer):
					print str(current_user.username)+" adding devices for "+str(locationCode)+" rack "+str(rackNumber)
					for deviceDict in deviceList:
						valueDict_device = {
							'rackID' : rackID,
							'deviceTypeID' : deviceDict['deviceTypeID'],
							'uStart' : deviceDict['uStart'],
							'deviceName' : str(deviceDict['deviceName']+"."+locationCode.lower())
						}
						if valueDict_device['deviceTypeID'] is 2:
							valueDict_device['deviceName']='pdu'+str(rackNumber)+str(valueDict_device['deviceName'])
						else:
							valueDict_device['deviceName']='r'+str(rackNumber).zfill(2)+"-"+str(valueDict_device['deviceName'])
						deviceID_temp = db_insert('device',valueDict_device)
						if deviceID_temp == 0:
							return 0
						print str(current_user.username)+" added new device "+str(deviceID_temp)
						if valueDict_device['deviceTypeID'] is 2:
							valueDict_pdu = {
								'deviceID' : deviceID_temp,
								'intType' : 'logical:mgmt',
								'intName' : 'managementIP'
							}
							ipBlock=subnetString.split('.')
							if incrementer == 1:
								if str(deviceDict['deviceName']) == 'a':
									valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".10"
								elif str(deviceDict['deviceName']) == 'b':
									valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".11"
							elif incrementer == 2:
								if str(deviceDict['deviceName']) == 'a':
									valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".12"
								elif str(deviceDict['deviceName']) == 'b':
									valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".13"
							elif incrementer == 3:
								if str(deviceDict['deviceName']) == 'a':
									valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".14"
								elif str(deviceDict['deviceName']) == 'b':
									valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".15"
							else:
								tempDecrement=int(rackNumber)-3
								tempBlock2=int(ipBlock[2])+int(tempDecrement)
								if version == '3.7':
									if str(deviceDict['deviceName']) == 'a':
										valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(tempBlock2)+".10"
									elif str(deviceDict['deviceName']) == 'b':
										valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(tempBlock2)+".11"
								if version == '4.0':
									if str(deviceDict['deviceName']) == 'a':
										valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(tempBlock2)+".132"
									elif str(deviceDict['deviceName']) == 'b':
										valueDict_pdu['ipv4Address']=str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(tempBlock2)+".133"
							

							interfaceID_pdu = db_insert('interface',valueDict_pdu)
							print str(current_user.username)+" added new interface "+str(interfaceID_pdu)+" ith IP "+str(valueDict_pdu['ipv4Address'])

							# insert into interface
							# (deviceID,intType,intName,ipv4Address,intLabel)
							# values
							# (2693,'logical:mgmt','managementIP',INET_ATON('10.18.118.10'),'NULL'),

						if valueDict_device['deviceTypeID'] is 6:
							if version == '3.7':
								ipBlock=subnetString.split('.')
								valueDict_ts_ip = {
									'deviceID' : deviceID_temp,
									'intType' : 'logical:mgmt',
									'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".200",
									'intName' : 'managementIP'
								}
								interfaceID_ts_ip = db_insert('interface',valueDict_ts_ip)
								print str(current_user.username)+" added new interface "+str(interfaceID_ts_ip)+" ith IP "+str(valueDict_ts_ip['ipv4Address'])
								for interfaceDict in quartet_037_ts:
									tempFourthOctet = 200 + int(interfaceDict['intName'][1:])
									valueDict_ts_con = {
										'deviceID' : deviceID_temp,
										'intType' : interfaceDict['intType'],
										'intName' : interfaceDict['intName'],
										'intLabel' : interfaceDict['intLabel'],
										'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+"."+str(tempFourthOctet)
									}
									interfaceID_ts_con = db_insert('interface',valueDict_ts_con)
									print str(current_user.username)+" added new interface "+str(interfaceID_ts_con)+" ith IP "+str(valueDict_ts_con['ipv4Address'])
							elif version == '4.0':
								ipBlock=subnetString.split('.')
								if deviceDict['deviceName'] == "ts01":
									valueDict_ts_ip = {
										'deviceID' : deviceID_temp,
										'intType' : 'logical:mgmt',
										'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".150",
										'intName' : 'managementIP'
									}
									interfaceID_ts_ip = db_insert('interface',valueDict_ts_ip)
									print str(current_user.username)+" added new interface "+str(interfaceID_ts_ip)+" ith IP "+str(valueDict_ts_ip['ipv4Address'])
									for interfaceDict in quartet_040_ts1:
										tempFourthOctet = 150 + int(interfaceDict['intName'][1:])
										valueDict_ts_con = {
											'deviceID' : deviceID_temp,
											'intType' : interfaceDict['intType'],
											'intName' : interfaceDict['intName'],
											'intLabel' : interfaceDict['intLabel'],
											'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+"."+str(tempFourthOctet)
										}
										interfaceID_ts_con = db_insert('interface',valueDict_ts_con)
										print str(current_user.username)+" added new interface "+str(interfaceID_ts_con)+" ith IP "+str(valueDict_ts_con['ipv4Address'])
								elif deviceDict['deviceName'] == "ts02":
									valueDict_ts_ip = {
										'deviceID' : deviceID_temp,
										'intType' : 'logical:mgmt',
										'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".200",
										'intName' : 'managementIP'
									}
									interfaceID_ts_ip = db_insert('interface',valueDict_ts_ip)
									print str(current_user.username)+" added new interface "+str(interfaceID_ts_ip)+" ith IP "+str(valueDict_ts_ip['ipv4Address'])
									for interfaceDict in quartet_040_ts2:
										tempFourthOctet = 200 + int(interfaceDict['intName'][1:])
										valueDict_ts_con = {
											'deviceID' : deviceID_temp,
											'intType' : interfaceDict['intType'],
											'intName' : interfaceDict['intName'],
											'intLabel' : interfaceDict['intLabel'],
											'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+"."+str(tempFourthOctet)
										}
										interfaceID_ts_con = db_insert('interface',valueDict_ts_con)
										print str(current_user.username)+" added new interface "+str(interfaceID_ts_con)+" ith IP "+str(valueDict_ts_con['ipv4Address'])
							elif (version == 'duet4.0-42') or (version == 'duet4.0-46'):
								ipBlock=subnetString.split('.')
								valueDict_ts_ip = {
									'deviceID' : deviceID_temp,
									'intType' : 'logical:mgmt',
									'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+".200",
									'intName' : 'managementIP'
								}
								interfaceID_ts_ip = db_insert('interface',valueDict_ts_ip)
								print str(current_user.username)+" added new interface "+str(interfaceID_ts_ip)+" ith IP "+str(valueDict_ts_ip['ipv4Address'])
								for interfaceDict in duet_040_ts:
									tempFourthOctet = 200 + int(interfaceDict['intName'][1:])
									valueDict_ts_con = {
										'deviceID' : deviceID_temp,
										'intType' : interfaceDict['intType'],
										'intName' : interfaceDict['intName'],
										'intLabel' : interfaceDict['intLabel'],
										'ipv4Address' : str(ipBlock[0])+"."+str(ipBlock[1])+"."+str(ipBlock[2])+"."+str(tempFourthOctet)
									}
									interfaceID_ts_con = db_insert('interface',valueDict_ts_con)
									print str(current_user.username)+" added new interface "+str(interfaceID_ts_con)+" ith IP "+str(valueDict_ts_con['ipv4Address'])
							# elif version == '4.0':
							# 	print "Needs to add TS for 4.0 quartet"
					return 1

				# Create DICT of general location information
				valueDict_Location={}
				if newPOPdict['version'] == "3.7":
					valueDict_Location = {
						'locationCode' : newPOPdict['code'].upper(),
						'locationStatus' : newPOPdict['status'],
						'locationNotes' : str("POP Version 3.7")
					}
				elif newPOPdict['version'] == "4.0":
					valueDict_Location = {
						'locationCode' : newPOPdict['code'].upper(),
						'locationStatus' : newPOPdict['status'],
						'locationNotes' : str("POP Version 4.0")
					}
				elif newPOPdict['version'] == "duet4.0-46":
					valueDict_Location = {
						'locationCode' : newPOPdict['code'].upper(),
						'locationStatus' : newPOPdict['status'],
						'locationNotes' : str("Deet Version 4.0 (46U Version)")
					}
				elif newPOPdict['version'] == "duet4.0-42":
					valueDict_Location = {
						'locationCode' : newPOPdict['code'].upper(),
						'locationStatus' : newPOPdict['status'],
						'locationNotes' : str("Deet Version 4.0 (42U Version)")
					}
				elif newPOPdict['version'] == "base":
					valueDict_Location = {
						'locationCode' : newPOPdict['code'].upper(),
						'locationStatus' : newPOPdict['status'],
						'locationNotes' : str("")
					}

				# Add POP
				locationID_new = db_insert('location',valueDict_Location)
				print "Added new pop: "+str(newPOPdict['code'])+" (ID:"+str(locationID_new)+")"
				if locationID_new == 0:
					print "ERROR: failed insert of new location"
					return "Failed to add template - POP creation failed at location insert"

				if (newPOPdict['version'] == "3.7") or (newPOPdict['version'] == "4.0"):
					# Add first rack
					valueDict_core1 = {
						'locationID' : locationID_new,
						'uCount' : 46,
						'rackName' : str("r1.01"),
						'rackNotes' : str("Core 1"),
						'rackSequenceNo' : str("1"),
						'rackSubnet' : str(newPOPdict['subnet']+"/24"),
						'rackStatus' : newPOPdict['status']
					}
					rackID_core1 = db_insert('rack',valueDict_core1)
					print str(current_user.username)+" added new core1 rack: " + str(rackID_core1)
					if newPOPdict['version'] == "3.7":
						addDevices(rackID_core1,newPOPdict['code'],quartet_037_core1,'3.7',1,valueDict_core1['rackSubnet'],1)
					elif newPOPdict['version'] == "4.0":
						addDevices(rackID_core1,newPOPdict['code'],quartet_040_core1,'4.0',1,valueDict_core1['rackSubnet'],1)

					# Add second rack
					valueDict_core2 = {
						'locationID' : locationID_new,
						'uCount' : 46,
						'rackName' : str("r1.02"),
						'rackNotes' : str("Core 2"),
						'rackSequenceNo' : str("2"),
						'rackSubnet' : str(newPOPdict['subnet']+"/24"),
						'rackStatus' : newPOPdict['status']
					}
					rackID_core2 = db_insert('rack',valueDict_core2)
					print str(current_user.username)+" added new core2 rack: " + str(rackID_core2)
					if newPOPdict['version'] == "3.7":
						addDevices(rackID_core2,newPOPdict['code'],quartet_037_core2,'3.7',2,valueDict_core2['rackSubnet'],2)
					elif newPOPdict['version'] == "4.0":
						addDevices(rackID_core2,newPOPdict['code'],quartet_040_core2,'4.0',2,valueDict_core2['rackSubnet'],2)

					# Add third rack
					valueDict_dmarc = {
						'locationID' : locationID_new,
						'uCount' : 46,
						'rackName' : str("r1.03"),
						'rackNotes' : str("DMARC"),
						'rackSequenceNo' : str("3"),
						'rackSubnet' : str(newPOPdict['subnet']+"/24"),
						'rackStatus' : newPOPdict['status']
					}
					rackID_dmarc = db_insert('rack',valueDict_dmarc)
					print str(current_user.username)+" added new dmarc rack: " + str(rackID_dmarc)
					if newPOPdict['version'] == "3.7":
						addDevices(rackID_dmarc,newPOPdict['code'],quartet_037_dmarc,'3.7',3,valueDict_dmarc['rackSubnet'],3)
					elif newPOPdict['version'] == "4.0":
						addDevices(rackID_dmarc,newPOPdict['code'],quartet_040_dmarc,'4.0',3,valueDict_dmarc['rackSubnet'],3)

					# Add remaining racks (servers)
					counterX = 1
					while counterX <= newPOPdict['count']:
						tempSequenceNo=counterX+3
						tempSubnetOctet=int(newPOPdict['baseSubnetList'][2])+counterX
						valueDict_server = {
							'locationID' : locationID_new,
							'uCount' : 46,
							'rackName' : str("r1.0"+str(tempSequenceNo)),
							'rackNotes' : str("SERVER Rack "+str(counterX)),
							'rackSequenceNo' : str(tempSequenceNo),
							'rackSubnet' : str(str(int(newPOPdict['baseSubnetList'][0]))+"."+str(int(newPOPdict['baseSubnetList'][1]))+"."+str(tempSubnetOctet)+".128/25"),
							'rackStatus' : newPOPdict['status']
						}
						rackID_server = db_insert('rack',valueDict_server)
						print str(current_user.username)+" added new server rack: "+str(rackID_server)
						if newPOPdict['version'] == "3.7":
							addDevices(rackID_server,newPOPdict['code'],quartet_037_server,'3.7',tempSequenceNo,valueDict_server['rackSubnet'],4)
						if newPOPdict['version'] == "4.0":
							addDevices(rackID_server,newPOPdict['code'],quartet_040_server,'4.0',tempSequenceNo,valueDict_server['rackSubnet'],4)
						counterX+=1

				# Rack Logic for Duet Templates
				elif (newPOPdict['version'] == "duet4.0-42") or (newPOPdict['version'] == "duet4.0-46"):
					# Add first rack
					valueDict_core1 = {
						'locationID' : locationID_new,
						'rackName' : str("r1.01"),
						'rackNotes' : str("Core 1"),
						'rackSequenceNo' : str("1"),
						'rackSubnet' : str(newPOPdict['subnet']+"/24"),
						'rackStatus' : newPOPdict['status']
					}

					if newPOPdict['version'] == "duet4.0-42":
						valueDict_core1['uCount']=42;
					elif newPOPdict['version'] == "duet4.0-46":
						valueDict_core1['uCount']=46;

					rackID_core1 = db_insert('rack',valueDict_core1)
					print str(current_user.username)+" added new core1 rack: " + str(rackID_core1)
					if newPOPdict['version'] == "duet4.0-42":
						addDevices(rackID_core1,newPOPdict['code'],duet_040_core_42,'duet4.0-42',1,valueDict_core1['rackSubnet'],1)
					elif newPOPdict['version'] == "duet4.0-46":
						addDevices(rackID_core1,newPOPdict['code'],duet_040_core_46,'duet4.0-46',1,valueDict_core1['rackSubnet'],1)

					# Add remaining racks (servers)
					counterX = 1
					while counterX <= newPOPdict['count']:
						tempSequenceNo=counterX+1
						tempSubnetOctet=int(newPOPdict['baseSubnetList'][2])+counterX
						valueDict_server = {
							'locationID' : locationID_new,
							'rackName' : str("r1.0"+str(tempSequenceNo)),
							'rackNotes' : str("SERVER Rack "+str(counterX)),
							'rackSequenceNo' : str(tempSequenceNo),
							'rackSubnet' : str(str(int(newPOPdict['baseSubnetList'][0]))+"."+str(int(newPOPdict['baseSubnetList'][1]))+"."+str(tempSubnetOctet)+".128/25"),
							'rackStatus' : newPOPdict['status']
						}
						print valueDict_server['rackSubnet']

						if newPOPdict['version'] == "duet4.0-42":
							valueDict_server['uCount']=42;
						elif newPOPdict['version'] == "duet4.0-46":
							valueDict_server['uCount']=46;

						rackID_server = db_insert('rack',valueDict_server)
						print str(current_user.username)+" added new server rack: "+str(rackID_server)
						if newPOPdict['version'] == "duet4.0-42":
							addDevices(rackID_server,newPOPdict['code'],duet_040_server_42,'duet4.0-42',tempSequenceNo,valueDict_server['rackSubnet'],2)
						elif newPOPdict['version'] == "duet4.0-46":
							addDevices(rackID_server,newPOPdict['code'],duet_040_server_46,'duet4.0-46',tempSequenceNo,valueDict_server['rackSubnet'],2)
						counterX+=1


				print "NEW POP ADDED BY TEMPLATE - site "+str(newPOPdict['code'])+" (ID:"+str(locationID_new)+") added by "+str(current_user.username)

			return "Successfully added new POP: " + str(newPOPdict['code']) + " (" + str(locationID_new) +")"
		else:
			return render_template('pop_add.html')
	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))

@tools.route('/tools/dns_utility')
def dns_utility():
	if current_user.is_authenticated:
		flash('Due to inconsistancy in data, please ensure interface information is correct before use','warning')
		return render_template('dns_utility.html')
	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))

@tools.route('/tools/generateDNScsv', methods=['GET','POST'])
def generateDNScsv():
	if current_user.is_authenticated:
		deviceListString = request.values.get('devices')
		if not deviceListString:
			return "error: expected argument not found"
		deviceList = deviceListString[1:-1].split(',')
		# deviceList = list(str(deviceListString))
		print deviceList

		returnText = "header-arecord,fqdn*,address*\nheader-ptrrecord,fqdn*,dname\nheader-cnamerecord,fqdn*,canonical_name\n"

		cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
		cursor = cnx.cursor(dictionary=True)
		idQuery = ("select deviceID FROM device;")
		try:
			cursor.execute(idQuery)
			idResult=cursor.fetchall()
		except:
			return "error: " + str(sys.exc_info())
			cursor.close()
			cnx.close()

		for entry in deviceList:
			if not any(tempDict["deviceID"]==int(entry) for tempDict in idResult):
				return "error: device with ID " + str(entry) + " not found"

			entryQuery = ("select deviceName,deviceRole,INET_NTOA(ipv4address) AS ipv4address,locationCode " \
				+ "FROM device " \
				+ "JOIN deviceType ON deviceType.deviceTypeID=device.deviceTypeID " \
				+ "JOIN interface ON device.deviceID=interface.deviceID " \
				+ "JOIN rack ON rack.rackID=device.rackID " \
				+ "JOIN location ON rack.locationID=location.locationID " \
				+ "WHERE intType='logical:mgmt' " \
				+ "AND deviceRole IN ('TS','CDU') "
				+ "AND device.deviceID=" + str(entry))	
			try:
				cursor.execute(entryQuery)
				deviceResult=cursor.fetchall()
			except:
				return "error: " + str(sys.exc_info())
				cursor.close()
				cnx.close()

			returnText += createBaseRecords(deviceResult[0]['ipv4address'], deviceResult[0]['deviceName']+".justin.tv")

			# Address serial interfaces on TSs
			if deviceResult[0]["deviceRole"] == 'TS':
				tsIntQuery= ("select intType,intName,intLabel,INET_NTOA(ipv4address) AS ipv4address " \
					+ "FROM interface WHERE deviceID=" + str(entry))
				try:
					cursor.execute(tsIntQuery)
					interfaceResult=cursor.fetchall()
				except:
					return "error: " + str(sys.exc_info())
					cursor.close()
					cnx.close()

				# loop through interface responses for individual DNS records
				for interface in interfaceResult:
					if interface['intType'] == 'physical:serial':
						returnText+=createBaseRecords(interface['ipv4address'], interface['intName']+"."+deviceResult[0]['deviceName']+".justin.tv")
						if interface['intLabel'] is not None and interface['intLabel']!="":

							# checks for label already containing 'con' - this needs to be the case if there are more than one console port to that device
							tempLabel = ""
							if not interface['intLabel'].startswith('con'):
								tempLabel = str("con."+interface['intLabel'])
							else:
								tempLabel = interface['intLabel']
							returnText+=createCNAME(str(tempLabel+"."+deviceResult[0]['locationCode'].lower()+".justin.tv"),str(interface['intName']+"."+deviceResult[0]['deviceName']+".justin.tv"))	

		cursor.close()
		cnx.close()

		# Create custom response from generated csv text
		response = make_response(returnText)

		# Set response to be a file with a generated filename and a .csv extension
		response.headers["Content-Disposition"] = "attachment; filename=dcops-infoblox_import-" \
			+ time.strftime("%d/%m/%Y") + "_" + time.strftime("%H:%M:%S") + ".csv"

		return response
		#return "<pre>" + returnText + "</pre>"

	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))

@tools.route('/tools/popSnapshot', methods=['GET', 'POST'])
def popSnapshot():
	if current_user.is_authenticated:
		locationName = request.values.get('name')
		deviceList={}
		cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
		cursor = cnx.cursor(dictionary=True)
		query = ("SELECT deviceName,deviceSequence,INET_NTOA(ipv4address) AS 'ipv4address' FROM device "\
			+ "JOIN deviceType ON device.deviceTypeID=deviceType.deviceTypeID "\
			+ "JOIN rack ON device.rackID=rack.rackID "\
			+ "JOIN location ON rack.locationID=location.locationID "\
			+ "JOIN interface ON device.deviceID=interface.deviceID "\
			+ "WHERE deviceRole='CDU' "\
			+ "AND rackStatus='current' "\
			+ "AND deviceStatus='current' "\
			+ "AND intType='logical:mgmt' "\
			+ "AND locationCode='"+str(locationName)+"'")
		#print query
		try:
			cursor.execute(query)
			deviceList=cursor.fetchall()
		except:
			cursor.close()
			cnx.close()
			return jsonify(ERROR="Query Error",message=sys.exc_info())
		cursor.close()
		cnx.close()

		if len(deviceList) > 20:
			return jsonify(ERROR="Query Error",message="Selected site has more than 20 PDUs - snapshot takes too long to run with this number of PDUs")

		######## call threaded class
		snmpPoll = snapshotSNMP()
		snmpPoll.thread_count = 8
		snmpPoll.deviceList = deviceList

		detailedDict=snmpPoll.start()
		########

		return jsonify(TestResult=detailedDict)

		averageDict={'primary':{},'secondary':{}}

		humidityCount=0
		humidityTotal=0
		tempCount=0
		tempTotal=0
		powerCount=0
		powerTotal=0
		for tempDictKey, tempDictValue in detailedDict['primary'].iteritems():
			if tempDictKey:
				for tempInt in tempDictValue['humidity']:
					humidityTotal=humidityTotal+int(tempInt)
					humidityCount=humidityCount+1
				for tempInt in  tempDictValue['tempreture']:
					tempTotal=tempTotal+int(tempInt)
					tempCount=tempCount+1
				for tempInt in  tempDictValue['power']:
					powerTotal=powerTotal+int(tempInt)
					powerCount=powerCount+1

		if humidityCount == 0:
			averageDict['primary']['humidity']="ERROR"
		else:
			averageDict['primary']['humidity']=humidityTotal/humidityCount

		if tempCount == 0:
			averageDict['primary']['tempreture']="ERROR"
		else:
			averageDict['primary']['tempreture']=tempTotal/tempCount
			
		if powerCount == 0:
			averageDict['primary']['power']="ERROR"
		else:
			averageDict['primary']['power']=powerTotal/powerCount

		humidityCount=0
		humidityTotal=0
		for tempDictKey, tempDictValue in detailedDict['secondary'].iteritems():
			if tempDictKey:
				for tempInt in  tempDictValue['humidity']:
					humidityTotal=humidityTotal+int(tempInt)
					humidityCount=humidityCount+1
				for tempInt in  tempDictValue['tempreture']:
					tempTotal=tempTotal+int(tempInt)
					tempCount=tempCount+1
				for tempInt in  tempDictValue['power']:
					powerTotal=powerTotal+int(tempInt)
					powerCount=powerCount+1

		if humidityCount == 0:
			averageDict['secondary']['humidity']="ERROR"
		else:
			averageDict['secondary']['humidity']=humidityTotal/humidityCount

		if tempCount == 0:
			averageDict['secondary']['tempreture']="ERROR"
		else:
			averageDict['secondary']['tempreture']=tempTotal/tempCount

		if powerCount == 0:
			averageDict['secondary']['power']="ERROR"
		else:
			averageDict['secondary']['power']=powerTotal/powerCount

		return jsonify(POPAverage=averageDict,details=detailedDict)
	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))

@tools.route('/tools/massCommand', methods=['GET','POST'])
def massCommand():

	# STILL NEED....
	#		modal popup when clicking a history row (show successes and failures appropraitely)	
	#		investiage pdu deviceType for differences - setup different slectors appropriately
	#		implement command across all Cyclades
	#		adjust pexpect script to notify when login fails

	if current_user.is_authenticated:

		# = request.form.get('contactEmail')

		form = massCommandForm(request.form)

		try:
			cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
			cursor = cnx.cursor(dictionary=True)

			if request.method == 'POST' and form.validate():
				postData={}
				postData['username'] = request.form.get('username')
				postData['password'] = request.form.get('password')
				postData['targetType'] = request.form.get('targetType')
				postData['commandString'] = request.form.get('commandString')

				print postData

				if postData['targetType'] == 'servertech-3':

					add_string = str("INSERT INTO massCommand " \
						+ "(commandStatus, commandUsername, webUser, targetDeviceType, "
						+ " commandString) " \
						+ "VALUES (%(commandStatus)s, %(commandUsername)s, " \
						+ " %(webUser)s, %(target)s, %(commandString)s)")
					add_data = {
						'commandStatus': 'started',
						'commandUsername': postData['username'],
						'webUser': current_user.username,
						'target': postData['targetType'],
						'commandString': postData['commandString']
					}

					cursor.execute(add_string,add_data)

					cnx.commit()

					cdu_query_string = str("SELECT INET_NTOA(ipv4address) as ipv4address " \
						+ "FROM device " \
						+ "JOIN interface on device.deviceID=interface.deviceID " \
						+ "JOIN deviceType on device.deviceTypeID=deviceType.deviceTypeID " \
						+ "WHERE deviceRole='CDU' " \
						+ "AND deviceMake='ServerTech' " \
						+ "AND softwareVersion='Sentry3-7.0t' " \
						+ "AND intType='logical:mgmt'")

					cursor.execute(cdu_query_string)
					cdu_dict=cursor.fetchall()

					cdu_list=[]
					for entryDict in cdu_dict:
							cdu_list.append(entryDict['ipv4address'])

					print cdu_list

					hostnameList=['pdu2a.sjc02.justin.tv','pdu2b.sjc02.justin.tv','pdu11a.sjc02.justin.tv','pdu11b.sjc02.justin.tv']

					run = threadedCommand()
					run.threaded_count = 4
					# run.hosts = hostnameList
					run.hosts = cdu_list
					run.username = postData['username']
					run.password = postData['password']
					run.command = postData['commandString']

					resultDict = run.start()

					update_string = str('UPDATE massCommand SET commandStatus=%(commandStatus)s, ' \
						+ 'commandResult=%(commandResult)s, ' \
						+ 'completeTime=%(completeTime)s ' \
						+ 'WHERE commandID=' +str(cursor.lastrowid))
					update_data = {
						'commandStatus': 'complete',
						'commandResult': str(resultDict),
						'completeTime': time.strftime('%Y-%m-%d %H:%M:%S')
					} 

					cursor.execute(update_string,update_data)
					cnx.commit()

					flash('Mass Command Processed','success')
			
			else:
				flash('NOTE: Only one-line command accepted','warning')
			 	flash('NOTE: This command will be run on every device matching the selected type','warning')
			# 	flash('This command is currently under developement','danger')
			# 	flash('Current test version only hits 4 devices','danger')

			query = ("SELECT * FROM massCommand ORDER BY createTime DESC")
			try:
				cursor.execute(query)
				commandHistory=cursor.fetchall()
			except: 
				cursor.close()
				cnx.close()
				print "ERROR:", sys.exc_info()
				flash('ERRROR: Command History Query Failure','danger')
				return redirect(url_for('data.home'))

			cursor.close()
			cnx.close()

		except mysql.connector.errors.ProgrammingError:
			flash("Error Storing Command Information in MYSQL (command still completed)", 'danger')
			return redirect(url_for('data.home'))

		return render_template('mass_command.html', form=form,commandHistory=commandHistory)

	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))

class massManagementForm(Form):
	# Select Use Of Form
    targetType = SelectField(
    	'Target Devices',
    	[InputRequired()],
    	choices=[
    		('servertech3_single','ServerTech CDUs (sentry3) - Single Command'),
    		('servertech3_syslog','ServerTech CDUs (sentry3) - Syslog Update'),
    		('opengear_addUser','OpenGear Terminal Servers - Add User'),
    		('opengear_keyUpdate','OpenGear Terminal Servers - Update User Key'),
    		('opengear_keyUpdateManual','OpenGear Terminal Servers - Manual Update User Key'),
    		('opengear_delUser','OpenGear Terminal Servers - Remove User')
    	]#,('cyclade','Cyclades'),('opengear','OpenGear')]
		
	)

	# RADIUS Credentials
    radiusUsername = TextField('RADIUS Username')
    radiusPassword = PasswordField('RADIUS Password')

    # General Command
    commandString = TextField('Command')

    # SYSLOG information and secret
    syslogServer = TextField('Syslog Server IP')
    syslogClassifier = SelectField(
    	'Syslog Classifier',
    	choices=[
    		('primary','Primary Server'),
    		('secondary','Secondary Server')
    	]
    )
    syslogPassword = PasswordField('Syslog Password')

    # OpenGear User Management
    opengearUser = TextField('OpenGear Username')
    opengearUserKey = TextField('User SSH Key for OpenGear')
    opengearUserGroup = SelectField(
    	'OpenGear User Team (Group)',
    	choices=[
    		('dcops-team','DCOPs'),
    		('neteng','Networking')
    	]
    )

class threadedCommand_serverTech(object):
	statusDict = {'success':[],'failure':{}}
	hosts = []
	thread_count = 16
	lock = threading.Lock()
	behavior = None
	username = "empty"
	password = "empty"
	input_01 = "empty"
	input_02 = "empty"
	input_03 = "empty"
	ssh_newkey = 'Are you sure you want to continue connecting \(yes\/no\)? '

	# function runs command
	def runCommand(self,host):
		success = [False,"Error: Unknown Failure"];
		try:
			#start SSH session
			sshSession = pexpect.spawn('ssh %s@%s' % (self.username,host))
			responseIndex = sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

			# accept new ssh key
			if responseIndex == 0:
				sshSession.sendline('yes')
				# re-run expect to process failure or password
				responseIndex=sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

			# respond to password request
			if responseIndex == 1:
				sshSession.sendline(self.password)
			elif responseIndex == 2:
				success = [False,"Error: Password Request error, found EOF"]

			# expect standard CDU prompt
			sshSession.expect("Switched CDU: ")

			##########################################
			# Process commands
			##########################################
			if self.behavior == 'radius':
				sshSession.sendline(self.input_01)
				responseIndex_01 = sshSession.expect(['Command successful','Invalid'])
				if responseIndex_01 == 0: #Command completed successfully
					sshSession.sendline(self.input_02)
					responseIndex_02 = sshSession.expect([r'Enter Shared Secret \(48 characters max\):','Invalid'])
					if responseIndex_02 == 0: #Command completed successfully
						sshSession.sendline(self.input_03)
						responseIndex_03 = sshSession.expect(['Command successful','Invalid'])
						if responseIndex_03 == 0: #Command completed successfully
							success = [True];
						elif responseIndex_03 == 1:
							success = [False,"Error: Command 3 Failure on Device"]
					elif responseIndex_02 == 1:
						success = [False,"Error: Command 2 Failure on Device"]
				elif responseIndex_01 == 1:
					success = [False,"Error: Command 1 Failure on Device"]
			elif self.behavior == 'single':
				sshSession.sendline(self.input_01)
				print str("Running command \'" + self.input_01 +  "\' against host " + host)
				responseIndex_01 = sshSession.expect(['Command successful','Invalid'])
				#print sshSession.before
				if responseIndex_01 == 0: #Command completed successfully
					success = [True];
				elif responseIndex_01 == 1:
					success = [False,"Error: Command Failure on Device"]
			else:
				return [False,"Error: Unknown failure while logged onto device"]

			##########################################
			# End commands
			##########################################

		except pexpect.TIMEOUT:
			success = [False,"Error: Timeout"]
		except (pexpect.EOF, pexpect.TIMEOUT), e:
			success = [False,"Error: General Error with PExpect"]
		return success

	def popQueue(self):
		hostname = None
		self.lock.acquire()
		if self.hosts:
			hostname = self.hosts.pop()
		self.lock.release()
		return hostname

	def deQueue(self):
		while True:
			hostname = self.popQueue()
			if not hostname:
				return None
			# place hostnames in appropraite dict keys upon run
			response=self.runCommand(hostname)
			if response[0]:
				self.statusDict['success'].append(hostname)
			elif not response[0]:
				self.statusDict['failure'][hostname]=response[1]

	def start(self):
		threads = []
		for i in range(self.thread_count):
			t = threading.Thread(target=self.deQueue)
			t.start()
			threads.append(t)
		[t.join() for t in threads]
		return self.statusDict\


###################################################
###################################################
#### Update OpenGear Key
###################################################
###################################################
def openGearUpdateKey(user,key,target,force,*positional_parameters, **keyword_parameters):
	
	print "function Started for user " + str(user)

	sshUsername="DCOTooling"
	sshPassword="testCase20!6"
	ssh_newkey = 'Are you sure you want to continue connecting \(yes\/no\)? '

	tempFileName="/etc/config/users/DCOTooling/temp" \
		+"_key_"+str(user)+"-"+str(time.strftime("%H-%M-%S"))
	saveFileName="/etc/config/users/DCOTooling/"+str(time.strftime("%Y-%m-%d")) \
		+"_key_"+str(user)+"-"+str(time.strftime("%H-%M-%S"))

	# command variables
	command="sudo cp /etc/config/users/"+str(user) \
		+"/.ssh/authorized_keys "+str(saveFileName)
	command2="sudo cp /etc/config/users/"+str(user) \
		+"/.ssh/authorized_keys "+str(tempFileName)
	command3="sudo chown DCOTooling "+str(tempFileName)
	command4="echo '"+str(key)+"' > "+str(tempFileName)
	command5="sudo chown "+str(user)+" "+str(tempFileName)
	command6="sudo mv "+str(tempFileName)+" /etc/config/users/"+str(user)+"/.ssh/authorized_keys"

	
	sshSession = pexpect.spawn('/usr/bin/ssh -i '+str(openGear_priv)+' %s@%s' % (sshUsername,target))

	sshSession.logfile = open("/home/users/rwilkinson/openGearKeyUpdate.log", "w")
	#start SSH session
	responseIndex = sshSession.expect([ssh_newkey,'[pP]assword:','\$',pexpect.EOF], timeout=120)
	print sshSession.before

	# accept new ssh key
	if responseIndex == 0:
		sshSession.sendline('yes')
		# re-run expect to process failure or password
		responseIndex=sshSession.expect([ssh_newkey,'[pP]assword:',"\$",pexpect.EOF], timeout=120)

	# respond to password request
	if responseIndex == 1:
		sshSession.sendline(sshPassword)
	elif responseIndex == 3:
		print "Error: Password Request error, found EOF"
		return 1

	# expect standard CDU prompt
	# responseIndex = sshSession.expect("\$")


	# check if user exists
	sshSession.sendline("id -u "+str(user))
	responseIndex=sshSession.expect(['id: unknown user name: '+str(user),'\$'])
	print responseIndex
	# # respond to password request
	if responseIndex == 1:
		print "User Found"

		# send command 1
		sshSession.sendline(command)
		sshSession.expect("\$")
		# send command 2
		sshSession.sendline(command2)
		sshSession.expect("\$")
		# send command 3
		sshSession.sendline(command3)
		sshSession.expect("\$")
		# send command 4
		sshSession.sendline(command4)
		sshSession.expect("\$")
		# send command 5
		sshSession.sendline(command5)
		sshSession.expect("\$")
		# send command 6
		sshSession.sendline(command6)
		sshSession.expect("\$")
		return 0
	elif responseIndex == 0 and force == 0:
		print "User Not Found, not updating key"
		return 3
	elif responseIndex == 0 and force == 1:
		print "User Not Found, force option selected, creating user"

		# check function for group
		if ('opengearUserGroup' in keyword_parameters):
			# create user with provided group
			sshSession.sendline('/etc/scripts/user-add -g "' \
				+keyword_parameters['opengearUserGroup'] \
				+'" --password testUser! '+str(user))
		else:
			# create user without groups
			sshSession.sendline('/etc/scripts/user-add --password testUser! '+str(user))
		sshSession.expect("\$")


		# send command 1
		sshSession.sendline(command)
		sshSession.expect("\$")
		# send command 2
		sshSession.sendline(command2)
		sshSession.expect("\$")
		# send command 3
		sshSession.sendline(command3)
		sshSession.expect("\$")
		# send command 4
		sshSession.sendline(command4)
		sshSession.expect("\$")
		# send command 5
		sshSession.sendline(command5)
		sshSession.expect("\$")
		# send command 6
		sshSession.sendline(command6)
		sshSession.expect("\$")
		return 2

	# sudo cp /etc/config/users/rwilkinson/.ssh/authorized_keys /etc/config/users/DCOTooling/2016-11-16_key_rwilkinson
	return 1



@tools.route('/tools/mass_management', methods=['GET','POST'])
def massManagement():

	# STILL NEED....
	#		modal popup when clicking a history row (show successes and failures appropraitely)	
	#		investiage pdu deviceType for differences - setup different slectors appropriately
	#		implement command across all Cyclades - done?
	#		adjust pexpect script to notify when login fails

	if current_user.is_authenticated:

		form = massManagementForm(request.form)

		try:
			cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
			cursor = cnx.cursor(dictionary=True)

			if request.method == 'POST' and form.validate():
				postData={}
				postData['targetType'] = request.form.get('targetType')

				###################################################
				###################################################
				#### CDU one-line commands
				###################################################
				###################################################
				if postData['targetType'] == 'servertech3_single':

					postData['radiusUsername'] = request.form.get('radiusUsername')
					postData['radiusPassword'] = request.form.get('radiusPassword')
					postData['commandString'] = request.form.get('commandString')

					add_string = str("INSERT INTO massCommand " \
						+ "(commandStatus, commandUsername, webUser, targetDeviceType, "
						+ " commandString) " \
						+ "VALUES (%(commandStatus)s, %(commandUsername)s, " \
						+ " %(webUser)s, %(target)s, %(commandString)s)")
					add_data = {
						'commandStatus': 'started',
						'commandUsername': postData['radiusUsername'],
						'webUser': current_user.username,
						'target': postData['targetType'],
						'commandString': postData['commandString']
					}

					cursor.execute(add_string,add_data)

					cnx.commit()

					cdu_query_string = str("SELECT INET_NTOA(ipv4address) as ipv4address " \
						+ "FROM device " \
						+ "JOIN interface on device.deviceID=interface.deviceID " \
						+ "JOIN deviceType on device.deviceTypeID=deviceType.deviceTypeID " \
						+ "WHERE deviceRole='CDU' " \
						+ "AND deviceMake='ServerTech' " \
						+ "AND softwareVersion='Sentry3-7.0t' " \
						+ "AND intType='logical:mgmt'")

					try:
						cursor.execute(cdu_query_string)
						cdu_dict=cursor.fetchall()
					except:
						print "error: " + str(sys.exc_info())
						cursor.close()
						cnx.close()
						sys.exit()

					cdu_list=[]
					for entryDict in cdu_dict:
						cdu_list.append(entryDict['ipv4address'])

					hostnameList=['pdu2a.sjc02.justin.tv','pdu2b.sjc02.justin.tv','pdu11a.sjc02.justin.tv','pdu11b.sjc02.justin.tv']

					singleCommandRun = threadedCommand_serverTech()

					singleCommandRun.threaded_count = 16
					singleCommandRun.hosts = cdu_list
					#singleCommandRun.hosts = hostnameList
					singleCommandRun.username = postData['radiusUsername']
					singleCommandRun.password = postData['radiusPassword']
					singleCommandRun.behavior = 'single'
					singleCommandRun.input_01 = postData['commandString']

					resultDict = singleCommandRun.start()

					update_string = str('UPDATE massCommand SET commandStatus=%(commandStatus)s, ' \
						+ 'commandResult=%(commandResult)s, ' \
						+ 'completeTime=%(completeTime)s ' \
						+ 'WHERE commandID=' +str(cursor.lastrowid))
					update_data = {
						'commandStatus': 'complete',
						'commandResult': str(resultDict),
						'completeTime': time.strftime('%Y-%m-%d %H:%M:%S')
					} 

					cursor.execute(update_string,update_data)
					cnx.commit()

					flash('Mass Command Processed','success')

				###################################################
				###################################################
				#### CDU syslog changes
				###################################################
				###################################################
				elif postData['targetType'] == 'servertech3_syslog':

					postData['radiusUsername'] = request.form.get('radiusUsername')
					postData['radiusPassword'] = request.form.get('radiusPassword')
					postData['syslogServer'] = request.form.get('syslogServer')
					postData['syslogClassifier'] = request.form.get('syslogClassifier')
					postData['syslogPassword'] = request.form.get('syslogPassword')

					add_string = str("INSERT INTO massCommand " \
						+ "(commandStatus, commandUsername, webUser, targetDeviceType, "
						+ " commandString) " \
						+ "VALUES (%(commandStatus)s, %(commandUsername)s, " \
						+ " %(webUser)s, %(target)s, %(commandString)s)")
					add_data = {
						'commandStatus': 'started',
						'commandUsername': postData['radiusUsername'],
						'webUser': current_user.username,
						'target': postData['targetType'],
						'commandString': str("set radius " + postData['syslogClassifier'] + " server " + postData['syslogServer'])
					}

					cursor.execute(add_string,add_data)

					cnx.commit()

					cdu_query_string = str("SELECT INET_NTOA(ipv4address) as ipv4address " \
						+ "FROM device " \
						+ "JOIN interface on device.deviceID=interface.deviceID " \
						+ "JOIN deviceType on device.deviceTypeID=deviceType.deviceTypeID " \
						+ "WHERE deviceRole='CDU' " \
						+ "AND deviceMake='ServerTech' " \
						+ "AND softwareVersion='Sentry3-7.0t' " \
						+ "AND intType='logical:mgmt'")

					try:
						cursor.execute(cdu_query_string)
						cdu_dict=cursor.fetchall()
					except:
						print "error: " + str(sys.exc_info())
						cursor.close()
						cnx.close()
						sys.exit()

					cdu_list=[]
					for entryDict in cdu_dict:
						cdu_list.append(entryDict['ipv4address'])


					hostnameList=['pdu2a.sjc02.justin.tv','pdu2b.sjc02.justin.tv','pdu11a.sjc02.justin.tv','pdu11b.sjc02.justin.tv']

					singleCommandRun = threadedCommand_serverTech()

					singleCommandRun.threaded_count = 16
					singleCommandRun.hosts = cdu_list
					#singleCommandRun.hosts = hostnameList
					singleCommandRun.username = postData['radiusUsername']
					singleCommandRun.password = postData['radiusPassword']
					singleCommandRun.behavior = 'syslog'
					singleCommandRun.input_01 = str("set radius " + postData['syslogClassifier'] + " server " + postData['syslogServer'])
					singleCommandRun.input_02 = str("set radius " + postData['syslogClassifier'] + " secret")
					singleCommandRun.input_03 = postData['syslogPassword']

					resultDict = singleCommandRun.start()

					update_string = str('UPDATE massCommand SET commandStatus=%(commandStatus)s, ' \
						+ 'commandResult=%(commandResult)s, ' \
						+ 'completeTime=%(completeTime)s ' \
						+ 'WHERE commandID=' +str(cursor.lastrowid))
					update_data = {
						'commandStatus': 'complete',
						'commandResult': str(resultDict),
						'completeTime': time.strftime('%Y-%m-%d %H:%M:%S')
					} 

					cursor.execute(update_string,update_data)
					cnx.commit()

					flash('Mass Command Processed','success')

				###################################################
				###################################################
				#### Update OpenGear Key
				###################################################
				###################################################
				elif postData['targetType'] == 'opengear_keyUpdateManual':

					postData['opengearUser'] = request.form.get('opengearUser')
					postData['opengearUserGroup'] = request.form.get('opengearUserGroup')
					postData['opengearUserKey'] = request.form.get('opengearUserKey')

					print postData

					print "Running key update test"

					updateResult = openGearUpdateKey(postData['opengearUser'],
						postData['opengearUserKey'],
						'10.24.44.200',
						0,
						opengearUserGroup=postData['opengearUserGroup'])

					if updateResult == 0:
						flash("Completed key update (exit status: " + str(updateResult)+")",'success')
					elif updateResult == 1:
						flash("General failure (exit status: " + str(updateResult)+")",'warning')
					elif updateResult == 2:
						flash("User not found, User added, Key Updatd (exit status: " + str(updateResult) +")",'success')
					elif updateResult == 3:
						flash("Failed, User not found (exit status: " + str(updateResult)+')','warning')




			elif request.method == 'POST' and form.errors:
				flash("Form Error", 'danger')
			
			else:
			 	flash('This command is currently under developement','danger')
				flash('NOTE: Only one-line command accepted','warning')
			 	flash('NOTE: This command will be run on every device matching the selected type','warning')
			# 	flash('Current test version only hits 4 devices','danger')

			query = ("SELECT * FROM massCommand ORDER BY createTime DESC")
			try:
				cursor.execute(query)
				commandHistory=cursor.fetchall()
			except: 
				cursor.close()
				cnx.close()
				print "ERROR:", sys.exc_info()
				flash('ERRROR: Command History Query Failure','danger')
				return redirect(url_for('data.home'))

			cursor.close()
			cnx.close()

		except mysql.connector.errors.ProgrammingError:
			flash("Error Storing Command Information in MYSQL (command still completed)", 'danger')
			return redirect(url_for('data.home'))

		return render_template('mass_management.html', form=form,commandHistory=commandHistory)

	flash('Incorrect Permissions to Access Page','danger')
	return redirect(url_for('data.home'))
