# import general
import datetime, sys, mysql.connector
# import from flask
from flask import Flask, request, render_template, flash, redirect, \
    url_for, json, jsonify, Blueprint, g , send_from_directory
from flask.ext.login import current_user, login_user, \
    logout_user, login_required
from flask_restful import reqparse, abort, Api, Resource
# import from this app
from my_app.auth.models import User, LoginForm
from my_app import login_manager, db, app, data_database_username, \
    data_database_password, data_database_dbname, mgdb_database_host, \
    mgdb_database_dbName, mgdb_database_username, mgdb_database_password
 
api_r = Blueprint('api', __name__)
api = Api(app)

interfaceFields = [
    'intID',
    'deviceID',
    'intType',
    'connectorType',
    'intName',
    'intPosition',
    'ipv4address',
    'ipv4Subnet',
    'ipv4Gateway',
    'lastCleaned',
    'intVoltage',
    'intLabel',
    'intNote'
    ]

deviceFields = [
    'deviceID',
    'rackID',
    'deviceTypeID',
    'parentDeviceID',
    'deviceName',
    'deviceSequence',
    'deviceSerial',
    'purchaseDate',
    'costInitial',
    'decayRate',
    'deviceNote',
    'deviceEnd',
    'deviceStatus',
    'uStart'
    ]

#allowedIPList = []

def findChangedElements(keyID,origList,newList):
    # KeyID will be particular to the element type being searched (e.g. 'intID', 'deviceID', 'rackID', etc)

    # Create skeleton dictionary for sorted elements
    returnDict = {'unchanged':[],'changed':{'from':{},'to':{}},'new':[],'deleted':[]}

    # Find any new elements
    # iterate through new elements to find those excluding a key value
    for newElement in newList:
        if keyID not in list(newElement.keys()):
            returnDict['new'].append(newElement)

    # iterate through old elements, comparing to elements in the new list
    for oldElement in origList:

        # create boolean to catch old elements not found in new list (deleted elements)
        found=False
        for newElement in (newElement for newElement in newList if newElement not in returnDict['new']):

            # check for exact matches for list elements, adding element to unchanged list
            if (oldElement == newElement):
                returnDict['unchanged'].append(oldElement[keyID])
                found=True
                break

            # check for matching keyID (excluding new keys from search) with different keys/values and add to changed list in return dict  
            elif (oldElement != newElement) & (oldElement[keyID] == newElement[keyID]):
                returnDict['changed']['from'][oldElement[keyID]]=oldElement
                returnDict['changed']['to'][oldElement[keyID]]=newElement
                found=True
                break

        # process old element as deleted if matching element or matching key not found in new list
        if not found:
            returnDict['deleted'].append(oldElement)

    # print "\nRETURN DICTIONARY:\n"+str(returnDict)
    return returnDict

def deleteInterface(interfaceDict):
    cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    cursor = cnx.cursor(dictionary=True)
    delstring = "DELETE FROM interface WHERE intID = %s"
    try:
        cursor.execute(delstring,(interfaceDict['intID'],))
        cnx.commit()
        print str(request.remote_addr) + " - CHANGE("+current_user.username+") - Deleted Interface with ID " + str(interfaceDict['intID'])
    except:
        cursor.close()
        cnx.close()
        return 1
    cursor.close()
    cnx.close()
    return 0

def addInterface(interfaceDict,deviceID):
    cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    cursor = cnx.cursor(dictionary=True)

    # Generate string for insert mysql command
    addString = "INSERT INTO interface ("
    endSet=""
    x=0
    interfaceDict['deviceID']=deviceID
    for key,value in interfaceDict.iteritems():
        if (value != 'None') and (value is not None):
            # add commas 
            if x > 0:
                addString+=", "
                endSet+=", "
            # add key to input field set
            addString+=str(key)
            # add values substitution fields based on keys (adjusting for IP formatting with INET)
            if (key == 'ipv4address') or (key=='ipv4Gateway'):
                endSet+="INET_ATON(%("+str(key)+")s)"
            else:
                endSet+="%("+str(key)+")s"
            x+=1
    addString+=") VALUES ("
    addString+=str(endSet)
    addString+=")"

    # Commit changes with generated insert string joined with interface dict values
    try:
        cursor.execute(addString,interfaceDict)
        cnx.commit()
        newID=cursor.lastrowid
        print str(request.remote_addr) + " - CHANGE("+current_user.username+") - Added New Interface with with ID " + str(newID)
    except:
        cursor.close()
        cnx.close()
        print 'ERROR: ' + str(sys.exc_info())
        return 1
    
    # check addition of new row
    query = ("SELECT * from interface where intID="+str(newID))
    try:
        cursor.execute(query)
        intResult=cursor.fetchall()
    except:
        cursor.close()
        cnx.close()
        return 1
    if not intResult[0]:
        print 'ERROR: ' + str(sys.exc_info())
        return 1
    cursor.close()
    cnx.close()
    return 0

def modiftyInterface(interfaceDict_from,interfaceDict_to):
    cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    cursor = cnx.cursor(dictionary=True)

    # check for keys differences between dicts - this should not happen
    if sorted(interfaceDict_from.keys()) != sorted(interfaceDict_to.keys()):
        print "ERROR: inteface modification key mismatch"
        return 1

    modifiedKeyList = [key for key in interfaceDict_to if interfaceDict_from[key] != interfaceDict_to[key]]

     # generate string for mysql update
    addString = str("UPDATE interface SET ")
    x=0
    for key,value in interfaceDict_to.iteritems():
        if (key in modifiedKeyList) and (key in interfaceFields):
            if x > 0:
                addString+=", "
            if (key == 'ipv4address') or (key=='ipv4Gateway'):
                addString+=(str(key)+"=INET_ATON(+%("+str(key)+")s")+")"
            else:
                addString+=(str(key)+"=%("+str(key)+")s")
            x+=1
    addString+=str(" WHERE intID=" + str(interfaceDict_to['intID']))
    try:
        cursor.execute(addString,interfaceDict_to)
        cnx.commit()
        print str(request.remote_addr) + " - CHANGE("+current_user.username+") - Update to Interface with ID " + str(interfaceDict_to['intID']) # + " by user " + str(current_user.username)
        for key in modifiedKeyList:
            if key in interfaceFields:
                print "    KEY '"+key+"' CHANGED: "+str(interfaceDict_from[key]), ' -> '+str(interfaceDict_to[key])
    except:
        cursor.close()
        cnx.close()
        print 'ERROR: ' + str(sys.exc_info())
        return 1
    cursor.close()
    cnx.close()
    return 0

def modiftyDevice(deviceDict_from,deviceDict_to):
    cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    cursor = cnx.cursor(dictionary=True)

    # check for keys differences between dicts - this should not happen
    if sorted(deviceDict_from.keys()) != sorted(deviceDict_to.keys()):
        print "ERROR: inteface modification key mismatch"
        return 1

    modifiedKeyList = [key for key in deviceDict_to if deviceDict_from[key] != deviceDict_to[key]]

    tempAddDict = {}

     # generate string for mysql update
    addString = str("UPDATE device SET ")
    x=0
    for key,value in deviceDict_to.iteritems():
        if (key in modifiedKeyList) and (key in deviceFields):
            if x > 0:
                addString+=", "
            if (key == 'ipv4address') or (key=='ipv4Gateway'):
                addString+=(str(key)+"=INET_ATON(+%("+str(key)+")s")+")"
            else:
                addString+=(str(key)+"=%("+str(key)+")s")
            x+=1
            tempAddDict[key]=value
    addString+=str(" WHERE deviceID=" + str(deviceDict_to['deviceID']))
    try:
        cursor.execute(addString,tempAddDict)
        cnx.commit()
        print str(request.remote_addr) + " - CHANGE("+current_user.username+") - Update to device with ID " + str(deviceDict_to['deviceID']) # + " by user " + str(current_user.username)
        for key in modifiedKeyList:
            if key in deviceFields:
                print "    KEY '"+key+"' CHANGED: "+str(deviceDict_from[key]), ' -> '+str(deviceDict_to[key])
    except:
        cursor.close()
        cnx.close()
        print 'ERROR: ' + str(sys.exc_info())
        return 1
    cursor.close()
    cnx.close()
    return 0


class listAll(Resource):
    def get(self):
        if current_user.is_authenticated:
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT locationID,locationCode,hostingProvider,cageInformation," \
                + "contactPhone,contactEmail,amazonEntity,physicalAddress,locationNotes," \
                + "locationStatus,gMapAddress,gFolderID,powerChartLink,tempChartLink," \
                + "humidityChartLink,voltageChartLink " \
                + "FROM location")
            try:
                cursor.execute(query)
                popResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            if len(popResult) <= 0:
                return jsonify(error="ERROR GATHER DATA")
            cursor.close()
            cnx.close()
            return jsonify(sites=popResult)
        return "NOT AUTHENTICATED"
    def post(self):
        # if current_user.is_authenticated:
        #     if current_user.is_admin:
        return "test response to post", 201
        #     return "INSUFFICIENT PRIVILEGES"
        # return "NOT AUTHENTICATED"

class listPop(Resource):
    def get(self,locationName):
        if current_user.is_authenticated:
            locationName=locationName.upper()
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT locationID,locationCode,hostingProvider,cageInformation," \
                + "contactPhone,contactEmail,amazonEntity,physicalAddress,locationNotes," \
                + "locationStatus,gMapAddress,gFolderID,powerChartLink,tempChartLink," \
                + "humidityChartLink,voltageChartLink " \
                + "FROM location WHERE locationCode='"+locationName+"'")
            try:
                cursor.execute(query)
                popResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            if len(popResult) != 1:
                return jsonify(error="DATA NOT FOUND")
            query = ("SELECT rackID,uCOunt,outsideHeight,outsideWidth,outsideDepth," \
                + "rackNotes,rackName,twitch_room,provider_room,rackStatus,providerRackName," \
                + "powerFeedA,powerFeedB,powerFeedC,powerFeedD,rackSecNotes,rackMakeInfo," \
                + "rackSubnet,rackSequenceNo " \
                + "FROM rack where locationID=" + str(popResult[0]['locationID']))
            try:
                cursor.execute(query)
                rackResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(popResult[0],racks=rackResult)
        return "NOT AUTHENTICATED"
    def post(self,locationName):
        # if current_user.is_authenticated:
        #     if current_user.is_admin:
        return "test response to post", 201
        #     return "INSUFFICIENT PRIVILEGES"
        # return "NOT AUTHENTICATED"

class listRack(Resource):
    def get(self,locationName,rackName):
        if current_user.is_authenticated:
            locationName=locationName.upper()
            rackName=rackName.lower()
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT rackID,uCount,outsideHeight,outsideWidth,outsideDepth," \
                + "rackNotes,twitch_room,provider_room,rackStatus,providerRackName," \
                + "powerFeedA,powerFeedB,powerFeedC,powerFeedD,rackSecNotes,rackMakeInfo," \
                + "rackSubnet,rackSequenceNo " \
                + "FROM rack " \
                + "JOIN location ON location.locationID=rack.locationID " \
                + "WHERE locationCode='"+locationName+"' " \
                + "AND rackName='"+rackName+"'")
            try:
                cursor.execute(query)
                rackResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            if len(rackResult) != 1:
                return jsonify(error="DATA NOT FOUND")
            query = ("SELECT deviceID,rackID,parentDeviceID,deviceName,deviceSequence," \
                + "deviceSerial,purchaseDate,costInitial,decayRate,deviceNote,deviceEnd," \
                + "deviceStatus,uStart,deviceRole,deviceMake,deviceModel,DeviceTypeNote," \
                + "deviceTypeName,softwareVersion,uHeight,device.deviceTypeID as deviceTypeID " \
                + "FROM device " \
                + "JOIN deviceType ON device.deviceTypeID=deviceType.deviceTypeID " \
                + "WHERE rackID="+str(rackResult[0]['rackID']))
            try:
                cursor.execute(query)
                deviceResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                print str(sys.exc_info())
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(rackResult[0],locationName=locationName,rackName=rackName,devices=deviceResult)
        return "NOT AUTHENTICATED"
    def post(self,locationName,rackName):
        # if current_user.is_authenticated:
        #     if current_user.is_admin:
        return "test response to post", 201
        #     return "INSUFFICIENT PRIVILEGES"
        # return "NOT AUTHENTICATED"

class listDevice(Resource):
    def get(self,locationName,rackName,deviceName):
        if current_user.is_authenticated:
            locationName=locationName.upper()
            rackName=rackName.lower()
            deviceName=deviceName.lower()
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT deviceID,rackName,locationCode,parentDeviceID,deviceName,deviceSequence," \
                + "deviceSerial,purchaseDate,costInitial,decayRate,deviceNote,deviceEnd," \
                + "deviceStatus,uStart,deviceRole,deviceMake,deviceModel,deviceTypeNote," \
                + "deviceTypeName,softwareVersion,uHeight,deviceType.deviceTypeID as deviceTypeID " \
                + "FROM device " \
                + "JOIN rack ON device.rackID=rack.rackID " \
                + "JOIN location ON location.locationID=rack.locationID " \
                + "JOIN deviceType ON device.deviceTypeID=deviceType.deviceTypeID " \
                + "WHERE locationCode='"+locationName+"' " \
                + "AND rackName='"+rackName+"' " \
                + "AND deviceName='"+deviceName+"'")
            try:
                cursor.execute(query)
                deviceResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            if len(deviceResult) < 1:
                return jsonify(error="DATA NOT FOUND")
            if len(deviceResult) > 1:
                return jsonify(error="MORE THAN ONE RESULT",found=devcieResult)
            query = ("SELECT intID,intType,connectorType,intName,intPosition," \
                + "INET_NTOA(ipv4address) as ipv4address,INET_NTOA(ipv4Subnet) as ipv4Subnet," \
                + "INET_NTOA(ipv4Gateway) as ipv4Gateway,lastCleaned,intVoltage,intLabel,intNote " \
                + "FROM interface " \
                + "WHERE deviceID="+str(deviceResult[0]['deviceID']))
            try:
                cursor.execute(query)
                intResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(deviceResult[0],interfaces=intResult,rackName=rackName)
        return "NOT AUTHENTICATED"
    def post(self,locationName,rackName,deviceName):
        if current_user.is_authenticated: # or (request.remote_addr = allowedIPList):
            if current_user.is_admin:

                # Gather initial 
                locationName=locationName.upper()
                rackName=rackName.lower()
                deviceName=deviceName.lower()
                postValues=json.loads(request.get_data())
                response={}

                cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
                cursor = cnx.cursor(dictionary=True)
                query = ("SELECT deviceID,rackName,locationCode,parentDeviceID,deviceName,deviceSequence," \
                    + "deviceSerial,purchaseDate,costInitial,decayRate,deviceNote,deviceEnd," \
                    + "deviceStatus,uStart,deviceRole,deviceMake,deviceModel,deviceTypeNote," \
                    + "deviceTypeName,softwareVersion,uHeight,device.deviceTypeID as deviceTypeID " \
                    + "FROM device " \
                    + "JOIN rack ON device.rackID=rack.rackID " \
                    + "JOIN location ON location.locationID=rack.locationID " \
                    + "JOIN deviceType ON device.deviceTypeID=deviceType.deviceTypeID " \
                    + "WHERE locationCode='"+locationName+"' " \
                    + "AND rackName='"+rackName+"' " \
                    + "AND deviceName='"+deviceName+"'")
                try:
                    cursor.execute(query)
                    deviceResult=cursor.fetchall()
                except:
                    cursor.close()
                    cnx.close()
                    abort(404, message=str(sys.exc_info()))
                if len(deviceResult) != 1:
                    return jsonify(error="DATA NOT FOUND")
                query = ("SELECT intID,intType,connectorType,intName,intPosition," \
                    + "INET_NTOA(ipv4address) as ipv4address,INET_NTOA(ipv4Subnet) as ipv4Subnet," \
                    + "INET_NTOA(ipv4Gateway) as ipv4Gateway,lastCleaned,intVoltage,intLabel,intNote " \
                    + "FROM interface " \
                    + "WHERE deviceID="+str(deviceResult[0]['deviceID']))
                try:
                    cursor.execute(query)
                    intResult=cursor.fetchall()
                except:
                    cursor.close()
                    cnx.close()
                    abort(404, message=str(sys.exc_info()))
                currentValues=dict(deviceResult[0])
                currentValues['interfaces']=intResult
                currentValues['rackName']=rackName

                def listDictChanges(oldDict,newDict):
                    modifiedKeyList = [key for key in oldDict if oldDict[key] != newDict[key]]
                    for k in modifiedKeyList:
                        print "    KEY "+k+' CHANGED : '+str(oldDict[k]), ' -> '+str(newDict[k])

                # first process interface updates
                relativeIntValues = findChangedElements('intID',intResult,postValues['interfaces'])

                # process new
                for newInt in relativeIntValues['new']:
                    addInterface(newInt,currentValues['deviceID'])

                # process deleted
                for deleteInt in relativeIntValues['deleted']:
                    deleteInterface(deleteInt)

                # process changed
                for key,value in relativeIntValues['changed']['from'].iteritems():
                    modiftyInterface(value,relativeIntValues['changed']['to'][key])


                modifiedKeyList = [key for key in currentValues if (currentValues[key] != postValues[key]) & (key != 'interfaces')]
                for k in modifiedKeyList:
                    modiftyDevice(currentValues,postValues)
                    #print str(request.remote_addr) + " - CHANGE - DEVICE VALUE "+k+' CHANGED : '+str(currentValues[k]), ' -> '+str(postValues[k])

                cursor.close()
                cnx.close()


                return "test response to post", 201
            return "INSUFFICIENT PRIVILEGES"
        return "NOT AUTHENTICATED"

class resourceDeviceType(Resource):
    def get(self):
        if current_user.is_authenticated:
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT * FROM deviceType")
            try:
                cursor.execute(query)
                typeResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            if len(typeResult) <= 1:
                return jsonify(error="DATA NOT FOUND")
            return jsonify(deviceTypes=typeResult)
            cursor.close()
            cnx.close()
        return "NOT AUTHENTICATED"





#########################################################
## Above is API used for web frontend and modification ##
#########################################################

#########################################################
##   Below is API used for general data consumption    ##
#########################################################



class siteDetail(Resource):
    def get(self, locationName):
        if current_user.is_authenticated:
            locationName=locationName.upper()
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT locationCode FROM location")
            try:
                cursor.execute(query)
                sitesResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            siteNameList=[]
            for site in sitesResult:
                siteNameList.append(site['locationCode'])
            if locationName not in siteNameList:
                cursor.close()
                cnx.close()
                abort(404, message="Site {} not found.".format(locationName))
            query = ("SELECT * FROM location WHERE locationCode='"+locationName+"'")
            try:
                cursor.execute(query)
                detailResult=cursor.fetchall()
            except:
                abort(404, message=str(sys.exc_info()))
                cursor.close()
                cnx.close()
            locationID=detailResult[0]['locationID']
            query = ("SELECT * FROM rack WHERE locationID="+str(locationID))
            try:
                cursor.execute(query)
                siteRackResult=cursor.fetchall()
            except:
                abort(404, message=str(sys.exc_info()))
                cursor.close()
                cnx.close()
            cursor.close()
            cnx.close()
            return jsonify(general=detailResult[0],rackList=siteRackResult)
        return "NOT AUTHENTICATED"

class site(Resource):
    def get(self):
        if current_user.is_authenticated:
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT * FROM location")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(site=result)
        return "NOT AUTHENTICATED"

class rackDetail(Resource):
    def get(self, locationName, rackName):
        if current_user.is_authenticated:
            # Get arguments
            locationName=locationName.upper()

            # Open MYSQL connector
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)


            # Create dictionary of locations (key ID, value Code)
            query = ("SELECT locationID,locationCode FROM location")
            try:
                cursor.execute(query)
                locationResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            locationLegend={}
            for location in locationResult:
                locationLegend[location['locationCode']]=location['locationID']
            if locationName not in locationLegend:
                cursor.close()
                cnx.close()
                abort(404, message="Site {} not found.".format(locationName))

            # Create dictionary result for general rack information
            query = ("SELECT * FROM rack WHERE" \
                +" locationID="+str(locationLegend[locationName])+" AND " \
                +" rackName='"+str(rackName)+"'")
            try:
                cursor.execute(query)
                rackResult=cursor.fetchall()[0]
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))

            # Create list of device dicts for pop
            query = ("SELECT * FROM device WHERE rackID="+str(rackResult['rackID']))
            try:
                cursor.execute(query)
                deviceResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))

            # Create list of possible deviceTypes
            query = ("SELECT * FROM deviceType")
            try:
                cursor.execute(query)
                deviceTypeList=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))


            # Close MYSQL connector
            cursor.close()
            cnx.close()

            # Return json with gathered data
            return jsonify(general=rackResult,deviceList=deviceResult,deviceTypeList=deviceTypeList)
        return "NOT AUTHENTICATED"

class rackSiteDetail(Resource):
    def get(self, locationName):
        if current_user.is_authenticated:
            locationName=locationName.upper()
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT locationID,locationCode FROM location")
            try:
                cursor.execute(query)
                locationResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))

            # Create dictionary of locations (key ID, value Code)
            locationLegend={}
            for location in locationResult:
                locationLegend[location['locationCode']]=location['locationID']
            if locationName not in locationLegend:
                cursor.close()
                cnx.close()
                abort(404, message="Site {} not found.".format(locationName))

            query = ("SELECT * FROM rack WHERE locationID="+str(locationLegend[locationName]))
            try:
                cursor.execute(query)
                rackResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(locationLegend=locationLegend,rack=rackResult)
        return "NOT AUTHENTICATED"

class rack(Resource):
    def get(self):
        if current_user.is_authenticated:
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT locationID,locationCode FROM location")
            try:
                cursor.execute(query)
                locationResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            locationLegend={}
            for location in locationResult:
                locationLegend[int(location['locationID'])]=location['locationCode']
            query = ("SELECT * FROM rack")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(rack=result,locationLegend=locationLegend)
        return "NOT AUTHENTICATED"

class deviceByRole(Resource):
    def get(self, deviceRole):
        if current_user.is_authenticated:
            deviceRole=deviceRole.upper()
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT * FROM deviceType")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, messrage=str(sys.exc_info()))
            deviceRoleList=[]
            for deviceType in result:
                if deviceType['deviceRole'] not in deviceRoleList:
                    deviceRoleList.append(deviceType['deviceRole'])
            if deviceRole not in deviceRoleList:
                cursor.close()
                cnx.close()
                abort(404, message="The device role {} does not exist".format(deviceRole))
            query = ("SELECT deviceName,deviceSequence,deviceSerial,purchaseDate," \
                + "costInitial,decayRate,deviceNote,deviceEnd,deviceStatus,uStart," \
                + "softwareVersion,deviceTypeName,deviceTypeNote,deviceModel," \
                + "deviceMake,deviceRole,uHeight,rackName,rackSubnet,locationCode," \
                + "deviceID " \
                +" FROM device INNER JOIN deviceType ON device.deviceTypeID=deviceType.deviceTypeID " \
                + "JOIN rack ON rack.rackID=device.rackID " \
                + "JOIN location ON location.locationID=rack.locationID")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(devices=result) #,deviceTypes=deviceRoleList
        return "NOT AUTHENTICATED"

class deviceDetail(Resource):
    def get(self, deviceName):
        if current_user.is_authenticated:
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT deviceName FROM device")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            deviceNameList=[]
            for device in result:
                deviceNameList.append(device['deviceName'])
            if deviceName not in deviceNameList:
                cursor.close()
                cnx.close()
                abort(404, message="Device {} doesn't exist".format(deviceName))
            query = ("SELECT * FROM device WHERE deviceName='"+deviceName+"'")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return result
        return "NOT AUTHENTICATED"

class device(Resource):
    def get(self):
        if current_user.is_authenticated:

            # get device data
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT * FROM device")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))

            # get location legend
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT locationID,locationCode FROM location")
            try:
                cursor.execute(query)
                locationResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))

            # Create dictionary of locations (key ID, value Code)
            locationLegend={}
            for location in locationResult:
                locationLegend[location['locationID']]=location['locationCode']

            # get rack legend
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT rackID,rackName,locationID FROM rack")
            try:
                cursor.execute(query)
                rackResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))

            # Create dictionary of locations (key ID, value Code)
            rackLegend={}
            for rack in rackResult:
                rackLegend[rack['rackID']]={'locationID':rack['locationID'],'rackName':rack['rackName']}

             # get device type legend
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT deviceTypeID,deviceRole,deviceTypeName FROM deviceType")
            try:
                cursor.execute(query)
                typeResult=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))

            # Create dictionary of locations (key ID, value Code)
            typeLegend={}
            for deviceType in typeResult:
                typeLegend[deviceType['deviceTypeID']]={'deviceRole':deviceType['deviceRole'],'deviceTypeName':deviceType['deviceTypeName']}

            cursor.close()
            cnx.close()
            return jsonify(locationLegend=locationLegend,rackLegend=rackLegend,typeLegend=typeLegend,Device=result)
        return "NOT AUTHENTICATED"

## Systems Information Pooling
class systemsDeviceDetails(Resource):
    def get(self, name):
        if current_user.is_authenticated:
            #get general device information
            cnx = mysql.connector.connect(user=mgdb_database_username,password=mgdb_database_password,database=mgdb_database_dbName,host=mgdb_database_host)
            cursor = cnx.cursor(dictionary=True)
            query = ("SELECT id, uuid, name, comment, CAST(last_updated AS char) AS 'last_updated' FROM devices WHERE name='"+name+"'")
            try:
                cursor.execute(query)
                generalData=cursor.fetchall()
                result=generalData
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            combinedResult=result
            generalData=result
            if not result :
                abort(404, message=("Device '" + name + "' Not Found"))
            systemsDeviceID=result[0]['id']

            #get interface information
            query = ("SELECT INET_NTOA(ip) AS 'ip',subnet,macaddress,subnet_id,label,type,CAST(last_updated AS char) AS 'last_updated' FROM ip_addresses WHERE device_id="+str(combinedResult[0]['id']))
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            for row in result:
                combinedResult.append(row)
            interfaceData=result

            #get other parameters
            query = ("SELECT name, value FROM device_parameters WHERE device_id="+str(combinedResult[0]['id']))
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            tempDict={}
            for row in result:
                tempDict[row['name']]=row['value']
            combinedResult.append(tempDict)
            deviceParametersData=result

                    #get other parameters
            query = ("SELECT name, value, note FROM device_custom_parameters WHERE device_id="+str(combinedResult[0]['id']))
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            tempDict={}
            for row in result:
                tempDict[row['name']]=row['value']
            combinedResult.append(tempDict)
            deviceCustomParametersData=result

            cursor.close()
            cnx.close()
            #return jsonify(general=generalData)
            #return jsonify(general=generalData,interfaces=interfaceData,parameters=deviceParametersData,custom_parameters=deviceCustomParametersData)
            return combinedResult
        return "NOT AUTHENTICATED"

class systemsDevice(Resource):
    def get(self):
        if current_user.is_authenticated:
            cnx = mysql.connector.connect(user=mgdb_database_username,password=mgdb_database_password,database=mgdb_database_dbName,host=mgdb_database_host)
            cursor = cnx.cursor(dictionary=True)
            query = ("select id, uuid, name, comment, CAST(last_updated AS char) AS 'last_updated' from devices")
            try:
                cursor.execute(query)
                result=cursor.fetchall()
            except:
                cursor.close()
                cnx.close()
                abort(404, message=str(sys.exc_info()))
            cursor.close()
            cnx.close()
            return jsonify(devices=result)
        return "NOT AUTHENTICATED"

##
## Setup the Api resource routing here
##

api.add_resource(
    listAll,
    '/api2/all'
    )

api.add_resource(
    listPop,
    '/api2/all/<locationName>'
    )

api.add_resource(
    listRack,
    '/api2/all/<locationName>/<rackName>'
    )

api.add_resource(
    listDevice,
    '/api2/all/<locationName>/<rackName>/<deviceName>'
    )

api.add_resource(
    resourceDeviceType,
    '/api2/resource/devicetype'
    )


api.add_resource(
    site,
    '/api2/site',
    '/api2/pop',
    '/api2/location'
    )
api.add_resource(
    siteDetail,
    '/api2/site/<locationName>',
    '/api2/pop/<locationName>',
    '/api2/location/<locationName>'
    )
api.add_resource(
    rack,
    '/api2/rack',
    '/api2/cabinet',
    '/api2/cab'
    )
api.add_resource(
    rackSiteDetail,
    '/api2/rack/<locationName>',
    '/api2/cabinet/<locationName>',
    '/api2/cab/<locationName>'
    )
api.add_resource(
    rackDetail,
    '/api2/rack/<locationName>/<rackName>',
    '/api2/cabinet/<locationName>/<rackName>',
    '/api2/cab/<locationName>/<rackName>'
    )
api.add_resource(
    device,
    '/api2/device'
    )
api.add_resource(
    deviceByRole,
    '/api2/device/<deviceRole>'
    )


# Systems oriented portion of API
api.add_resource(systemsDevice, '/api2/systems/devices')
api.add_resource(systemsDeviceDetails, '/api2/systems/devices/<name>')