import ConfigParser
from flask import Flask
from flask.ext.triangle import Triangle
from os.path import expanduser

# Setup Configuration Parser, and read from home directory
Config = ConfigParser.ConfigParser()
Config
Config.read(str(expanduser("~"))+"/.overlordrc")

# Config parse helper function
def ConfigSectionMap(section):
    dict1 = {}
    options = Config.options(section)
    for option in options:
        try:
            dict1[option] = Config.get(section, option)
            if dict1[option] == -1:
                DebugPrint("skip: %s" % option)
        except:
            print("exception on %s!" % option)
            dict1[option] = None
    return dict1

# Set variables based off of configuration file
# [WEBAPP]
hostAddress = ConfigSectionMap("WEBAPP")['listen_address']
port = int(ConfigSectionMap("WEBAPP")['listen_port'])
debug = bool(ConfigSectionMap("WEBAPP")['debug'])
threaded = bool(ConfigSectionMap("WEBAPP")['threaded'])

# [DATABASE]
data_database_username = ConfigSectionMap("DATABASE")['data_database_username']
data_database_password = ConfigSectionMap("DATABASE")['data_database_password']
data_database_dbname = ConfigSectionMap("DATABASE")['data_database_dbname']

# [IPMI]
ipmi_username = ConfigSectionMap("IPMI")['ipmi_username']
ipmi_password = ConfigSectionMap("IPMI")['ipmi_password']

# create flask application
app = Flask(__name__)
Triangle(app)

from my_app.data.views import data
app.register_blueprint(data)
