#!/usr/bin/python

import sys, argparse, time, re, getpass, threading, subprocess, dns.resolver

#### example infoblox import
# header-arecord,fqdn*,address*
# header-ptrrecord,fqdn*,dname
# header-cnamerecord,fqdn*,canonical_name
# arecord,s46.r02-ts01.ams01.justin.tv,10.12.0.239
# ptrrecord,239.0.12.10.in-addr.arpa,s46.r02-ts01.ams01.justin.tv
# cnamerecord,con.br02.ams01.justin.tv,s46.r02-ts01.ams01.justin.tv

# example - check if not null:
# if re.match("^[a-zA-z]+.*",splitLine[index_CNAME_serial+x]): #check if that serial port name isn't null

# Add messages to the master log file
def logAdd(message):
    #logFile.write(time.strftime("%Y-%m-%d %H:%M:%S") + " " + getpass.getuser() + " : " + str(message))
    if args.verbose == 3:
        print str(message)

# Return infoblox formated A record string
def generateA(recordName,ipAddress):
    return 'arecord,'+recordName+','+ipAddress

# Return infoblox formated PTR record string
def generatePTR(dstName,ipAddress):
    ipSeg = ipAddress.split('.')
    return 'ptrrecord,'+ipSeg[3]+'.'+ipSeg[2]+'.'+ipSeg[1]+'.'+ipSeg[0]+'.in-addr.arpa'+','+dstName

# Return infoblox formated CNAME record string
def generateCNAME(recordName,dstName):
    return 'cnamerecord,'+recordName+','+dstName

# MAIN      
if __name__ == "__main__":

    # Parse Arguments
    parser = argparse.ArgumentParser() #Use argparse for arguments/flags

    parser.add_argument('newRecordsCSV', help='Export of TS Cyclade Google sheet with intended changes') # Create argument for new CSV download of the Cyclade TS google sheet
    parser.add_argument('--verbose', '-v', action='count', help= 'verbosity level, only level 3 currently used') # Create flag for verbosity
    # Note: The result will be a variable "verbose" with an integer that is the number of 'v's used
    # example: argumen "-vv" results in "verbose=2"
    args = parser.parse_args() # !!!! removed "global" - failed on run !!!! Parse arguments given upon program run
    
    # Create log file
    #logFileName = '/data/log/dnsScript/cyclade-DNS-script-v2_' + time.strftime("%Y-%m-%d_%H:%M:%S")
    #with open(logFileName,'w') as logFile:


    # Create initial log events
    logAdd('*****DNS SCRIPT STARTED******') # Log start of script
    logAdd(str('arguments used: ' + str(args))) # Log arguments

    # estantiate lists (list of dictionaries)
    listTSs = []
    listSerialPorts = []
    listCDUs = []

    # Open CSV import file
    logAdd('opening file ' + str(args.newRecordsCSV))
    with open(args.newRecordsCSV,'r') as file_newRecords:

        x = 0 # Temporary counter used as '1' to denote header row and later used to iterate through individual serial ports
        
        logAdd('Processing Current Records CSV File')

        for line in file_newRecords: # Read in all current records line by line

            row = line.strip().split(',') # Create temporary variable to split comma seperated elements
            x+=1

            # Process current CSV entries

            if x == 1:# Find index values of columns in CSV file
                print row
                try:
                    index_header = row.index('header')
                except ValueError:
                    logAdd("'header' column name not found")
                    logAdd("Exiting - 'header' is a required column")
                    sys.exit(1)
                try:
                    index_name = row.index('name')
                except ValueError:
                    logAdd("'name' column name not found")
                    logAdd("Exiting - 'name' is a required column")
                    sys.exit(1)
                try:
                    index_site = row.index('site')
                except ValueError:
                    logAdd("'site' column name not found")
                    logAdd("Exiting - 'site' is a required column")
                    sys.exit(1)
                try:
                    index_parent = row.index('parent')
                except ValueError:
                    logAdd("'parent' column name not found (required for serial port processing)")
                try:
                    index_ip = row.index('ip')
                except ValueError:
                    logAdd("'ip' column name not found")
                    logAdd("Exiting - 'ip' is a required column")
                    sys.exit(1)
                try:
                    index_connected = row.index('connected')
                except ValueError:
                    logAdd("'connected' column name not found (required for serial port processing with device names)")
                try:
                    index_index = row.index('index') # INDEX-CEPTION
                except ValueError:
                    logAdd("'index' column name not found (required for serial port processing with device names)")
                logAdd("Processed Header Row") # Log


            else: # Add entries to dictionaries for each TS per line

                if row[index_header] == 'ts':
                    listTSs.append({
                        'name':row[index_name],
                        'site':row[index_site],
                        'ip':row[index_ip]
                        })
                if row[index_header] == 'ts-serial':
                    tempDict={
                        'name':row[index_name],
                        'site':row[index_site],
                        'ip':row[index_ip],
                        'parent':row[index_parent]
                        }
                    if row[index_connected]:
                        tempDict['connected']=row[index_connected]
                        try:
                            if int(row[index_index]) == 1:
                                tempDict['conName']='con'
                            elif int(row[index_index]) == 2:
                                tempDict['conName']='con2'
                        except:
                            print "FAILED"
                            tempDict['conName']='con'
                    listSerialPorts.append(tempDict)
    #print listTSs
    #print listSerialPorts

    # create proper infoblox formated headers
    print 'header-arecord,fqdn*,address*'
    print 'header-ptrrecord,fqdn*,dname'
    print 'header-cnamerecord,fqdn*,canonical_name'
    for TS in listTSs:
        tempFDQN = str(TS['name'])+'.'+str(TS['site'])+'.justin.tv'
        print generateA(tempFDQN,TS['ip'])
        print generatePTR(tempFDQN,TS['ip'])
    for serialPort in listSerialPorts:
        tempFDQN = str(serialPort['name'])+'.'+str(serialPort['parent'])+'.'+str(serialPort['site'])+'.justin.tv'
        print generateA(tempFDQN,serialPort['ip'])
        print generatePTR(tempFDQN,serialPort['ip'])
        if 'connected' in serialPort:
            tempCNAME = str(serialPort['conName'])+'.'+str(serialPort['connected'])+'.'+str(serialPort['site'])+'.justin.tv'
            print generateCNAME(tempCNAME,tempFDQN)