# rack_buildsheets
`rack_buildsheets` is a collection of data and tooling to support the [buildsheet-service](https://git-aws.internal.justin.tv/video-tools/buildsheet-service). It is composed of the following parts:

  - [kontron buildsheets](./pop) organized by PoP, Rack, and Rack Unit
  - [rackcheck CLI](./cmd/rackcheck/main.go) which abstracts git functionality and calls to the buildsheet-service for detecting and syncing changes in the git repo (see [help](#rackcheck-help) below)
  - [Jenkins](./Jenkinsfile) and [Make](./Makefile) tooling to allow Jenkins to build and operate the rackcheck binary automatically during Jenkins Jobs.

# Local Use of Rackcheck CLI
The `make` tooling and behavior is specifically set up to be run automatically in the Jenkins environment, and will not result in a usable binary (unless you are David Schleef and jamming on a linux laptop). For local use, run `make build-macos` to drop a `rackcheck` binary in the folder root.

# Automated Syncing to Buildsheet-Service Workflow
The rack_builsheets repo and associated tooling are set up to make Git the effective user interface for managing the data in the buildsheet service.

- On every push to github, the rackcheck binary is built.
- Jenkins runs runs `rackcheck validate`, which looks for git changes to buildsheets under the `./pop` directory.
    - In any non-master commit, the git tooling diffs against `origin/master` to get a list of all changes, which allows PR commits to compare to HEAD
    - On master, the git tooling diffs against `HEAD~1`. It is vital that only squash commits are allowed to master, so that changes will be gathered up as one atomic collection.
- A list of added, modified, and removed buildsheets is compiled from git diffs, which looks something like this:
```json
[
    {
        "ChangeType": "D",
        "Data": "",
        "Pop":"sjc02",
        "Rack":"r202",
        "RackUnit":1
    },
    {
        "ChangeType": "M",
        "Data": "<base64-encoded buildsheet data>",
        "Pop":"sjc02",
        "Rack":"r202",
        "RackUnit":3
    }
]
```
- The rackcheck binary then sends these changes to an instance of the buildsheet-service (at a configurable URL) and validates them against the underlying DB.
  - If there are any schema-based errors, they will be reported back to Jenkins
  - If there are database-level constraint violations, they will also be reported back to Jenkins
- If all goes well, `rackcheck` will receive a `200 OK` from the `buildsheet-service` and continue.
- If the jenkins job is running on a master commit (a PR Merge), the Jenkins job will continue on and call `rackcheck sync`. This does the exact same thing as `validate`, but actually commits the changes to the DB.

# Manual Rebuild Workflow
`rackcheck` provides one piece of functionality which is _explicitly_ made available for a human operator. In the event of a new DB bringup or a db consistency failure, `rackcheck rebuild` can be invoked (with an optional `--rebuild-path` argument) to delete and replace any found buildsheets in that path.

### Notes: ###
- Buildsheets are checked in bulk, but syncing happens as a series of transactions where 8 buildsheets at a time are deleted and reuploaded. Viewing data during a rebuild will be inconsistent.
- There is no guarantee that a rebuild will be successful (a failing git commit would fail during a rebuild for the same reason)
- To rebuild just one rack, or just one PoP, add the `--rebuild-path` argument like so
```
# only rebuild cmh01
rackcheck rebuild --rebuild-path ./pop/cmh01

# only rebuild one rack in sjc02
rackcheck rebuild --rebuild-path ./pop/sjc02/rack/r404
```


# rackcheck help
```
NAME:
   rackcheck - cli tooling for git-based buildsheet validation/syncing

USAGE:
   rackcheck [command] [flags]

VERSION:
   0.2.0

DESCRIPTION:
   cli tooling for git-based buildsheet validation/syncing

COMMANDS:
     validate  validate a set of changed buildsheets against buildsheet-service
     sync      sync a set of changed buildsheets to buildsheet-service
     health    check connectivity to the buildsheet service
     rebuild   delete all known files in the git repo and resync them all in batches
     help, h   Shows a list of commands or help for one command

GLOBAL OPTIONS:
   --help, -h     show help
   --version, -v  print the version
```
