// Code generated by protoc-gen-twirp v5.7.0, DO NOT EDIT.
// source: api/buildsheet/service.proto

/*
Package buildsheet is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.7.0.

It is generated from these files:
	api/buildsheet/service.proto
*/
package buildsheet

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===========================
// BuildSheetService Interface
// ===========================

type BuildSheetService interface {
	// Health ensures service health
	Health(context.Context, *HealthRequest) (*HealthResponse, error)

	// Find attempts to return a component by serial number or MAC address
	Find(context.Context, *FindRequest) (*FindResponse, error)

	// Validate accepts a collection of buildsheets and attempts to validate them against a db
	Validate(context.Context, *ValidateRequest) (*ValidateResponse, error)

	// Sync accepts a collection of buildsheets and attempts to sync them to a db
	Sync(context.Context, *SyncRequest) (*SyncResponse, error)

	// Pops lists PoPs for which buildsheets exist
	Pops(context.Context, *PopsRequest) (*PopsResponse, error)

	// Racks lists racks in a given PoP for which uploaded buildsheets exist
	Racks(context.Context, *RacksRequest) (*RacksResponse, error)

	// RackUnits lists rack units in a given rack in a given PoP for which uploaded buildsheets exist
	RackUnits(context.Context, *RackUnitsRequest) (*RackUnitsResponse, error)

	// BuildSheet will return a buildsheet if one exists
	BuildSheet(context.Context, *BuildSheetRequest) (*BuildSheetResponse, error)
}

// =================================
// BuildSheetService Protobuf Client
// =================================

type buildSheetServiceProtobufClient struct {
	client HTTPClient
	urls   [8]string
}

// NewBuildSheetServiceProtobufClient creates a Protobuf client that implements the BuildSheetService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewBuildSheetServiceProtobufClient(addr string, client HTTPClient) BuildSheetService {
	prefix := urlBase(addr) + BuildSheetServicePathPrefix
	urls := [8]string{
		prefix + "Health",
		prefix + "Find",
		prefix + "Validate",
		prefix + "Sync",
		prefix + "Pops",
		prefix + "Racks",
		prefix + "RackUnits",
		prefix + "BuildSheet",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &buildSheetServiceProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &buildSheetServiceProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *buildSheetServiceProtobufClient) Health(ctx context.Context, in *HealthRequest) (*HealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	out := new(HealthResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceProtobufClient) Find(ctx context.Context, in *FindRequest) (*FindResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Find")
	out := new(FindResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceProtobufClient) Validate(ctx context.Context, in *ValidateRequest) (*ValidateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	out := new(ValidateResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceProtobufClient) Sync(ctx context.Context, in *SyncRequest) (*SyncResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Sync")
	out := new(SyncResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceProtobufClient) Pops(ctx context.Context, in *PopsRequest) (*PopsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Pops")
	out := new(PopsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceProtobufClient) Racks(ctx context.Context, in *RacksRequest) (*RacksResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Racks")
	out := new(RacksResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceProtobufClient) RackUnits(ctx context.Context, in *RackUnitsRequest) (*RackUnitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "RackUnits")
	out := new(RackUnitsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceProtobufClient) BuildSheet(ctx context.Context, in *BuildSheetRequest) (*BuildSheetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "BuildSheet")
	out := new(BuildSheetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =============================
// BuildSheetService JSON Client
// =============================

type buildSheetServiceJSONClient struct {
	client HTTPClient
	urls   [8]string
}

// NewBuildSheetServiceJSONClient creates a JSON client that implements the BuildSheetService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewBuildSheetServiceJSONClient(addr string, client HTTPClient) BuildSheetService {
	prefix := urlBase(addr) + BuildSheetServicePathPrefix
	urls := [8]string{
		prefix + "Health",
		prefix + "Find",
		prefix + "Validate",
		prefix + "Sync",
		prefix + "Pops",
		prefix + "Racks",
		prefix + "RackUnits",
		prefix + "BuildSheet",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &buildSheetServiceJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &buildSheetServiceJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *buildSheetServiceJSONClient) Health(ctx context.Context, in *HealthRequest) (*HealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	out := new(HealthResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceJSONClient) Find(ctx context.Context, in *FindRequest) (*FindResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Find")
	out := new(FindResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceJSONClient) Validate(ctx context.Context, in *ValidateRequest) (*ValidateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	out := new(ValidateResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceJSONClient) Sync(ctx context.Context, in *SyncRequest) (*SyncResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Sync")
	out := new(SyncResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceJSONClient) Pops(ctx context.Context, in *PopsRequest) (*PopsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Pops")
	out := new(PopsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceJSONClient) Racks(ctx context.Context, in *RacksRequest) (*RacksResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "Racks")
	out := new(RacksResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceJSONClient) RackUnits(ctx context.Context, in *RackUnitsRequest) (*RackUnitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "RackUnits")
	out := new(RackUnitsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildSheetServiceJSONClient) BuildSheet(ctx context.Context, in *BuildSheetRequest) (*BuildSheetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithMethodName(ctx, "BuildSheet")
	out := new(BuildSheetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ================================
// BuildSheetService Server Handler
// ================================

type buildSheetServiceServer struct {
	BuildSheetService
	hooks *twirp.ServerHooks
}

func NewBuildSheetServiceServer(svc BuildSheetService, hooks *twirp.ServerHooks) TwirpServer {
	return &buildSheetServiceServer{
		BuildSheetService: svc,
		hooks:             hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *buildSheetServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// BuildSheetServicePathPrefix is used for all URL paths on a twirp BuildSheetService server.
// Requests are always: POST BuildSheetServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const BuildSheetServicePathPrefix = "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/"

func (s *buildSheetServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.videotools.buildsheetservice.api.buildsheet")
	ctx = ctxsetters.WithServiceName(ctx, "BuildSheetService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/Health":
		s.serveHealth(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/Find":
		s.serveFind(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/Validate":
		s.serveValidate(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/Sync":
		s.serveSync(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/Pops":
		s.servePops(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/Racks":
		s.serveRacks(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/RackUnits":
		s.serveRackUnits(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.videotools.buildsheetservice.api.buildsheet.BuildSheetService/BuildSheet":
		s.serveBuildSheet(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *buildSheetServiceServer) serveHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) serveHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HealthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *HealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Health(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HealthResponse and nil error while calling Health. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *HealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Health(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HealthResponse and nil error while calling Health. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveFind(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFindJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFindProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) serveFindJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Find")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FindRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *FindResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Find(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FindResponse and nil error while calling Find. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveFindProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Find")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FindRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *FindResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Find(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FindResponse and nil error while calling Find. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveValidate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveValidateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveValidateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) serveValidateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ValidateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *ValidateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Validate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateResponse and nil error while calling Validate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveValidateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ValidateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *ValidateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Validate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateResponse and nil error while calling Validate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveSync(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSyncJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSyncProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) serveSyncJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Sync")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SyncRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *SyncResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Sync(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SyncResponse and nil error while calling Sync. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveSyncProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Sync")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SyncRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *SyncResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Sync(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SyncResponse and nil error while calling Sync. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) servePops(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePopsJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePopsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) servePopsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Pops")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PopsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *PopsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Pops(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PopsResponse and nil error while calling Pops. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) servePopsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Pops")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PopsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *PopsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Pops(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PopsResponse and nil error while calling Pops. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveRacks(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRacksJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRacksProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) serveRacksJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Racks")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RacksRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *RacksResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Racks(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RacksResponse and nil error while calling Racks. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveRacksProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Racks")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RacksRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *RacksResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.Racks(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RacksResponse and nil error while calling Racks. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveRackUnits(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRackUnitsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRackUnitsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) serveRackUnitsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RackUnits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RackUnitsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *RackUnitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.RackUnits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RackUnitsResponse and nil error while calling RackUnits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveRackUnitsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RackUnits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RackUnitsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *RackUnitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.RackUnits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RackUnitsResponse and nil error while calling RackUnits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveBuildSheet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBuildSheetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBuildSheetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *buildSheetServiceServer) serveBuildSheetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BuildSheet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BuildSheetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *BuildSheetResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.BuildSheet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BuildSheetResponse and nil error while calling BuildSheet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) serveBuildSheetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BuildSheet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BuildSheetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *BuildSheetResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.BuildSheetService.BuildSheet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BuildSheetResponse and nil error while calling BuildSheet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *buildSheetServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *buildSheetServiceServer) ProtocGenTwirpVersion() string {
	return "v5.7.0"
}

func (s *buildSheetServiceServer) PathPrefix() string {
	return BuildSheetServicePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.7.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Cause() error  { return e.cause }
func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause, accessible
// by github.com/pkg/errors.Cause, but the original error message is not exposed on Msg().
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Cause() error                                { return e.cause }
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return wrapInternal(err, "failed to unmarshal proto response")
	}
	return nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 825 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x5f, 0x6f, 0xd3, 0x48,
	0x10, 0xbf, 0x6d, 0x92, 0x36, 0x1e, 0x27, 0x6d, 0xba, 0xaa, 0x4e, 0x51, 0xee, 0x4e, 0x8a, 0xf6,
	0x74, 0x52, 0x9f, 0x52, 0x29, 0xf7, 0x72, 0xea, 0x5b, 0xda, 0x5e, 0x69, 0xa1, 0xa9, 0x90, 0x0b,
	0x08, 0xc1, 0x43, 0x70, 0xbc, 0x4b, 0x63, 0xea, 0x78, 0xdd, 0xac, 0x5d, 0x29, 0x0f, 0x88, 0x4f,
	0x00, 0x42, 0xbc, 0x21, 0x21, 0xf1, 0x84, 0x04, 0xe2, 0x0b, 0xf0, 0x45, 0xf8, 0x3e, 0x68, 0xff,
	0x38, 0x71, 0x0a, 0x48, 0x08, 0xbb, 0x15, 0x6f, 0xb3, 0xe3, 0x99, 0xdf, 0xfc, 0x32, 0x9e, 0x1d,
	0xff, 0x02, 0x7f, 0xba, 0x91, 0xbf, 0x35, 0x4c, 0xfc, 0x80, 0x8a, 0x11, 0x63, 0xf1, 0x96, 0x60,
	0x93, 0x0b, 0xdf, 0x63, 0x9d, 0x68, 0xc2, 0x63, 0x8e, 0xb7, 0x3d, 0x4e, 0x59, 0xe7, 0x49, 0x22,
	0x62, 0x3f, 0xec, 0xc4, 0x17, 0x9d, 0x0b, 0x9f, 0x32, 0x1e, 0x73, 0x1e, 0x88, 0xce, 0x3c, 0x27,
	0x4d, 0x71, 0x23, 0x3f, 0xe3, 0x25, 0x6b, 0x50, 0x3f, 0x60, 0x6e, 0x10, 0x8f, 0x1c, 0x76, 0x9e,
	0x30, 0x11, 0x93, 0x06, 0xac, 0xa6, 0x0e, 0x11, 0xf1, 0x50, 0x30, 0xf2, 0x37, 0xd8, 0xfb, 0x7e,
	0x48, 0x4d, 0x00, 0xde, 0x80, 0xca, 0x79, 0xc2, 0x26, 0xd3, 0x26, 0x6a, 0xa3, 0x4d, 0xcb, 0xd1,
	0x07, 0xf2, 0x19, 0x41, 0x4d, 0x47, 0xe9, 0x2c, 0xfc, 0x08, 0xaa, 0x01, 0xf7, 0xdc, 0xd8, 0xe7,
	0xa1, 0x8a, 0xb4, 0xbb, 0x7b, 0x9d, 0x9f, 0xe7, 0xd9, 0x39, 0x32, 0x58, 0xce, 0x0c, 0x15, 0x7b,
	0x60, 0x79, 0x7c, 0x1c, 0xf1, 0x90, 0x85, 0x71, 0x73, 0x49, 0x95, 0xf8, 0x3f, 0x4f, 0x89, 0xdd,
	0x14, 0xcc, 0x99, 0xe3, 0x92, 0x57, 0x08, 0xd6, 0xee, 0xb9, 0x81, 0x4f, 0xdd, 0x98, 0xa5, 0x1d,
	0x78, 0x06, 0x1b, 0xde, 0xc8, 0x0d, 0x4f, 0x19, 0x1d, 0xa8, 0xf4, 0x81, 0x46, 0x6d, 0xa2, 0x76,
	0x69, 0xd3, 0xee, 0xf6, 0x73, 0x71, 0xd0, 0xb8, 0x3b, 0xd2, 0x73, 0x22, 0x3d, 0x0e, 0xf6, 0x2e,
	0xbb, 0x04, 0xc1, 0xd0, 0x98, 0x73, 0x32, 0x6f, 0xe9, 0x05, 0x02, 0xfb, 0x64, 0x1a, 0x7a, 0xbf,
	0x0c, 0xc9, 0x55, 0xa8, 0x69, 0x3e, 0x86, 0x60, 0x1d, 0xec, 0xdb, 0x3c, 0x12, 0xe9, 0x9c, 0x11,
	0xa8, 0xe9, 0xa3, 0x99, 0x17, 0x0c, 0xe5, 0x88, 0x47, 0x9a, 0x9f, 0xe5, 0x28, 0x9b, 0xb4, 0xa1,
	0xe6, 0xb8, 0xde, 0x59, 0x9a, 0x83, 0x1b, 0x50, 0x8a, 0x78, 0x64, 0x06, 0x4f, 0x9a, 0xe4, 0x1f,
	0xa8, 0x9b, 0x08, 0x03, 0xb3, 0x01, 0x95, 0x89, 0x74, 0x18, 0x1c, 0x7d, 0x20, 0xff, 0x41, 0x43,
	0x86, 0xdd, 0x0d, 0xfd, 0xf8, 0xfb, 0x60, 0x92, 0x82, 0x0c, 0x57, 0xb3, 0x64, 0x39, 0xca, 0x26,
	0x5d, 0x58, 0xcf, 0x64, 0x9a, 0x22, 0x7f, 0x01, 0xc8, 0x87, 0x83, 0x44, 0x7a, 0x55, 0xa5, 0x8a,
	0x63, 0x4d, 0xd2, 0x30, 0x92, 0xc0, 0x7a, 0xa6, 0x37, 0xa6, 0xdc, 0x95, 0xdf, 0x07, 0xf2, 0x14,
	0x70, 0xb6, 0xac, 0xe1, 0x7a, 0x0a, 0x76, 0xe6, 0xfd, 0x9b, 0xd2, 0xfb, 0x79, 0x4a, 0x67, 0x8a,
	0xc0, 0x70, 0x66, 0x93, 0x3e, 0x54, 0x53, 0x52, 0x3f, 0xd6, 0x5b, 0xfc, 0x07, 0x58, 0xb3, 0x36,
	0x36, 0x4b, 0x6d, 0xb4, 0x59, 0x71, 0xaa, 0x69, 0x17, 0xc9, 0x36, 0x40, 0xbf, 0xb7, 0xdb, 0xa3,
	0x74, 0xc2, 0x84, 0x90, 0xe9, 0xa1, 0x3b, 0x66, 0x06, 0x51, 0xd9, 0xb8, 0x09, 0x2b, 0xae, 0x7e,
	0x6c, 0x50, 0xd3, 0x23, 0xf9, 0x84, 0xc0, 0x9a, 0xdd, 0xe6, 0x6f, 0xe6, 0xfe, 0x0e, 0xcb, 0x82,
	0x4d, 0x7c, 0x37, 0x50, 0xa9, 0x25, 0xc7, 0x9c, 0x64, 0xac, 0x08, 0x78, 0xca, 0x46, 0xd9, 0xf8,
	0x0c, 0xea, 0x63, 0xd7, 0x1b, 0x18, 0x70, 0x26, 0x9a, 0x65, 0x75, 0x85, 0x72, 0xf5, 0x70, 0xfe,
	0xd3, 0x9c, 0xda, 0xd8, 0xf5, 0x7a, 0x29, 0x36, 0x79, 0x59, 0x02, 0x98, 0x37, 0xf8, 0x1a, 0xb6,
	0xe8, 0x00, 0x56, 0xbc, 0x91, 0x2b, 0x84, 0x2f, 0x8a, 0xdd, 0xa1, 0x29, 0x2a, 0x1e, 0x82, 0x35,
	0x4a, 0x86, 0x83, 0x90, 0x53, 0x26, 0x9a, 0x25, 0xd5, 0xba, 0x82, 0x4a, 0x54, 0x47, 0xc9, 0xf0,
	0x58, 0xc2, 0xe2, 0x87, 0x50, 0xd1, 0xf8, 0xe5, 0x22, 0xf1, 0x35, 0x26, 0x79, 0x5e, 0x82, 0xf5,
	0xaf, 0x56, 0xde, 0xb5, 0xdd, 0xab, 0x85, 0x11, 0x58, 0xba, 0x92, 0x11, 0x98, 0x82, 0xad, 0xf7,
	0xf7, 0x20, 0x9e, 0x46, 0x4c, 0xcd, 0xfe, 0x6a, 0xf7, 0x7e, 0xa1, 0x5f, 0x08, 0xe3, 0xb9, 0x33,
	0x8d, 0x98, 0x03, 0xde, 0xcc, 0x26, 0x5d, 0x80, 0xf9, 0x13, 0x6c, 0x41, 0xa5, 0x47, 0x29, 0xa3,
	0x8d, 0xdf, 0x70, 0x0d, 0xaa, 0x7d, 0x4e, 0xfd, 0xc7, 0x3e, 0xa3, 0x0d, 0x84, 0x6d, 0x58, 0xd9,
	0x63, 0x01, 0x8b, 0x19, 0x6d, 0x2c, 0x75, 0x3f, 0x40, 0x76, 0xbf, 0x9e, 0x68, 0x06, 0xf8, 0x2d,
	0x82, 0x65, 0x2d, 0x5c, 0xf0, 0x61, 0x1e, 0xea, 0x0b, 0x6a, 0xa8, 0x75, 0xb3, 0x08, 0x28, 0xb3,
	0x89, 0x5f, 0x23, 0x28, 0x4b, 0x89, 0x84, 0x6f, 0xe4, 0x01, 0xcd, 0x48, 0xb1, 0xd6, 0x41, 0x7e,
	0x20, 0xc3, 0xed, 0x1d, 0x82, 0x6a, 0x2a, 0x29, 0xf0, 0xad, 0x3c, 0xb0, 0x97, 0xc4, 0x52, 0xeb,
	0xa8, 0x18, 0xb0, 0x4c, 0x0f, 0xa5, 0xaa, 0xc8, 0xd7, 0xc3, 0x8c, 0x4e, 0xca, 0xd7, 0xc3, 0xac,
	0xc0, 0x51, 0xdc, 0xa4, 0xa4, 0xc9, 0xc7, 0x2d, 0xa3, 0x91, 0xf2, 0x71, 0x5b, 0x50, 0x57, 0x6f,
	0x10, 0x54, 0x94, 0x50, 0xc2, 0xb9, 0x30, 0xb3, 0x6a, 0xac, 0x75, 0x58, 0x00, 0x92, 0xa1, 0xf7,
	0x1e, 0x81, 0x35, 0x93, 0x59, 0xf8, 0x28, 0x2f, 0x70, 0x56, 0xe7, 0xb5, 0xfa, 0x05, 0xa1, 0x19,
	0xaa, 0x1f, 0xd1, 0xc2, 0x07, 0xba, 0x5f, 0xd0, 0xc6, 0x37, 0x64, 0x8f, 0x8b, 0x82, 0xd3, 0x6c,
	0x77, 0x6a, 0x0f, 0x60, 0x1e, 0x30, 0x5c, 0x56, 0xff, 0x17, 0xff, 0xfd, 0x12, 0x00, 0x00, 0xff,
	0xff, 0xa8, 0x7e, 0xde, 0xd4, 0x4f, 0x0e, 0x00, 0x00,
}
