package spec

// Model Numbers for kontron hardware
const (
	KontronChassisMS2900  = "ms2900"
	KontronHubNodeMSH8900 = "MSH8900"
	KontronNodeMSP805X    = "MSP805x"
	KontronNodeMSP8022    = "MSP8022"
)

// DeviceType represents any device referenced by the spec or buildsheet packages
type DeviceType string

// Kontron Devices
const (
	KontronChassis DeviceType = "kontron_chassis"
	KontronHubNode DeviceType = "kontron_hubnode"
	KontronNode    DeviceType = "kontron_node"
)
