package allowlistWrapper

import (
	"context"
	"net"
	"net/http"
	"time"

	"code.justin.tv/amzn/TwitchCMONAllowListTwirp"
	"golang.org/x/net/http2"
)

type AllowlistClient interface {
	GetPrice(context.Context, *TwitchCMONAllowListTwirp.GetPriceRequest) (*TwitchCMONAllowListTwirp.Price, error)
	UpdatePrice(context.Context, *TwitchCMONAllowListTwirp.UpdatePriceRequest) (*TwitchCMONAllowListTwirp.Price, error)
	Included(context.Context, *TwitchCMONAllowListTwirp.IncludedRequest) (*TwitchCMONAllowListTwirp.IncludedResponse, error)
}

type allowlistClient struct {
	Client TwitchCMONAllowListTwirp.TwitchCMONAllowList
}

func NewAllowlistClient() (AllowlistClient, error) {

	tr := &http.Transport{
		ResponseHeaderTimeout: 1 * time.Second,
		Proxy:                 http.ProxyFromEnvironment,
		DialContext: (&net.Dialer{
			KeepAlive: 30 * time.Second,
			Timeout:   30 * time.Second,
		}).DialContext,
		MaxIdleConns:          1,
		IdleConnTimeout:       90 * time.Second,
		TLSHandshakeTimeout:   5 * time.Second,
		MaxIdleConnsPerHost:   100000,
		ExpectContinueTimeout: 1 * time.Second,
	}

	// So client makes HTTP/2 requests
	err := http2.ConfigureTransport(tr)
	if err != nil {
		return nil, err
	}

	httpClient := &http.Client{
		Transport: tr,
	}

	c := TwitchCMONAllowListTwirp.NewTwitchCMONAllowListProtobufClient("https://us-west-2.beta.twitchcmonallowlist.s.twitch.a2z.com", httpClient)

	return &allowlistClient{
		Client: c,
	}, nil
}

func (a allowlistClient) GetPrice(ctx context.Context, in *TwitchCMONAllowListTwirp.GetPriceRequest) (*TwitchCMONAllowListTwirp.Price, error) {
	return a.Client.GetPrice(ctx, in)
}

func (a allowlistClient) UpdatePrice(ctx context.Context, in *TwitchCMONAllowListTwirp.UpdatePriceRequest) (*TwitchCMONAllowListTwirp.Price, error) {
	return a.Client.UpdatePrice(ctx, in)
}

func (a allowlistClient) Included(ctx context.Context, in *TwitchCMONAllowListTwirp.IncludedRequest) (*TwitchCMONAllowListTwirp.IncludedResponse, error) {
	return a.Client.Included(ctx, in)
}
