import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as cdk from '@aws-cdk/core';

interface ECSClusterStackProps extends cdk.StackProps {
    vpc: ec2.IVpc;
    ec2Asg: ecs.AddCapacityOptions; // for ec2 services running on this cluster
}

export class ECSClusterStack extends cdk.Stack {
  public cluster: ecs.Cluster;

  constructor(scope: cdk.Construct, id: string, props: ECSClusterStackProps) {
    super(scope, id, props);

    const cluster = new ecs.Cluster(this, `Cluster`, {
      vpc: props.vpc,
      containerInsights: true,
    });
    cluster.addCapacity('ASG', props.ec2Asg);

    this.cluster = cluster;
  }
}
