package main

import (
	"context"
	"encoding/json"
	"fmt"
	"math/rand"
	"os"
	"time"

	"code.justin.tv/amzn/TwitchCMONAllowListTwirp"
	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	cw "code.justin.tv/amzn/TwitchTelemetryCloudWatchMetricsSender"
	"git.xarth.tv/devhub/CmonAllowListLoadTester/allowlistWrapper"
	"git.xarth.tv/devhub/CmonAllowListLoadTester/attack"
	"git.xarth.tv/devhub/CmonAllowListLoadTester/targets"
	log "github.com/sirupsen/logrus"
	vegeta "github.com/tsenart/vegeta/v12/lib"
)

func rangeIn(low, hi int) int {
	return low + rand.Intn(hi-low)
}

func main() {
	log.Println("**** Starting load test 1000rps ****")

	tPid := &identifier.ProcessIdentifier{
		Service:  "LoadTester",
		Stage:    "dev",
		Substage: "primary",
		Region:   "us-west-2",
		// Machine:  "SomeUniqueMachineIdentifier",
	}
	sender := cw.NewUnbuffered(tPid, nil)
	sampleObserver := telemetry.NewBufferedAggregator(30*time.Second, 100000, time.Minute, sender, nil)
	sampleReporter := telemetry.SampleReporter{
		SampleBuilder:  telemetry.SampleBuilder{ProcessIdentifier: *tPid},
		SampleObserver: sampleObserver,
	}

	// Instiance client
	allowlistClient, err := allowlistWrapper.NewAllowlistClient() //connectionsClient
	if err != nil {
		log.Info("XXXXXXXXXXXXXXXXXXXXXXXXXX")
		log.Error(err)
		os.Exit(0)
	}

	rate := vegeta.Rate{Freq: 500, Per: time.Second}
	duration := 10 * time.Minute
	targeter := targets.NewStaticTargeter(targets.Target{
		Method: func() (string, error) {
			sampleReporter.Report(fmt.Sprintf("Request"), 1.0, telemetry.UnitCount)

			res, err := allowlistClient.Included(context.Background(), &TwitchCMONAllowListTwirp.IncludedRequest{
				EntityType: TwitchCMONAllowListTwirp.EntityType_CHANNEL_ID,
				EntityId:   "ch1Q4hxvAUdZBQHy2yVjhMJCThZgcr8ZMakltFtvAjVNeIawLox6aCjOgBUvDJTdgMC9heJ2q1cIynOc53JL61AIq2aDUmQdw8zPi0jgf5h2sB5MCŠE6jKyU1CkzI4Xj",
			})

			out, err := json.Marshal(res)
			if err != nil {
				log.Error(err)
				panic(err)
			}

			log.Info("///////////////////////")
			fmt.Printf("%+v\n", res)
			fmt.Printf("%+v\n", err)
			log.Info(string(out))

			return string(out), err
		},
	})

	attacker := attack.NewAttacker()

	var vMetrics vegeta.Metrics
	for res := range attacker.Attack(targeter, rate, duration, "Big Bang!") {
		log.Printf("%+v\n", res)
		log.Println(res.Error)
		log.Println(res.Code)
		log.Println("Latency: %v\n", res.Latency)
		sampleReporter.Report(fmt.Sprintf("Response_code_%s", fmt.Sprint(res.Code)), 1.0, telemetry.UnitCount)
		sampleReporter.Report(fmt.Sprintf("Request_latency"), float64(res.Latency), telemetry.MetricDuration)
		vMetrics.Add(res)
	}
	vMetrics.Close()

	sampleReporter.Report(fmt.Sprintf("Requests"), float64(vMetrics.Requests), telemetry.UnitCount)
	sampleReporter.Report(fmt.Sprintf("99th percentile"), float64(vMetrics.Latencies.P99), telemetry.MetricDuration)

	log.Println("99th percentile: %s\n", vMetrics.Latencies.P99)
	log.Println("StatusCodes: %v\n", vMetrics.StatusCodes)
	log.Println("Requests: %v\n", vMetrics.Requests)
}
