package metrics

import (
	"errors"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
)

const (
	Region   = "us-west-2"
	Substage = "primary"
)

var processIdentifier identifier.ProcessIdentifier
var processIdentifierSet bool

func InitializeProcessIdentifier(service string, env string) error {
	if processIdentifierSet {
		return errors.New("process identifier already set")
	}
	processIdentifier = identifier.ProcessIdentifier{
		Service:  service,
		Region:   Region,
		Stage:    env,
		Substage: Substage,
	}
	processIdentifierSet = true
	return nil
}

func ProcessIdentifier() identifier.ProcessIdentifier {
	return processIdentifier
}
