#!/bin/bash
set -e

# Push the image to ECR: https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-push-ecr-image.html

export AWS_DEFAULT_REGION="us-west-2"
export AWS_PROFILE="twitch-cmon+allowlist-beta-us-west-2@amazon.com"
export AWS_ACCOUNT="733778597747"
ECR_REPO="loadtester" # the name of the ECR repository to push

echo "Auth: Make sure to run mwinit from WPA2 or AmazonVPN, and then run (copy-paste) this ada command:"
echo "      ada credentials update --once --provider=isengard --role=admin --profile=$AWS_PROFILE --account=$AWS_ACCOUNT"
echo ""

echo ">> Get Docker image id, assuming that it was built with docker build -t loadtester ."
DOCKER_IMAGE_ID=`docker images loadtest:latest --format "{{.ID}}"`
if [ -z "$DOCKER_IMAGE_ID" ]; then
    echo "docker images loadtest:latest did not return any result. Please, make sure to do first: docker build -t loadtest ."
    exit 1
fi
echo "DOCKER_IMAGE_ID=$DOCKER_IMAGE_ID"

echo ">> Get and run docker login command to authenticate your Docker CLI to the ECR registry"
# `aws ecr get-login --no-include-email`

echo ">> Tag image with the Amazon ECR registry"
ECR_REGISTRY_TAG=$AWS_ACCOUNT.dkr.ecr.us-west-2.amazonaws.com/$ECR_REPO:latest
docker tag $DOCKER_IMAGE_ID $ECR_REGISTRY_TAG

echo ""
echo "docker push $ECR_REGISTRY_TAG"
docker push $ECR_REGISTRY_TAG