﻿using System.Collections.Generic;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using Newtonsoft.Json.Linq;

namespace Twitch.Authorization
{
    public class ApplicationAuth
    {
        static readonly HttpClient client = new HttpClient();

        public async Task<string> PerformAsync(string clientId, string clientSecret, IEnumerable<string> scopes)
        {
            // Compose the authorization URL.
            clientId = WebUtility.UrlEncode(clientId);
            clientSecret = WebUtility.UrlEncode(clientSecret);
            var s = WebUtility.UrlEncode(Utility.ComposeScopes(scopes));
            var url = $"https://id.twitch.tv/oauth2/token?client_id={clientId}&client_secret={clientSecret}&grant_type=client_credentials&scope={s}";

            // Send the request.
            var response = await client.PostAsync(url, null);
            response.EnsureSuccessStatusCode();

            // Parse the response as JSON.
            var responseBody = await response.Content.ReadAsStringAsync();
            var jsonVal = JObject.Parse(responseBody);

            // Return the access_token field value.
            return jsonVal["access_token"].Value<string>();
        }
    }
}
