﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Security.Cryptography;

namespace Twitch.Authorization
{
    public class ServerAuth
    {
        public string AccessToken { get; private set; } = "";
        public string RefreshToken { get; private set; } = "";

        public string StartAuth(string clientId, string redirectUri, IEnumerable<string> scopes)
        {
            // Compose the authorization URL with thirty-two characters of
            // random state.
            Cancel();
            var escapedResponseType = WebUtility.UrlEncode("code");
            var escapedClientId = WebUtility.UrlEncode(clientId);
            var escapedRedirectUri = WebUtility.UrlEncode(redirectUri);
            var escapedScope = WebUtility.UrlEncode(Utility.ComposeScopes(scopes));
            var r = new RNGCryptoServiceProvider();
            var bytes = new byte[32];
            r.GetBytes(bytes);
            var state = WebUtility.UrlEncode(new String(bytes.Select(i => (char)(((i & 0x6f) | 0x40) + 1)).ToArray()));
            var url = $"https://id.twitch.tv/oauth2/authorize?response_type={escapedResponseType}&client_id={escapedClientId}&redirect_uri={escapedRedirectUri}&scope={escapedScope}&state={state}";

            // Open the platform's browser.
            Process.Start(url);
            return state;
        }

        public void Finish(string accessToken, string refreshToken)
        {
            AccessToken = accessToken ?? "";
            RefreshToken = refreshToken ?? "";
        }

        public void Cancel()
        {
            Finish("", "");
        }
    }
}
