#include "pch.h"
#include <objbase.h>
#include "ClientAuth_.h"

Twitch::ClientAuth* Twitch::CreateClientAuth() {
	return new ClientAuth();
}

Twitch::string_t Twitch::DoClientAuth(ClientAuth* clientAuth, string_t clientId, string_t redirectUri, string_t scopes) {
	// Execute ClientAuth::StartAuth synchronously.
	auto task = clientAuth->StartAuth(clientId, redirectUri, scopes);
	auto result = task.get();

	// Return the result as a .NET string.
	auto const n = (result.size() + 1) * sizeof(result[0]);
	auto* rv = static_cast<LPTSTR>(CoTaskMemAlloc(n));
	memcpy_s(rv, n, result.c_str(), n);
	return rv;
}

void Twitch::CancelClientAuth(ClientAuth* clientAuth) {
	clientAuth->Cancel();
}

void Twitch::DeleteClientAuth(ClientAuth*& clientAuth) {
	delete clientAuth;
	clientAuth = nullptr;
}
