#include "pch.h"

using namespace Twitch;

ClientAuth::ClientAuth() {}

ClientAuth::~ClientAuth() {}

std::future<tstring> ClientAuth::StartAuth(tstring const& clientId, tstring const& redirectUri, tstring const& scopes) {
	// Extract the scheme from the redirect URI.
	auto const i = redirectUri.find(_T(':'));
	if(i == 0 || i == redirectUri.npos) {
		throw TwitchException(FromPlatformError(ERROR_BAD_ARGUMENTS));
	}
	tstring const scheme = redirectUri.substr(0, i);

	// Start the implicit flow authorization (flow two).
	Twitch::tstring state;
	return BrowserAuth::Launch(clientId, redirectUri, _T("token"), scopes, state, scheme.c_str());
}

void ClientAuth::Cancel() {
	Stop(_T(""));
}
