@IF "%~1" == "" ECHO OFF
SETLOCAL

REM Ensure there is a Base SDK to include.
SET BASE_SDK=%~dp0..\base-sdk\packages\BaseSDK
IF NOT EXIST "%BASE_SDK%" (
	ECHO "%BASE_SDK%" not found
	EXIT /B 1
)

REM Validate the command line and set the environment variables.
IF NOT "%~2" == "" EXIT /B 2
SET ZIP=%SYSTEMDRIVE%\Program Files\7-Zip\7z.exe
IF NOT EXIST "%ZIP%" (
	ECHO "%ZIP%" not found
	EXIT /B 1
)
SET NAME=AuthorizationSDK
SET ROOT=%~dp0packages
SET SDK=%ROOT%\%NAME%
FOR /F "delims=" %%I IN ('TYPE "%~dp0version.txt"') DO SET VERSION=%%I
SET ZIP_FILE_PATH=%SDK%-%VERSION%.zip

REM Create the package directories.
FOR %%I IN ("%ROOT%\BaseSDK" "%SDK%") DO (
	IF EXIST %%I (
		RD /Q /S %%I
		IF ERRORLEVEL 1 EXIT /B
	)
)
FOR %%I IN (Gaming.Xbox.XboxOne.x64 NX64 ORBIS DotNet x64 x86) DO (
	FOR %%J IN (Debug Release) DO (
		MD "%SDK%\%%I\%%J"
		IF ERRORLEVEL 1 EXIT /B
	)
)
FOR %%I IN (Debug Release) DO (
	FOR %%J IN (x64 x86) DO (
		MD "%SDK%\DotNet\%%I\%%J"
		IF ERRORLEVEL 1 EXIT /B
	)
)

REM Copy the Base SDK.
XCOPY /I /S /Y "%BASE_SDK%" "%ROOT%\BaseSDK"
IF ERRORLEVEL 1 EXIT /B

REM Copy the platform-agnostic files.
COPY "%~dp0Shared\Twitch.h" "%SDK%\%NAME%.h"
IF ERRORLEVEL 1 EXIT /B
COPY "%~dp0LICENSE" "%SDK%"
IF ERRORLEVEL 1 EXIT /B

REM Copy all output files to their respective package directories.
FOR %%I IN (Debug Release) DO (
	COPY "%~dp0Gaming.Xbox.XboxOne.x64\%%I\%NAME%.lib" "%SDK%\Gaming.Xbox.XboxOne.x64\%%I"
	IF ERRORLEVEL 1 EXIT /B
	COPY "%~dp0Gaming.Xbox.XboxOne.x64\%%I\%NAME%.pdb" "%SDK%\Gaming.Xbox.XboxOne.x64\%%I"
	IF ERRORLEVEL 1 EXIT /B
	COPY "%~dp0NX64\%%I\lib%NAME%.a" "%SDK%\NX64\%%I"
	IF ERRORLEVEL 1 EXIT /B
	COPY "%~dp0ORBIS\%%I\lib%NAME%.a" "%SDK%\ORBIS\%%I"
	IF ERRORLEVEL 1 EXIT /B
	COPY "%~dp0DotNetLib\bin\%%I\netstandard2.0\Twitch.Authorization.dll" "%SDK%\DotNet\%%I"
	IF ERRORLEVEL 1 EXIT /B
	COPY "%~dp0DotNetLib\bin\%%I\netstandard2.0\Twitch.Authorization.pdb" "%SDK%\DotNet\%%I"
	IF ERRORLEVEL 1 EXIT /B
	FOR %%J IN (x64 x86) DO (
		COPY "%~dp0%%J\%%I\Twitch.Authorization.ClientAuth.dll" "%SDK%\DotNet\%%I\%%J"
		IF ERRORLEVEL 1 EXIT /B
		COPY "%~dp0%%J\%%I\Twitch.Authorization.ClientAuth.pdb" "%SDK%\DotNet\%%I\%%J"
		IF ERRORLEVEL 1 EXIT /B
		COPY "%~dp0%%J\%%I\%NAME%.lib" "%SDK%\%%J\%%I"
		IF ERRORLEVEL 1 EXIT /B
		COPY "%~dp0%%J\%%I\%NAME%.pdb" "%SDK%\%%J\%%I"
		IF ERRORLEVEL 1 EXIT /B
	)
)

REM Create the Zip file.
IF EXIST "%ZIP_FILE_PATH%" DEL /F /Q "%ZIP_FILE_PATH%"
IF ERRORLEVEL 1 EXIT /B
"%ZIP%" a -r "%ZIP_FILE_PATH%" "%ROOT%\BaseSDK" "%SDK%"
IF ERRORLEVEL 1 EXIT /B
COPY /Y "%ZIP_FILE_PATH%" "%SDK%.zip"
IF ERRORLEVEL 1 EXIT /B
