// Poly-fill the String trim method.
if (!String.prototype.trim) {
  String.prototype.trim = function() {
    return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
  };
}

// Create the file system object.
var ForReading = 1, ForWriting = 2, ForAppending = 8;
var fso = WScript.CreateObject('Scripting.FileSystemObject');
var language = WScript.Arguments(0);

// Read the version from the input file.
var inputFilePath = WScript.Arguments(1);
var inputFile = fso.OpenTextFile(inputFilePath, ForReading);
var version = inputFile.ReadLine().trim();
inputFile.Close();

// Create the output file.
var outputFilePath = WScript.Arguments(2);
var outputFile = fso.CreateTextFile(outputFilePath);
if (language === 'C++') {
  outputFile.WriteLine('// Auto-generated; do not edit');
  outputFile.WriteLine('#include "pch.h"');
  outputFile.WriteLine('extern char const* const sdkVersion = "' + version + '";');
} else if (language === 'C#') {
  outputFile.WriteLine('// Auto-generated; do not edit');
  outputFile.WriteLine('using System.Reflection;');
  outputFile.WriteLine('[assembly: AssemblyVersion("' + version + '")]');
  outputFile.WriteLine('[assembly: AssemblyFileVersion("' + version + '")]');
} else if (language === 'props') {
  outputFile.WriteLine('<!-- Auto-generated; do not edit -->');
  outputFile.WriteLine('<Project>');
  outputFile.WriteLine('  <PropertyGroup>');
  outputFile.WriteLine('    <Version>' + version + '</Version>');
  outputFile.WriteLine('  </PropertyGroup>');
  outputFile.WriteLine('</Project>');
}
outputFile.Close();
