'use strict';

// Load dependencies.
const { randomBytes } = require('crypto');
const express = require('express');
const session = require('express-session');
const { readFileSync } = require('fs');
const http = require('https');
const net = require('net');

// Define constants.
const httpPort = 27077;
const tcpPort = 50537;
const clientId = 'mb1glzpzrvzalxvztn1epbtxralpsb';
const secret = readFileSync('secret.txt', 'utf8').trim();
const path = '/auth';
const callbackUrl = `http://localhost:${httpPort}${path}`;

let socket, state;

// Create the Web application.
const app = express();
app.use(session({ secret: randomBytes(16).toString('hex'), resave: false, saveUninitialized: false }));
app.get(path, (req, res) => {
  // "/auth?code=thirtycharacters99999999999999&scope=user%3Aread%3Aemail&state=thirtytwocharacters9999999999999"
  // Exchange the code for tokens.
  const code = req.query['code'];
  if (req.query['state'] !== state) {
    console.warn(`actual state "${req.query['state']}" does not match expected state "${state}"`);
  }
  const options = {
    url: `https://id.twitch.tv/oauth2/token?client_id=${clientId}&client_secret=${secret}&code=${code}&grant_type=authorization_code&redirect_uri=${callbackUrl}`,
    method: 'POST',
  };
  request(options, function(response, body) {
    if (response && response.statusCode == 200) {
      const json = JSON.parse(body);
      // {"access_token":"thirtycharacters99999999999999","expires_in":99999,"refresh_token":"fiftycharacters99999999999999999999999999999999999","scope":["user:read:email"],"token_type":"bearer"}
      const { access_token: accessToken, refresh_token: refreshToken } = json;

      // Send the tokens to the example application.
      if (socket) {
        socket.write(accessToken + '\t' + refreshToken, 'utf8', () => {
          socket.destroy();
          socket = undefined;
        });
      } else {
        console.warn('no client connection');
      }
    } else {
      console.error(body);
    }
  });
  res.status(204);
  res.end();
});
const httpServer = app.listen(httpPort, () => {
  const address = httpServer.address();
  console.log(`Serving OAuth redirect from http://${address.address}:${address.httpPort}`);
});
httpServer.on('error', (ex) => console.error(ex));

// Create a socket to listen for requests from the example application.
net.createServer({ allowHalfOpen: true }, (socket_) => {
  console.log('client connected');
  socket = socket_;
  socket_.on('data', (data) => {
    state = data.toString('utf16le');
  });
  socket_.on('end', () => {
    console.log('client disconnected');
  });
}).on('error', (ex) => console.error(ex.message)).listen(tcpPort, () => {
  console.log(`TCP server bound to ${tcpPort}`);
});

function request(options, fn) {
  http.request(options.url, options, (res) => {
    console.log('statusCode:', res.statusCode);
    console.log('headers:', res.headers);
    res.setEncoding('utf8');
    const chunks = [];
    res.on('data', (chunk) => chunks.push(chunk));
    res.on('end', () => {
      try {
        const data = chunks.join('');
        fn(res, data);
      } catch (ex) {
        console.error(ex.message);
      }
    });
  }).on('error', (ex) => {
    console.error(ex);
  }).end();
}
