#include "pch.h"

using namespace Twitch;

tstring BrowserAuth::GetToken() const {
	return token;
}

std::future<tstring> BrowserAuth::Launch(tstring const& clientId, tstring const& redirectUri, tstring const& responseType, tstring const& scopes, tstring& state, string_t scheme/*= nullptr*/) {
	// Send a science event.
	SendUserScienceEvent(clientId, tstring(), _T("sdk_auth_sign_in"), { { _T("scopes"), scopes }, { _T("type"), _T("client") } });

	// Compose the authorization URL.
	token.clear();
	tstring const escapedResponseType = UrlEncode(responseType);
	tstring const escapedClientId = UrlEncode(clientId);
	tstring const escapedRedirectUri = UrlEncode(redirectUri);
	tstring const escapedScopes = UrlEncode(scopes);
	tstring url = _T("https://id.twitch.tv/oauth2/authorize?response_type=") + escapedResponseType +
		_T("&client_id=") + escapedClientId +
		_T("&redirect_uri=") + escapedRedirectUri +
		_T("&scope=") + escapedScopes;

	// Include thirty-two characters of random state.
	state.clear();
	std::generate_n(std::back_inserter(state), 32, []() {
		unsigned int value;
		rand_s(&value);
		return static_cast<tstring::value_type>(((value & 0x6f) | 0x40) + 1);
	});
	url += _T("&state=");
	url += state;

	// Open the platform's browser.
	return Launch(url, state, scheme);
}
