#pragma once

#if defined(_XBOX_ONE)
# include <winsdkver.h>
# define _WIN32_WINNT 0x0A00
# include <sdkddkver.h>

// Use the C++ standard templated min/max
# define NOMINMAX

// DirectX apps don't need GDI
# define NODRAWTEXT
# define NOGDI
# define NOBITMAP

// Include <mcx.h> if you need this
# define NOMCX

// Include <winsvc.h> if you need this
# define NOSERVICE

// WinHelp is deprecated
# define NOHELP

# define _CRT_RAND_S
# include <Windows.h>
# include <XGameRuntime.h>
# include <WinSock2.h>
# include <winhttp.h>
# include <tchar.h>

# define ERROR_INVALID_RESPONSE ERROR_WINHTTP_INVALID_SERVER_RESPONSE
# define FromPlatformError HRESULT_FROM_WIN32
#elif defined(_WIN32)
# define NOMINMAX
# include "targetver.h"

# define _CRT_RAND_S
# define WIN32_LEAN_AND_MEAN

// Windows header files
# include <windows.h>
# include <WinSock2.h>
# if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)
#  include <winhttp.h>
#  define ERROR_INVALID_RESPONSE ERROR_WINHTTP_INVALID_SERVER_RESPONSE
# else
#  define ERROR_INVALID_RESPONSE 12152
# endif
# include <tchar.h>
# define FromPlatformError HRESULT_FROM_WIN32
#elif defined(__ORBIS__)
// PS4 header files
# include <kernel.h>
# include <libsysmodule.h>
# include <libnet/errno.h>

# include <iostream>

# define _countof(a) (sizeof(a) / sizeof((a)[0]))
# define _T(s) s
# define _istalnum isalnum
# define _stprintf_s sprintf_s
# define _stscanf_s sscanf_s
# define _tcschr strchr
# define _totlower tolower
# define UNREFERENCED_PARAMETER(p) ((void)(p))

using TCHAR = char;
using LPTSTR = TCHAR*;
using LPCTSTR = TCHAR const*;

// Missing error code macros
# define ERROR_SUCCESS 0
# define ERROR_ACCESS_DENIED EACCES
# define ERROR_BAD_ARGUMENTS EINVAL
# define ERROR_CONNECTION_ABORTED ECONNABORTED
# define ERROR_INVALID_OPERATION EOPNOTSUPP
# define ERROR_INVALID_RESPONSE EBADMSG
# define ERROR_INVALID_STATE EDOOFUS
# define ERROR_IO_PENDING EALREADY
# define ERROR_TIMEOUT ETIMEDOUT

# define FromPlatformError(error) static_cast<int>(SCE_ERROR_MAKE_ERROR(0, (error)))

inline unsigned GetTickCount() {
	auto time = sceKernelGetProcessTime();
	return static_cast<unsigned>(time / 1'000);
}
#elif defined(__NX__)
# define _T(s) s
# define UNREFERENCED_PARAMETER(p) ((void)(p))

using TCHAR = char;
using LPTSTR = TCHAR * ;
using LPCTSTR = TCHAR const*;

// Missing error code macros
# define ERROR_INVALID_RESPONSE EBADMSG
# define ERROR_IO_PENDING EALREADY

# define FromPlatformError(error) static_cast<int>(0x80000000 | (error))
#else
# error "unknown platform"
#endif

#include <cassert>
#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <atomic>
#include <chrono>
#if defined(_UNICODE) && !defined(_WIN32)
# include <codecvt>
#endif
#include <condition_variable>
#include <exception>
#include <fstream>
#include <functional>
#include <future>
#include <iomanip>
#include <random>
#include <regex>
#include <stdexcept>
#include <string>
#include <sstream>
#include <thread>
#include <tuple>
#include <vector>

#ifdef _UNICODE
using tistream = std::wistream;
using tistringstream = std::wistringstream;
using tofstream = std::wofstream;
using tostream = std::wostream;
using tostringstream = std::wostringstream;
using tregex = std::wregex;
using tstringstream = std::wstringstream;
#else
using tistream = std::istream;
using tistringstream = std::istringstream;
using tofstream = std::ofstream;
using tostream = std::ostream;
using tostringstream = std::ostringstream;
using tregex = std::regex;
using tstringstream = std::stringstream;
#endif

#include "../../base-sdk/Shared/Internal.h"
#include "../../base-sdk/Shared/HttpUtil.h"
#include "Twitch.h"
