#include "stdafx.h"
#include "resource.h"
#include "DeviceAuthDialog.h"

using namespace Twitch;

namespace {
	tstring userCode, verificationUrl;
	tstring accessToken, refreshToken;
	std::future<void> task;
	constexpr UINT WM_SET_STATE = WM_USER + 111;
	constexpr UINT WM_SET_TOKENS = WM_SET_STATE + 1;

	void StartAuth(HWND dialog) {
		TCHAR clientId[99], scopes[99];
		GetDlgItemText(dialog, IDC_CLIENT_ID, clientId, _countof(clientId));
		GetDlgItemText(dialog, IDC_SCOPES, scopes, _countof(scopes));
		auto fn = [dialog, clientId = tstring(clientId), scopes = tstring(scopes)] {
			try {
				// Start the device authorization flow.
				DeviceAuth deviceAuth;
				auto response = deviceAuth.StartAuth(clientId, scopes).get();
				userCode = response.userCode;
				verificationUrl = response.verificationUrl;
				PostMessage(dialog, WM_SET_STATE, 0, 0);

				// Complete the device authorization by awaiting the result.
				auto pair = response.tokenTask.get();
				accessToken = pair.first;
				refreshToken = pair.second;

			} catch(std::exception const& ex) {
				auto message = std::string(ex.what());
				accessToken = tstring(message.cbegin(), message.cend());
			}
			PostMessage(dialog, WM_SET_TOKENS, 0, 0);
		};
		task = std::async(std::launch::async, fn);
	}

	BOOL OnInitDialog(HWND dialog, HWND /*focusWindow*/, LPARAM /*lParam*/) {
		SetDlgItemText(dialog, IDC_CLIENT_ID, _T("dviaxdls39mj44cdnei76mj2dlig33")); // Stick 2
		SetDlgItemText(dialog, IDC_SCOPES, defaultScopes);
		return TRUE;
	}

	void OnCommand(HWND dialog, int id, HWND /*controlWindow*/, UINT /*notificationCode*/) {
		if(id == IDOK) {
			StartAuth(dialog);
		} else if(id == IDCANCEL) {
			EndDialog(dialog, id);
		}
	}
}

INT_PTR CALLBACK DeviceAuthDialog(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(dialog, WM_INITDIALOG, OnInitDialog);
		HANDLE_MSG(dialog, WM_COMMAND, OnCommand);
	case WM_SET_STATE:
		SetDlgItemText(dialog, IDC_USER_CODE, userCode.c_str());
		SetDlgItemText(dialog, IDC_VERIFICATION_URL, verificationUrl.c_str());
		return TRUE;
	case WM_SET_TOKENS:
		SetDlgItemText(dialog, IDC_USER_CODE, _T(""));
		SetDlgItemText(dialog, IDC_ACCESS_TOKEN, accessToken.c_str());
		SetDlgItemText(dialog, IDC_REFRESH_TOKEN, refreshToken.c_str());
		return TRUE;
	}
	return FALSE;
}
