#include "stdafx.h"
#include "WindowsExample.h"
#include "ClientAuthDialog.h"
#include "DeviceAuthDialog.h"
#include "ServerAuthDialog.h"

static BOOL InitInstance(HINSTANCE, int);
static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
static INT_PTR CALLBACK About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY wWinMain(HINSTANCE hInstance, HINSTANCE /*hPrevInstance*/, LPWSTR /*lpCmdLine*/, int nCmdShow) {
	// Initialize COM.
	if(FAILED(CoInitializeEx(nullptr, COINIT_MULTITHREADED))) {
		return 1;
	}

	// Perform application initialization.
	if(!InitInstance(hInstance, nCmdShow)) {
		return 1;
	}

	// Run the message loop.
	HACCEL const hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_WINDOWSEXAMPLE));
	MSG msg;
	while(GetMessage(&msg, nullptr, 0, 0)) {
		if(!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return static_cast<int>(msg.wParam);
}

static BOOL InitInstance(HINSTANCE hInstance, int nCmdShow) {
	// Initialize the common controls.
	INITCOMMONCONTROLSEX icc{ sizeof(INITCOMMONCONTROLSEX), ICC_STANDARD_CLASSES | ICC_LINK_CLASS };
	if(!InitCommonControlsEx(&icc)) {
		return FALSE;
	}

	// Register the window class.
	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc = WndProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra = 0;
	wcex.hInstance = hInstance;
	wcex.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_WINDOWSEXAMPLE));
	wcex.hCursor = LoadCursor(nullptr, IDC_ARROW);
	wcex.hbrBackground = reinterpret_cast<HBRUSH>(COLOR_WINDOW + 1);
	wcex.lpszMenuName = MAKEINTRESOURCEW(IDC_WINDOWSEXAMPLE);
	wcex.lpszClassName = _T("WindowsExampleWindowClassName");
	wcex.hIconSm = wcex.hIcon;
	RegisterClassEx(&wcex);

	// Create the main window.
	LPCTSTR const title = _T("Windows Example");
	HWND const hWnd = CreateWindow(wcex.lpszClassName, title, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

	if(!hWnd) {
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

static void OnCommand(HWND hwnd, int id, HWND /*hwndCtl*/, UINT /*codeNotify*/) {
	// Respond to menu selections.
	switch(id) {
	case ID_FILE_CLIENTAUTH:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_CLIENT_AUTH_DIALOG), hwnd, ClientAuthDialog);
		break;
	case ID_FILE_DEVICEAUTH:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_DEVICE_AUTH_DIALOG), hwnd, DeviceAuthDialog);
		break;
	case ID_FILE_SERVERAUTH:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_SERVER_AUTH_DIALOG), hwnd, ServerAuthDialog);
		break;
	case IDM_ABOUT:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_ABOUTBOX), hwnd, About);
		break;
	case IDM_EXIT:
		DestroyWindow(hwnd);
		break;
	}
}

static LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(hWnd, WM_COMMAND, OnCommand);
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

static INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM /*lParam*/) {
	switch(message) {
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		if(LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) {
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}
