#include "pch.h"
#include "../../base-sdk/Shared/Json.h"

using namespace Twitch;

std::future<tstring> Twitch::ApplicationAuth::StartAuth(tstring const& clientId, tstring const& clientSecret, tstring const& scopes) {
	auto fn = [clientId, clientSecret, scopes]() {
		// Compose the authorization URL.
		auto url = _T("https://id.twitch.tv/oauth2/token?client_id=") + UrlEncode(clientId) +
			_T("&client_secret=") + UrlEncode(clientSecret) + _T("&grant_type=client_credentials");
		if(!scopes.empty()) {
			url += _T("&scope=") + UrlEncode(scopes);
		}
		auto httpResponse = HttpRequest().Post(url);
		ThrowIfResponseFailed(httpResponse);

		// Parse the response as JSON.
		auto response = httpResponse.Response;
		std::string parseError;
		auto jsonVal = Json::Parse(std::string_view(response.data(), response.size()), parseError);
		if(!parseError.empty()) {
			DebugWriteLine(_T("[ApplicationAuth::StartAuth] JSON parsing failed:  %s"), ToTstring(parseError).c_str());
			throw TwitchException(FromPlatformError(ERROR_INVALID_RESPONSE));
		}

		// Send a science event.
		SendUserScienceEvent(clientId, tstring(), _T("sdk_auth_sign_in"), { { _T("scopes"), scopes }, { _T("type"), _T("server") } });

		// Return the access_token field value.
		return ToTstring(jsonVal["access_token"].string_value());
	};
	return std::async(std::launch::deferred, fn);
}
