#include "pch.h"
#ifdef __ORBIS__
# include <web_browser_dialog.h>
#endif
#include "Utilities.h"

#ifdef _WIN32
# ifdef _UNICODE
#  define __imp_ShellExecute __imp_ShellExecuteW
# else
#  define __imp_ShellExecute __imp_ShellExecuteA
# endif
extern "C" {
	uintptr_t __imp_ShellExecute;
}
#endif

using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;

namespace WindowsLibTest {
	TEST_CLASS(AuthTest) {
public:
#ifdef _WIN32
	static bool ShellExecute_invoked;
	static HINSTANCE test_ShellExecute(HWND, LPCSTR, LPCSTR, LPCSTR, LPCSTR, INT) {
		ShellExecute_invoked = true;
		return GetModuleHandle(nullptr);
	}
#endif

	TEST_METHOD(ClientAuth_Success) {
#ifdef _XBOX_ONE
		Utilities::WriteWarning("no client auth on Xbox One");
		Assert::IsTrue(true);
#else
# ifdef _WIN32
		__imp_ShellExecute = reinterpret_cast<decltype(__imp_ShellExecute)>(test_ShellExecute);
# endif
		ClientAuth clientAuth;
		auto tokenTask = clientAuth.StartAuth(_T("clientId"), _T("redirect:uri"), Utilities::scopes);
		tstring token;
		auto fn = [&token, &tokenTask] {
			token = tokenTask.get();
		};
		auto waitTask = std::async(std::launch::async, fn);
		clientAuth.Cancel();
		waitTask.get();
		Assert::IsTrue(token.empty());
# ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
# endif
# ifdef _WIN32
		Assert::IsTrue(ShellExecute_invoked);
# endif
#endif
	}

	TEST_METHOD(ClientAuth_StartAuthTwice) {
#ifdef _XBOX_ONE
		Utilities::WriteWarning("no client auth on Xbox One");
		Assert::IsTrue(true);
#else
# ifdef _WIN32
		__imp_ShellExecute = reinterpret_cast<decltype(__imp_ShellExecute)>(test_ShellExecute);
# endif
		ClientAuth clientAuth;
		auto task = clientAuth.StartAuth(_T("clientId"), _T("redirect:uri"), Utilities::scopes);
		Assert::ExpectException<TwitchException>([&clientAuth] { clientAuth.StartAuth(_T("clientId"), _T("redirect:uri"), Utilities::scopes); });
# ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
# endif
#endif
	}

	TEST_METHOD(ClientAuth_BadRedirectUri) {
#ifdef _XBOX_ONE
		Utilities::WriteWarning("no client auth on Xbox One");
		Assert::IsTrue(true);
#else
		ClientAuth clientAuth;
		Assert::ExpectException<TwitchException>([&clientAuth] { clientAuth.StartAuth(_T("clientId"), _T("redirectUri"), Utilities::scopes); });
# ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
# endif
#endif
	}

	TEST_METHOD(ServerAuth_Success) {
		ServerAuth serverAuth;
		tstring state;
		serverAuth.StartAuth(_T("clientId"), _T("redirectUri"), Utilities::scopes, state);
		Assert::IsTrue(state.size() == 32);
		serverAuth.Finish(_T("accessToken"), _T("refreshToken"));
		auto accessToken = serverAuth.AccessToken;
		Assert::AreEqual(tstring(_T("accessToken")), accessToken);
#ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
#endif
	}

	TEST_METHOD(ApplicationAuth_Success) {
#if defined(_WIN32) && !defined(_XBOX_ONE)
		ApplicationAuth applicationAuth;
		std::ifstream fin("../../secret.txt");
		if(fin) {
			std::string s;
			std::getline(fin, s);
			auto future = applicationAuth.StartAuth(_T("8jtw1bl78ng6xej11rt191bofwsop0"), ToTstring(s), _T(""));
			auto accessToken = future.get();
			Assert::IsFalse(accessToken.empty());
		} else {
			Utilities::WriteWarning("cannot open secret.txt");
		}
#endif
	}
	};

#ifdef _WIN32
	bool AuthTest::ShellExecute_invoked;
#endif
}
