#include "pch.h"
#ifndef _XBOX_ONE
# include <shellapi.h>
# include <Shlwapi.h>

# pragma comment(lib, "shell32.lib")
# pragma comment(lib, "Shlwapi.lib")
#endif

using namespace Twitch;

BrowserAuth::BrowserAuth() : isReady(false) {}

BrowserAuth::~BrowserAuth() {}

std::future<tstring> BrowserAuth::Launch(tstring const& url, tstring const& state, string_t scheme) {
	UNREFERENCED_PARAMETER(state);
	UNREFERENCED_PARAMETER(scheme);
#ifdef UNIT_TEST
	UNREFERENCED_PARAMETER(url);
	auto fn = [this] {
		return token;
	};
#else
# ifdef _XBOX_ONE
	ThrowIfFailed(XLaunchUri(nullptr, FromTstring(url).c_str()));
# else
	auto handle = ShellExecute(nullptr, nullptr, url.c_str(), nullptr, nullptr, SW_SHOWNORMAL);
	auto value = reinterpret_cast<INT_PTR>(handle);
	if(value <= 32) {
		throw TwitchException(FromPlatformError(static_cast<int>(value)));
	}
# endif
	auto fn = [this] {
		TokenLock lock(tokenAccessor);
		if(!isReady) {
			cv.wait(lock, [this] { return isReady; });
		}
		return token;
	};
#endif
	return std::async(std::launch::deferred, fn);
}

void BrowserAuth::Stop(tstring const& token_) {
#ifdef UNIT_TEST
	token = token_;
#else
	// Resolve the future returned from Launch.
	TokenLock lock(tokenAccessor);
	token = token_;
	isReady = true;
	cv.notify_all();
#endif
}
