//
// Game.cpp
//

#include "pch.h"
#include "Game.h"
#include "implementation.inl"

extern void ExitGame() noexcept;

using namespace DirectX;
using namespace WindowsLibTest;

static void RunTests() {
#include "invocation.inl"
	OutputDebugStringA("tests complete\n");
}

using Microsoft::WRL::ComPtr;

Game::Game() noexcept(false) : m_frame(0) {
	m_deviceResources = std::make_unique<DX::DeviceResources>();
}

// Initialize the Direct3D resources required to run.
void Game::Initialize(HWND window) {
	m_deviceResources->SetWindow(window);

	m_deviceResources->CreateDeviceResources();
	CreateDeviceDependentResources();

	m_deviceResources->CreateWindowSizeDependentResources();
	CreateWindowSizeDependentResources();
}

#pragma region Frame Update
// Executes the basic game loop.
void Game::Tick() {
	PIXBeginEvent(PIX_COLOR_DEFAULT, L"Frame %llu", m_frame);

	m_timer.Tick([&]() {
		Update(m_timer);
		});

	Render();

	PIXEndEvent();
	m_frame++;
}

// Updates the world.
void Game::Update(DX::StepTimer const& timer) {
	PIXScopedEvent(PIX_COLOR_DEFAULT, L"Update");

	float elapsedTime = float(timer.GetElapsedSeconds()); elapsedTime;

	RunTests();
	ExitGame();
}
#pragma endregion

#pragma region Frame Render
// Draws the scene.
void Game::Render() {
	// Don't try to render anything before the first Update.
	if (m_timer.GetFrameCount() == 0) {
		return;
	}

	// Prepare the command list to render a new frame.
	m_deviceResources->Prepare();
	Clear();

	auto commandList = m_deviceResources->GetCommandList();
	PIXBeginEvent(commandList, PIX_COLOR_DEFAULT, L"Render");

#pragma message( __FILE__  ": TODO in Render" )
	// TODO: Add your rendering code here.
	commandList;

	PIXEndEvent(commandList);

	// Show the new frame.
	PIXBeginEvent(PIX_COLOR_DEFAULT, L"Present");
	m_deviceResources->Present();

	PIXEndEvent();
}

// Helper method to clear the back buffers.
void Game::Clear() {
	auto commandList = m_deviceResources->GetCommandList();
	PIXBeginEvent(commandList, PIX_COLOR_DEFAULT, L"Clear");

	// Clear the views.
	auto rtvDescriptor = m_deviceResources->GetRenderTargetView();
	auto dsvDescriptor = m_deviceResources->GetDepthStencilView();

	commandList->OMSetRenderTargets(1, &rtvDescriptor, FALSE, &dsvDescriptor);
	commandList->ClearRenderTargetView(rtvDescriptor, Colors::CornflowerBlue, 0, nullptr);
	commandList->ClearDepthStencilView(dsvDescriptor, D3D12_CLEAR_FLAG_DEPTH, 1.0f, 0, 0, nullptr);

	// Set the viewport and scissor rect.
	auto viewport = m_deviceResources->GetScreenViewport();
	auto scissorRect = m_deviceResources->GetScissorRect();
	commandList->RSSetViewports(1, &viewport);
	commandList->RSSetScissorRects(1, &scissorRect);

	PIXEndEvent(commandList);
}
#pragma endregion

#pragma region Message Handlers
// Occurs when the game is being suspended.
void Game::OnSuspending() {
	m_deviceResources->Suspend();
}

// Occurs when the game is resuming.
void Game::OnResuming() {
	m_deviceResources->Resume();
	m_timer.ResetElapsedTime();
}
#pragma endregion

#pragma region Direct3D Resources
// These are the resources that depend on the device.
void Game::CreateDeviceDependentResources() {
	auto device = m_deviceResources->GetD3DDevice();

#pragma message( __FILE__  ": TODO in CreateDeviceDependentResources" )
	// TODO: Initialize device dependent objects here (independent of window size).
	device;
}

// Allocate all memory resources that change on a window SizeChanged event.
void Game::CreateWindowSizeDependentResources() {
#pragma message( __FILE__  ": TODO in CreateWindowSizeDependentResources" )
	// TODO: Initialize windows-size dependent objects here.
}
#pragma endregion
