#include "pch.h"
#include <nn/crypto.h>
#include <nn/nifm.h>
#include <nn/socket.h>
#include <nn/ssl.h>

bool Twitch::Initialize(nn::TimeSpan timeout /*= nn::TimeSpan::FromSeconds(10)*/) {
	auto result = nn::ssl::Initialize();
	if(result.IsFailure() && !nn::ssl::ResultLibraryAlreadyInitialized::Includes(result)) {
		DebugWriteLine("[Twitch::Initialize] nn::ssl::Initialize failed:  %d", result.GetDescription());
		return false;
	}
	result = nn::nifm::Initialize();
	if(result.IsSuccess()) {
		nn::nifm::SubmitNetworkRequest();
		nn::TimeSpan sleepTime = nn::TimeSpan::FromMilliSeconds(100);
		nn::TimeSpan timeSpent = nn::TimeSpan::FromMilliSeconds(0);
		while(nn::nifm::IsNetworkRequestOnHold()) {
			nn::os::SleepThread(sleepTime);
			timeSpent += sleepTime;
			if(timeSpent >= timeout) {
				DebugWriteLine("[Twitch::Initialize] nn::nifm::SubmitNetworkRequest timed out");
				break;
			}
		}
		if(nn::nifm::IsNetworkAvailable()) {
			static nn::socket::ConfigDefaultWithMemory g_SocketConfigWithMemory;
			result = nn::socket::Initialize(g_SocketConfigWithMemory);
			if(result.IsSuccess()) {
				return true;
			} else {
				DebugWriteLine("[Twitch::Initialize] nn::socket::Initialize failed:  %d", result.GetDescription());
			}
		} else {
			DebugWriteLine("[Twitch::Initialize] network is not available.");
		}
		nn::nifm::CancelNetworkRequest();
	} else {
		DebugWriteLine("[Twitch::Initialize] nn::nifm::Initialize failed:  %d", result.GetDescription());
	}
	nn::ssl::Finalize();
	return false;
}

void Twitch::rand_s(unsigned* p) {
	nn::crypto::GenerateCryptographicallyRandomBytes(p, sizeof(*p));
}
