#include "pch.h"
#include <nn/diag.h>
#include <nn/oe.h>
#include <Internal.h>

using namespace Twitch;

namespace {
	std::string const sdkRuntime = "C++";
	std::string const rextension = "ssn.";

	std::string GetApplicationName() {
		std::vector<char> buffer(nn::diag::GetRequiredBufferSizeForGetAllModuleInfo());
		if(!buffer.empty()) {
			nn::diag::ModuleInfo* modules;
			auto const n = nn::diag::GetAllModuleInfo(&modules, &buffer[0], buffer.size());
			for(auto i = 0; i < n; ++i) {
				auto path = std::string(modules[i].path);
				if(std::equal(rextension.cbegin(), rextension.cend(), path.crbegin(), path.crbegin() + rextension.size())) {
					auto const* p = strrchr(path.c_str(), '\\');
					if(p) {
						path = p + 1;
					}
					path.erase(path.size() - rextension.size());
					return path;
				}
			}
		}
		return std::string();
	}

	std::string GetDeviceId() {
		nn::oe::Initialize();
		nn::util::Uuid pseudoDeviceId;
		nn::oe::GetPseudoDeviceId(&pseudoDeviceId);
		char s[nn::util::Uuid::StringSize];
		pseudoDeviceId.ToString(s, nn::util::Uuid::StringSize);
		return s;
	}
}

#include "Analytics.inl"
