#include "pch.h"
#include "RawSocket.h"

using namespace Twitch;

constexpr std::chrono::seconds Socket::DefaultTimeout /*= std::chrono::seconds(10)*/;

RawSocket::RawSocket() {
	value = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp);
	if (value < 0) {
		throw TwitchException(value);
	}
}

RawSocket::~RawSocket() {
	Close();
}

void RawSocket::InternalClose() noexcept {
	auto const value_ = __sync_swap(&value, 0);
	if (value_) {
		nn::socket::Close(value_);
	}
}

int RawSocket::InternalConnect(string_t hostName, unsigned short port, std::chrono::milliseconds timeout) noexcept {
	nn::socket::TimeVal timeout_{};
	timeout_.tv_sec = timeout.count() / 1000;
	timeout_.tv_usec = (timeout.count() % 1000) / 1000;
	int errorCode = nn::socket::SetSockOpt(value, nn::socket::Level::Sol_Socket, nn::socket::Option::So_SndTimeo, &timeout_, sizeof(timeout_));
	if (errorCode < 0) {
		DebugWriteLine(_T("[RawSocket::InternalConnect] nn::socket::SetSockOpt failed:  %d"), errorCode);
		return errorCode;
	}
	auto* hostEntry = nn::socket::GetHostEntByName(hostName);
	if (hostEntry == nullptr) {
		return errno;
	}
	nn::socket::SockAddrIn sa{};
	sa.sin_addr = *reinterpret_cast<nn::socket::InAddr*>(hostEntry->h_addr_list[0]);
	sa.sin_family = nn::socket::Family::Af_Inet;
	sa.sin_port = nn::socket::InetHtons(static_cast<std::uint16_t>(port));
	errorCode = nn::socket::Connect(value, reinterpret_cast<nn::socket::SockAddr const*>(&sa), sizeof(sa));
	if (errorCode < 0) {
		DebugWriteLine(_T("[RawSocket::InternalConnect] sceNetConnect failed %#x (%d)"), errorCode, nn::socket::GetLastError());
		return errorCode;
	}
	return 0;
}

int RawSocket::InternalReceive(void* buffer, size_t size) noexcept {
	return nn::socket::Recv(value, buffer, size, nn::socket::MsgFlag::Msg_None);
}

int RawSocket::InternalSend(void const* buffer, size_t size) noexcept {
	return nn::socket::Send(value, buffer, size, nn::socket::MsgFlag::Msg_None);
}
