#include "pch.h"
#include <libsecure.h>
#include <sce_random.h>

#pragma comment(lib, "SceRandom_stub_weak")
#pragma comment(lib, "SceSecure")
#pragma comment(lib, "SceSysmodule_stub_weak")

namespace {
	SceLibSecureErrorType Initialize() {
		// Load Sony's Random module, use it to generate a seed, and initialize
		// Sony's Secure library with it.
		int loadResult = sceSysmoduleLoadModule(SCE_SYSMODULE_RANDOM);
		static char buffer[4160];
		int randomResult = sceRandomGetRandomNumber(buffer, SCE_RANDOM_MAX_SIZE);
		SceLibSecureBlock initialBlock{ buffer, sizeof(buffer) };
		SceLibSecureErrorType const secureResult = sceLibSecureInit(SCE_LIBSECURE_FLAGS_RANDOM_GENERATOR, &initialBlock);
		UNREFERENCED_PARAMETER(loadResult);
		UNREFERENCED_PARAMETER(randomResult);
		return secureResult;
	}
}

void Twitch::rand_s(unsigned* p) {
	// Initialize Sony's Secure library.
	static SceLibSecureErrorType result = Initialize();
	UNREFERENCED_PARAMETER(result);

	// Use it to generate a cryptographically secure random number.  Failing
	// that, use the C library's random number generation function.
	SceLibSecureBlock block{ p, sizeof(*p) };
	if(sceLibSecureRandom(&block) != SCE_LIBSECURE_OK) {
		*p = rand();
	}
}
