#include "pch.h"
#include <libnetctl.h>
#include <Internal.h>

#pragma comment(lib, "SceNetCtl_stub_weak")

using namespace Twitch;

namespace {
	std::string const sdkRuntime = "C++";

	std::string GetApplicationName() {
		char buf[33];
		if(scePthreadGetname(scePthreadSelf(), buf) == SCE_OK) {
			return buf;
		}
		return std::string();
	}

	std::string GetDeviceId() {
		// TODO:  document this TRC requirement.
		// https://ps4.siedev.net/resources/documents/TRC/2018.02/TRC/R4081.html
		union {
			SceNetCtlInfo info;
			unsigned short n[3];
		} u{};
		static_assert(sizeof(u.info.ether_addr) == sizeof(u.n), "unexpected size");
		if(sceNetCtlGetInfo(SCE_NET_CTL_INFO_ETHER_ADDR, &u.info) == 0 && (u.n[0] || u.n[1] || u.n[2])) {
			char deviceId[37];
			sprintf_s(deviceId, "00000000-%04x-%04x-%04x-000000000000", u.n[0], u.n[1], u.n[2]);
			return deviceId;
		}
		return std::string();
	}
}

#include "Analytics.inl"
