@IF "%~1" == "" ECHO OFF
SETLOCAL

REM Validate the command line and set the environment variables.
IF NOT "%~2" == "" EXIT /B 2
SET ZIP=%SYSTEMDRIVE%\Program Files\7-Zip\7z.exe
IF NOT EXIST "%ZIP%" (
	ECHO "%ZIP%" not found
	EXIT /B 1
)
SET NAME=BaseSDK
SET SDK=%~dp0packages\%NAME%
FOR /F "delims=" %%I IN ('TYPE "%~dp0version.txt"') DO SET VERSION=%%I
SET ZIP_FILE_PATH=%SDK%-%VERSION%.zip

REM Create the package directories.
IF EXIST "%SDK%" (
	RD /Q /S "%SDK%"
	IF ERRORLEVEL 1 EXIT /B
)
FOR %%I IN (Gaming.Xbox.XboxOne.x64 NX64 ORBIS x64 x86) DO FOR %%J IN (Debug Release) DO MD "%SDK%\%%I\%%J"
IF ERRORLEVEL 1 EXIT /B

REM Copy the platform-agnostic files.
COPY "%~dp0Shared\Twitch.h" "%SDK%\%NAME%.h"
COPY "%~dp0LICENSE" "%SDK%"
IF ERRORLEVEL 1 EXIT /B

REM Copy all output files to their respective package directories.
FOR %%I IN (Debug Release) DO (
	COPY "%~dp0NX64\%%I\lib%NAME%.a" "%SDK%\NX64\%%I"
	COPY "%~dp0ORBIS\%%I\lib%NAME%.a" "%SDK%\ORBIS\%%I"
	FOR %%J IN (Gaming.Xbox.XboxOne.x64 x64 x86) DO (
		COPY "%~dp0%%J\%%I\%NAME%.lib" "%SDK%\%%J\%%I"
		COPY "%~dp0%%J\%%I\%NAME%.pdb" "%SDK%\%%J\%%I"
	)
)
IF ERRORLEVEL 1 EXIT /B

REM Create the Zip file.
IF EXIST "%ZIP_FILE_PATH%" DEL /F /Q "%ZIP_FILE_PATH%"
"%ZIP%" a -r "%ZIP_FILE_PATH%" "%SDK%"
