// Poly-fill the String trim method.
if (!String.prototype.trim) {
  String.prototype.trim = function() {
    return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
  };
}

// Create the main header and inline files.
var ForReading = 1, ForWriting = 2, ForAppending = 8, i, j;
var fso = WScript.CreateObject('Scripting.FileSystemObject');
var directory = WScript.Arguments(0);
var namespaceName = WScript.Arguments(1);
var implementationFile = fso.CreateTextFile(directory + '\\implementation.inl');
var invocationFile = fso.CreateTextFile(directory + '\\invocation.inl');

implementationFile.WriteLine('// Auto-generated; do not edit');
invocationFile.WriteLine('\t// Auto-generated; do not edit');

// Read standard input, collecting case and test names.
var tests = {}, caseName;
while (!WScript.StdIn.AtEndOfStream) {
  var line = WScript.StdIn.ReadLine();
  if (~line.indexOf('TEST_CLASS(')) {
    i = line.indexOf('(');
    j = line.indexOf(')', i);
    caseName = line.substring(i + 1, j);
    if (tests[caseName]) {
      throw 'Unexpected case name';
    }
    tests[caseName] = [];
  } else if (~line.indexOf('TEST_METHOD') || ~line.indexOf('TEST_CLASS_INITIALIZE')) {
    if (!caseName) {
      throw 'No case name';
    }
    i = line.indexOf('(');
    j = line.indexOf(')', i);
    var testName = line.substring(i + 1, j);
    tests[caseName].push(testName);
  }
}

// Populate the main header and inline files and create the test case header files.
for (var key in tests) {
  implementationFile.WriteLine('#include "../WindowsLibTest/' + key + '.cpp"');
  var instanceName = key.toLowerCase();
  invocationFile.WriteLine('\t' + '::' + namespaceName + '::' + key + ' ' + instanceName + ';');
  var test = tests[key];
  for (i = 0, n = test.length; i < n; ++i) {
    invocationFile.WriteLine('\tDebugWriteLine(_T("' + key + '::' + test[i] + '"));');
    invocationFile.WriteLine('\t' + instanceName + '.' + test[i] + '();');
  }
}
