# Twitch Base SDK

This is the Twitch Base SDK in C++ targeting Windows Desktop, PlayStation 4, and
Xbox One.  The [Authentication SDK](https://git.xarth.tv/devhub/authentication-sdk)
and the [Enhanced Experiences SDK](https://git.xarth.tv/devhub/enhanced-experiences-sdk)
make use of this SDK.

Execute the following command in a command prompt to clone this repository since
it contains Git sub-modules.
```
git clone --recurse-submodules git@git.xarth.tv:devhub/base-sdk.git
```
If you cloned it without the `--recurse-submodules` flag, execute the following
command in a command prompt in the repository directory to populate the
sub-modules.
```
git submodule update --init --recursive
```

## Set-up

1. Install **Visual Studio 2019**.
2. Install [Git for Windows](https://gitforwindows.org/).
3. Add the following to your `.gitconfig` file in your home directory.

```
[core]
	symlinks = true
[url "git@git.xarth.tv:"]
	insteadOf = https://git.xarth.tv/
```
