#pragma once

#include "twitchsdk/core/json/value.h"

namespace Twitch {
	class Json {
	public:
		using array = std::vector<Json>;
		using object = std::map<std::string, Json>;

		Json() = default;
		Json(bool value) : value(value) {}
		Json(int value) : value(value) {}
		Json(array const& values);
		Json(array&& values);
		Json(object const& values);
		Json(object&& values);
		Json(std::string const& value) : value(value) {}
		Json(std::string&& value) : value(value) {}
		Json(char const* value) : value(value) {}
		template <class T, class = decltype(&T::to_json)>
		Json(const T& t) : Json(t.to_json()) {}
		template <class V, typename std::enable_if<
			std::is_constructible<Json, decltype(*std::declval<V>().begin())>::value,
			int>::type = false>
			Json(const V& v) : Json(array(v.begin(), v.end())) {}
		~Json() = default;
		Json operator[](std::string const& s) const;
		std::string dump() const;
		array array_items() const;
		object object_items() const;
		bool is_array() const { return Value.isNonNullArray(); }
		bool is_number() const { return Value.isNumeric(); }
		bool is_object() const { return Value.isNonNullObject(); }
		bool is_string() const { return Value.isString(); }
		bool bool_value() const { return Value.isBool() && Value.asBool(); }
		std::string string_value() const;
		int int_value() const;
		static Json Parse(std::string const& s, std::string& error) { return Parse(std::string_view(s), error); }
		static Json Parse(std::string_view s, std::string& error);

	private:
		ttv::json::Value* p{};
		ttv::json::Value value;

		ttv::json::Value& get_Value() const { return const_cast<ttv::json::Value&>(p ? *p : value); }
		__declspec(property(get = get_Value)) ttv::json::Value& Value;

		Json(ttv::json::Value* p) : p(p) {}
		Json(ttv::json::Value&& value) : value(std::move(value)) {}
	};
}
