#pragma once

#include "../Shared/Socket.h"

namespace Twitch {
	struct RawSocket : public Socket {
	public:
		RawSocket();
		RawSocket(RawSocket const&) = delete;
		RawSocket(RawSocket&& that) noexcept {
			std::swap(value, that.value);
		}
		RawSocket& operator=(RawSocket const&) = delete;
		RawSocket& operator=(RawSocket&& that) noexcept {
			std::swap(value, that.value);
			return *this;
		}
		~RawSocket();

	protected:
		void InternalClose() noexcept override;
		int InternalConnect(string_t hostName, unsigned short port, std::chrono::milliseconds timeout) noexcept override;
		int InternalReceive(void* buffer, size_t size) noexcept override;
		int InternalSend(void const* buffer, size_t size) noexcept override;

	private:
		SOCKET value;
	};
}
