#pragma once

#if defined(_WIN32)
# include <WinSock2.h>
# include <WS2tcpip.h>
#elif defined(__ORBIS__)
# include <net.h>
#endif
#include "../Shared/Socket.h"

namespace Twitch {
	struct SecureSocket : public Socket {
	public:
		SecureSocket();
		SecureSocket(SecureSocket const&) = delete;
		SecureSocket(SecureSocket&& that);
		SecureSocket& operator=(SecureSocket const&) = delete;
		SecureSocket& operator=(SecureSocket&& that) = delete;
		~SecureSocket();

	protected:
		void InternalClose() noexcept override;
		int InternalConnect(string_t hostName, unsigned short port, std::chrono::milliseconds timeout) noexcept override;
		int InternalReceive(void* buffer, size_t size) noexcept override;
		int InternalSend(void const* buffer, size_t size) noexcept override;

	private:
		struct SecureSocketImpl;

		std::unique_ptr<SecureSocketImpl> pimpl;
	};
}
