WebSocket::WebSocket() : pimpl(std::make_unique<WebSocketImpl>()) {}
WebSocket::WebSocket(WebSocket&&) noexcept = default;
WebSocket& WebSocket::operator=(WebSocket&&) noexcept = default;
WebSocket::~WebSocket() = default;

void WebSocket::Close() {
	pimpl->Close();
}

int WebSocket::Open(string_t url, std::chrono::milliseconds timeout /*= HttpRequest::DefaultTimeout*/) {
	return pimpl->Open(url, timeout);
}

int WebSocket::Send(void const* data, size_t size) {
	return pimpl->Send(data, size);
}

bool WebSocket::GetIsOpen() const {
	return pimpl->IsOpen;
}

WebSocket::ClosedFn WebSocket::GetOnClosed() const {
	return pimpl->OnClosed;
}

void WebSocket::SetOnClosed(ClosedFn closeFn) {
	pimpl->OnClosed = closeFn;
}

WebSocket::ReceivedFn WebSocket::GetOnReceived() const {
	return pimpl->OnReceived;
}

void WebSocket::SetOnReceived(ReceivedFn receiveFn) {
	pimpl->OnReceived = receiveFn;
}

#ifdef __NX__
bool WebSocket::Process() {
	return pimpl->Process();
}
#endif
