#include "pch.h"

#ifdef _WIN32
namespace {
	template<typename T>
	int sscanf_(char const* s, char const* format, T* p) {
		return sscanf_s(s, format, p);
	}
# define sscanf sscanf_
}
#endif

#ifdef _WIN32
# pragma warning(push)
# pragma warning(disable: 4244)
#else
#endif
#include "../vendor/sdk/modules/core/core_common/source/json/corejsonutil.cpp"
#ifdef _WIN32
# pragma warning(pop)
#else
#endif
#include "../vendor/sdk/modules/core/core_common/source/json/json_reader.cpp"
#ifdef _WIN32
# pragma warning(push)
# pragma warning(disable: 4463)
#else
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wimplicit-const-int-float-conversion"
#endif
#include "../vendor/sdk/modules/core/core_common/source/json/json_value.cpp"
#ifdef _WIN32
# pragma warning(pop)
#else
# pragma clang diagnostic pop
#endif
#include "../vendor/sdk/modules/core/core_common/source/json/json_writer.cpp"

// The following are from ../vendor/sdk/modules/core/core_common/source/stringutilities.cpp.
// That file does not compile since it uses std::ptr_fun, removed from C++17.

namespace {
	uint32_t CountDays(int32_t y, int32_t m, int32_t d) {
		if (m <= 2) {
			y--;
		}

		int32_t era = (y >= 0 ? y : y - 399) / 400;
		int32_t yoe = y - era * 400;                                   // [0, 399]
		int32_t doy = (153 * (m + (m > 2 ? -3 : 9)) + 2) / 5 + d - 1;  // [0, 365]
		int32_t doe = yoe * 365 + yoe / 4 - yoe / 100 + doy;           // [0, 146096]

		return static_cast<uint32_t>(era * 146097 + doe - 719468);
	}

	bool RFC3339TimeToTimePoint(const std::string& str, std::chrono::system_clock::time_point& result) {
		// using days = std::chrono::duration<int, std::ratio_multiply<std::ratio<24>, std::chrono::hours::period>>;

		using namespace std::chrono;

		std::istringstream is(str);
		const std::time_get<char>& tg = std::use_facet<std::time_get<char>>(is.getloc());

		try {
			uint32_t base = 0;
			uint32_t offset = 0;

			// Read YYYY:MM:DT:HH:MM:SS
			if (!is.eof()) {
				const char patternYMDHMS[] = "%Y-%m-%dT%H:%M:%S";

				std::tm baseTime;
				std::ios_base::iostate err = std::ios_base::goodbit;
				tg.get(is, nullptr, is, err, &baseTime, std::begin(patternYMDHMS), std::end(patternYMDHMS) - 1);

				if (err != std::ios_base::goodbit) {
					return false;
				}

				base = CountDays(baseTime.tm_year + 1900, baseTime.tm_mon + 1, baseTime.tm_mday) * 24 * 60 * 60 +
					static_cast<uint32_t>(baseTime.tm_hour) * 60 * 60 + static_cast<uint32_t>(baseTime.tm_min) * 60 +
					static_cast<uint32_t>(baseTime.tm_sec) * 1;
			}

			// Check if there is a time offset from UTC specified
			char sign = '\0';
			if (!is.eof()) {
				is.get(sign);
				if (is.rdstate() != std::ios_base::goodbit) {
					return false;
				}

				// Throw out fractional seconds
				if (sign == '.') {
					uint32_t frac = 0;
					is >> frac;

					// Try to get the sign again
					if (!is.eof()) {
						is.get(sign);
						if (is.rdstate() != std::ios_base::goodbit) {
							return false;
						}
					}
				}
			}

			// Handle specific time shift from UTC
			if (sign == '+' || sign == '-') {
				std::tm offsetTime;
				const char patternHM[] = "%H:%M";

				std::ios_base::iostate err = std::ios_base::goodbit;
				tg.get(is, nullptr, is, err, &offsetTime, std::begin(patternHM), std::end(patternHM) - 1);

				if (!(err & std::ios_base::failbit)) {
					offset =
						static_cast<uint32_t>((sign == '+' ? 1 : -1) * ((offsetTime.tm_hour * 3600) + (offsetTime.tm_min * 60)));
				}
			}
			// UTC
			else if (sign == 'Z') {
				offset = 0;
			}

			result = system_clock::from_time_t(static_cast<time_t>(base - offset));
		} catch (...) {
			// Eat any errors
			return false;
		}

		return true;
	}
}

bool ttv::RFC3339TimeToUnixTimestamp(const std::string& str, Timestamp& result) {
	result = 0;

	std::chrono::system_clock::time_point timePoint;
	if (!RFC3339TimeToTimePoint(str, timePoint)) {
		return false;
	}

	result = static_cast<Timestamp>(std::chrono::system_clock::to_time_t(timePoint));

	return true;
}

bool ttv::ParseNum(const std::string& str, int& out) {
	return sscanf(str.c_str(), "%d", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, signed char& out) {
	return sscanf(str.c_str(), "%hhd", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, short int& out) {
	return sscanf(str.c_str(), "%hd", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, long int& out) {
	return sscanf(str.c_str(), "%ld", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, long long int& out) {
	return sscanf(str.c_str(), "%lld", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, unsigned int& out) {
	return sscanf(str.c_str(), "%u", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, unsigned char& out) {
	return sscanf(str.c_str(), "%hhu", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, unsigned short int& out) {
	return sscanf(str.c_str(), "%hu", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, unsigned long int& out) {
	return sscanf(str.c_str(), "%lu", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, unsigned long long int& out) {
	return sscanf(str.c_str(), "%llu", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, float& out) {
	return sscanf(str.c_str(), "%f", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, double& out) {
	return sscanf(str.c_str(), "%lf", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, long double& out) {
	return sscanf(str.c_str(), "%Lf", &out) == 1;
}

bool ttv::ParseNum(const std::string& str, char& out) {
	return sscanf(str.c_str(), "%c", &out) == 1;
}

bool ttv::ParseBool(const std::string& str, bool& out) {
	if (str == "true" || str == "1") {
		out = true;
		return true;
	} else if (str == "false" || str == "0") {
		out = false;
		return true;
	}

	return false;
}
