#include "pch.h"
#include "../Shared/Internal.h"
#include "../Shared/HttpUtil.h"

using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;

namespace WindowsLibTest {
	TEST_CLASS(UriTest) {
public:
	TEST_METHOD(ValidUri_Success) {
		string_t url = _T("protocol://host:port/a/b.c?e=f");
		Uri uri;
		uri.SetUrl(url);
		Assert::AreEqual(_T("protocol"), uri.GetProtocol().c_str());
		Assert::AreEqual(_T("host"), uri.GetHostName().c_str());
		Assert::AreEqual(_T("port"), uri.GetPort().c_str());
		Assert::AreEqual(_T("/a/b.c"), uri.GetPath().c_str());
		auto params = uri.GetParams();
		Assert::AreEqual(static_cast<size_t>(1), params.size());
		Assert::AreEqual(_T("e"), params.cbegin()->first.c_str());
		Assert::AreEqual(_T("f"), params.cbegin()->second.c_str());
		Assert::AreEqual(_T("/a/b.c?e=f"), uri.GetResource().c_str());
		Assert::AreEqual(url, uri.GetUrl().c_str());
	}

	TEST_METHOD(NoProtocol_Success) {
		string_t url = _T("host:port/a/b.c?e=f");
		Uri uri;
		uri.SetUrl(url);
		Assert::IsTrue(uri.GetProtocol().empty());
		Assert::AreEqual(_T("host"), uri.GetHostName().c_str());
		Assert::AreEqual(_T("port"), uri.GetPort().c_str());
		Assert::AreEqual(_T("/a/b.c"), uri.GetPath().c_str());
		auto params = uri.GetParams();
		Assert::AreEqual(static_cast<size_t>(1), params.size());
		Assert::AreEqual(_T("e"), params.cbegin()->first.c_str());
		Assert::AreEqual(_T("f"), params.cbegin()->second.c_str());
		Assert::AreEqual(_T("/a/b.c?e=f"), uri.GetResource().c_str());
		Assert::AreEqual(url, uri.GetUrl().c_str());
	}

	TEST_METHOD(NoPath_Success) {
		string_t url = _T("protocol://host:port?e=f");
		Uri uri;
		uri.SetUrl(url);
		Assert::AreEqual(_T("protocol"), uri.GetProtocol().c_str());
		Assert::AreEqual(_T("host"), uri.GetHostName().c_str());
		Assert::AreEqual(_T("port"), uri.GetPort().c_str());
		Assert::AreEqual(_T("/"), uri.GetPath().c_str());
		auto params = uri.GetParams();
		Assert::AreEqual(static_cast<size_t>(1), params.size());
		Assert::AreEqual(_T("e"), params.cbegin()->first.c_str());
		Assert::AreEqual(_T("f"), params.cbegin()->second.c_str());
		Assert::AreEqual(_T("/?e=f"), uri.GetResource().c_str());
		Assert::AreEqual(_T("protocol://host:port/?e=f"), uri.GetUrl().c_str());
	}

	TEST_METHOD(NoPathNoQueryString_Success) {
		string_t url = _T("protocol://host:port");
		Uri uri;
		uri.SetUrl(url);
		Assert::AreEqual(_T("protocol"), uri.GetProtocol().c_str());
		Assert::AreEqual(_T("host"), uri.GetHostName().c_str());
		Assert::AreEqual(_T("port"), uri.GetPort().c_str());
		Assert::AreEqual(_T("/"), uri.GetPath().c_str());
		auto params = uri.GetParams();
		Assert::AreEqual(static_cast<size_t>(0), params.size());
		Assert::AreEqual(_T("/"), uri.GetResource().c_str());
		Assert::AreEqual(_T("protocol://host:port/"), uri.GetUrl().c_str());
	}

	TEST_METHOD(NoQueryString_Success) {
		string_t url = _T("protocol://host:port/a/b.c");
		Uri uri;
		uri.SetUrl(url);
		Assert::AreEqual(_T("protocol"), uri.GetProtocol().c_str());
		Assert::AreEqual(_T("host"), uri.GetHostName().c_str());
		Assert::AreEqual(_T("port"), uri.GetPort().c_str());
		Assert::AreEqual(_T("/a/b.c"), uri.GetPath().c_str());
		auto params = uri.GetParams();
		Assert::AreEqual(static_cast<size_t>(0), params.size());
		Assert::AreEqual(_T("/a/b.c"), uri.GetResource().c_str());
		Assert::AreEqual(url, uri.GetUrl().c_str());
	}

	TEST_METHOD(NumericPort_Success) {
		Uri uri;
		uri.SetUrl(_T("protocol://host:11/a/b.c?e=f"));
		std::uint16_t port;
		Assert::IsTrue(uri.GetPort(port));
		Assert::AreEqual(static_cast<int>(port), 11);
	}
	};
}
