#include "pch.h"
#include "../Shared/Internal.h"

using namespace std::literals;
using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;

extern char const* const sdkVersion = "0.0.0";

namespace WindowsLibTest {
	TEST_CLASS(WindowsLibTest) {
		Twitch::string_t const clientId = _T("8jtw1bl78ng6xej11rt191bofwsop0"); // Stick3

public:
	TEST_METHOD(CheckHttpGet) {
#ifdef __NX__
		std::vector<HttpParam> requestHeaders{
			HttpParam(_T("X-MyName1"), _T("X-MyValue1")),
			HttpParam(_T("X-MyName2"), _T("X-MyValue2")),
		};
		int result;
		uintptr_t handle;
		std::tie(result, handle) = Platform::StartHttpRequest(_T("https://example.com"), HttpRequestType::HTTP_GET_REQUEST, std::chrono::seconds(10), requestHeaders, std::vector<char>());
		if (result == 0) {
			std::vector<char> response;
			std::tie(result, response) = Platform::GetHttpResponse(handle, 0s);
			stringmap responseHeaders;
			std::tie(result, responseHeaders) = Platform::GetHttpResponseHeaders(handle);
			int statusCode = Platform::GetHttpResponseResultCode(handle);
			Platform::FinishHttpRequest(handle, 0s);
			Assert::AreEqual(200, statusCode);
		} else {
			Assert::AreEqual(0, result);
		}
#endif
	}

	TEST_METHOD(CheckHttpPost) {
#ifdef __NX__
		std::string requestBody = "my_name1=my_value1&my_name2=my_value2";
		std::vector<HttpParam> requestHeaders{
			HttpParam(_T("X-MyName1"), _T("X-MyValue1")),
			HttpParam(_T("X-MyName2"), _T("X-MyValue2")),
			HttpParam(_T("Content-Length"), to_tstring(requestBody.size())),
		};
		int result;
		uintptr_t handle;
		std::tie(result, handle) = Platform::StartHttpRequest(_T("https://example.com"), HttpRequestType::HTTP_POST_REQUEST, std::chrono::seconds(10), requestHeaders, std::vector<char>(requestBody.cbegin(), requestBody.cend()));
		if (result == 0) {
			std::vector<char> response;
			std::tie(result, response) = Platform::GetHttpResponse(handle, 0s);
			stringmap responseHeaders;
			std::tie(result, responseHeaders) = Platform::GetHttpResponseHeaders(handle);
			int statusCode = Platform::GetHttpResponseResultCode(handle);
			Platform::FinishHttpRequest(handle, 0s);
			Assert::AreEqual(200, statusCode);
		} else {
			Assert::AreEqual(0, result);
		}
#endif
	}

	TEST_METHOD(CheckEmptyUserScienceEvent) {
		stringmap properties{
			{ _T("property1"), _T("value1") },
			{ _T("property2"), _T("value2") },
		};
		SendUserScienceEvent(clientId, tstring(), _T("CheckEmptyUserScienceEvent"), properties);
	}

	TEST_METHOD(CheckTokenScienceEvent) {
		stringmap properties{
			{ _T("property1"), _T("value1") },
			{ _T("property2"), _T("value2") },
		};
		SendTokenScienceEvent(clientId, _T("token"), _T("CheckTokenScienceEvent"), properties);
	}

	TEST_METHOD(CheckUserScienceEvent) {
		stringmap properties{
			{ _T("property1"), _T("value1") },
			{ _T("property2"), _T("value2") },
		};
		SendUserScienceEvent(clientId, _T("user"), _T("CheckUserScienceEvent"), properties);
	}

	TEST_METHOD(CheckKnownTwitchExceptionMessage) {
		TwitchException ex{ FromPlatformError(6) };
#if defined(__ORBIS__) || defined(__NX__)
		Assert::AreEqual("Error -2147483642 (0x80000006)", ex.what());
#elif defined(_XBOX_ONE)
		Assert::AreEqual("Error 6 (0x80070006)", ex.what());
#else
		Assert::AreEqual("The handle is invalid.\r\n", ex.what());
#endif
	}

	TEST_METHOD(CheckUnknownTwitchExceptionMessage) {
		TwitchException ex{ FromPlatformError(666) };
#if defined(__ORBIS__) || defined(__NX__)
		Assert::AreEqual("Error -2147482982 (0x8000029a)", ex.what());
#else
		Assert::AreEqual("Error 666 (0x8007029a)", ex.what());
#endif
	}

	TEST_METHOD(CheckBase64Encode) {
		// https://en.wikipedia.org/wiki/Base64
		std::string message = "Man is distinguished, not only by his reason, but by "
			"this singular passion from other animals, which is a lust of the "
			"mind, that by a perseverance of delight in the continued and "
			"indefatigable generation of knowledge, exceeds the short vehemence "
			"of any carnal pleasure.";
		std::vector<char> data(message.cbegin(), message.cend());
		std::string actual = Base64Encode(data);
		std::string expected = "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=";
		Assert::AreEqual(expected, actual);

		message = "any carnal pleasure";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "YW55IGNhcm5hbCBwbGVhc3VyZQ==";
		Assert::AreEqual(expected, actual);

		message = "any carnal pleasur";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "YW55IGNhcm5hbCBwbGVhc3Vy";
		Assert::AreEqual(expected, actual);

		message = "any carnal pleasu";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "YW55IGNhcm5hbCBwbGVhc3U=";
		Assert::AreEqual(expected, actual);

		message = "any carnal pleas";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "YW55IGNhcm5hbCBwbGVhcw==";
		Assert::AreEqual(expected, actual);

		message = "pleasure.";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "cGxlYXN1cmUu";
		Assert::AreEqual(expected, actual);

		message = "leasure.";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "bGVhc3VyZS4=";
		Assert::AreEqual(expected, actual);

		message = "easure.";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "ZWFzdXJlLg==";
		Assert::AreEqual(expected, actual);

		message = "asure.";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "YXN1cmUu";
		Assert::AreEqual(expected, actual);

		message = "sure.";
		data.assign(message.cbegin(), message.cend());
		actual = Base64Encode(data);
		expected = "c3VyZS4=";
		Assert::AreEqual(expected, actual);
	}
	};
}
