#include "pch.h"
#include "Internal.h"
#include "../Shared/HttpUtil.h"
#include "../Shared/Http.h"

using namespace Twitch;

Internets::~Internets() {
	Close();
}

void Internets::Add(HINTERNET internet) {
	handles.emplace_back(internet);
}

void Internets::ReplaceHttpRequest(HINTERNET internet) noexcept {
	assert(handles.size() == 3);
	WinHttpCloseHandle(handles.back());
	handles.back() = internet;
}

HINTERNET Internets::GetHttpRequest(uintptr_t handle) noexcept {
	if (handle) {
		auto const* internets = reinterpret_cast<Internets*>(handle);
		return internets->handles.back();
	}
	return HINTERNET();
}

void Internets::Close() noexcept {
	decltype(handles) handles_;
	std::swap(handles, handles_);
	auto result = WinHttpSetStatusCallback(handles_.back(), &Internets::CloseCallback, WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING, 0);
	std::for_each(handles_.crbegin(), handles_.crend(), WinHttpCloseHandle);
	if (result != WINHTTP_INVALID_STATUS_CALLBACK) {
		closePromise.get_future().get();
	}
}

void Internets::OnClose(HINTERNET hInternet) noexcept {
	WinHttpSetStatusCallback(hInternet, nullptr, WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS, 0);
	closePromise.set_value();
}

void Internets::EndResponse(HINTERNET hInternet, DWORD errorCode /*= 0*/) noexcept {
	WinHttpSetStatusCallback(hInternet, nullptr, WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS, 0);
	responsePromise.set_value(errorCode);
}

void Internets::EndSend(HINTERNET hInternet, DWORD errorCode /*= 0*/) noexcept {
	WinHttpSetStatusCallback(hInternet, nullptr, WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS, 0);
	sendPromise.set_value(errorCode);
}

void Internets::EndData(HINTERNET hInternet, DWORD errorCode /*= 0*/) noexcept {
	WinHttpSetStatusCallback(hInternet, nullptr, WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS, 0);
	dataPromise.set_value(errorCode);
}

VOID CALLBACK Internets::WebSocketCallback(HINTERNET hInternet, DWORD_PTR dwContext, DWORD dwInternetStatus, LPVOID lpvStatusInformation, DWORD /*dwStatusInformationLength*/) noexcept {
	auto* this_ = reinterpret_cast<Internets*>(dwContext);
	switch (dwInternetStatus) {
		WINHTTP_WEB_SOCKET_STATUS const* status;
	case WINHTTP_CALLBACK_STATUS_READ_COMPLETE:
		DebugWriteLine(_T("WINHTTP_CALLBACK_STATUS_READ_COMPLETE"));
		status = reinterpret_cast<WINHTTP_WEB_SOCKET_STATUS*>(lpvStatusInformation);
		try {
			this_->onReceive(&this_->buffer[0], status->dwBytesTransferred);
		} catch (std::exception const& ex) {
			UNREFERENCED_PARAMETER(ex);
			DebugWriteLine(_T("onReceive threw an exception \"%hs\""), ex.what());
		}
#pragma prefast(suppress: 6387, "WinHttpWebSocketReceive ignores the fourth and fifth parameters in asynchronous mode.")
		WinHttpWebSocketReceive(hInternet, &this_->buffer[0], static_cast<DWORD>(this_->buffer.size()), nullptr, nullptr);
		break;
	case WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE:
		DebugWriteLine(_T("WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE"));
		break;
	case WINHTTP_CALLBACK_STATUS_SHUTDOWN_COMPLETE:
		DebugWriteLine(_T("WINHTTP_CALLBACK_STATUS_SHUTDOWN_COMPLETE"));
		if (WinHttpWebSocketClose(hInternet, WINHTTP_WEB_SOCKET_ENDPOINT_TERMINATED_CLOSE_STATUS, nullptr, 0)) {
			DebugWriteLine(_T("WinHttpWebSocketClose error %d"), GetLastError());
			this_->shutdownPromise.set_value();
		}
		break;
	case WINHTTP_CALLBACK_STATUS_CLOSE_COMPLETE:
		DebugWriteLine(_T("WINHTTP_CALLBACK_STATUS_CLOSE_COMPLETE"));
		this_->shutdownPromise.set_value();
		break;
	case WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING:
		DebugWriteLine(_T("WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING"));
		this_->OnClose(hInternet);
		break;
	case WINHTTP_CALLBACK_STATUS_REQUEST_ERROR:
		DebugWriteLine(_T("WINHTTP_CALLBACK_STATUS_REQUEST_ERROR"));
		if (!this_->handles.empty()) {
			DebugWriteLine(_T("error %d result %d"), reinterpret_cast<WINHTTP_ASYNC_RESULT*>(lpvStatusInformation)->dwError, reinterpret_cast<WINHTTP_ASYNC_RESULT*>(lpvStatusInformation)->dwResult);
		}
		break;
	default:
		DebugWriteLine(_T("warning:  unexpected notification %#08x"), dwInternetStatus);
	}
}

VOID CALLBACK Internets::CloseCallback(HINTERNET hInternet, DWORD_PTR dwContext, DWORD dwInternetStatus, LPVOID /*lpvStatusInformation*/, DWORD /*dwStatusInformationLength*/) noexcept {
	auto* this_ = reinterpret_cast<Internets*>(dwContext);
	switch (dwInternetStatus) {
	case WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING:
		return this_->OnClose(hInternet);
	default:
		DebugWriteLine(_T("warning:  unexpected notification %#08x"), dwInternetStatus);
	}
}

VOID CALLBACK Internets::DataCallback(HINTERNET hInternet, DWORD_PTR dwContext, DWORD dwInternetStatus, LPVOID lpvStatusInformation, DWORD /*dwStatusInformationLength*/) noexcept {
	auto* this_ = reinterpret_cast<Internets*>(dwContext);
	switch (dwInternetStatus) {
		WINHTTP_ASYNC_RESULT* result;
		DWORD n;
	case WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE:
		n = *reinterpret_cast<decltype(n)*>(lpvStatusInformation);
		if (n) {
			auto size = this_->buffer.size();
			this_->buffer.resize(size + n);
			if (!WinHttpReadData(hInternet, &this_->buffer[size], n, nullptr)) {
				return this_->EndData(hInternet, GetLastError());
			}
		} else {
			return this_->EndData(hInternet);
		}
		break;
	case WINHTTP_CALLBACK_STATUS_READ_COMPLETE:
		if (!WinHttpQueryDataAvailable(hInternet, nullptr)) {
			return this_->EndData(hInternet, GetLastError());
		}
		break;
	case WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING:
		this_->OnClose(hInternet);
		return this_->EndData(hInternet, WSAECONNABORTED);
	case WINHTTP_CALLBACK_STATUS_REQUEST_ERROR:
		result = reinterpret_cast<WINHTTP_ASYNC_RESULT*>(lpvStatusInformation);
		return this_->EndData(hInternet, result->dwError);
	default:
		DebugWriteLine(_T("warning:  unexpected notification %#08x"), dwInternetStatus);
	}
}

VOID CALLBACK Internets::ResponseCallback(HINTERNET hInternet, DWORD_PTR dwContext, DWORD dwInternetStatus, LPVOID lpvStatusInformation, DWORD /*dwStatusInformationLength*/) noexcept {
	auto* this_ = reinterpret_cast<Internets*>(dwContext);
	switch (dwInternetStatus) {
		WINHTTP_ASYNC_RESULT* result;
	case WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE:
		return this_->EndResponse(hInternet);
	case WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING:
		this_->OnClose(hInternet);
		return this_->EndResponse(hInternet, WSAECONNABORTED);
	case WINHTTP_CALLBACK_STATUS_REQUEST_ERROR:
		result = reinterpret_cast<WINHTTP_ASYNC_RESULT*>(lpvStatusInformation);
		return this_->EndResponse(hInternet, result->dwError);
	default:
		DebugWriteLine(_T("warning:  unexpected notification %#08x"), dwInternetStatus);
	}
}

VOID CALLBACK Internets::SendCallback(HINTERNET hInternet, DWORD_PTR dwContext, DWORD dwInternetStatus, LPVOID lpvStatusInformation, DWORD /*dwStatusInformationLength*/) noexcept {
	auto* this_ = reinterpret_cast<Internets*>(dwContext);
	switch (dwInternetStatus) {
		WINHTTP_ASYNC_RESULT* result;
	case WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE:
		return this_->EndSend(hInternet);
	case WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING:
		this_->OnClose(hInternet);
		return this_->EndSend(hInternet, WSAECONNABORTED);
	case WINHTTP_CALLBACK_STATUS_REQUEST_ERROR:
		result = reinterpret_cast<WINHTTP_ASYNC_RESULT*>(lpvStatusInformation);
		return this_->EndSend(hInternet, result->dwError);
	default:
		DebugWriteLine(_T("warning:  unexpected notification %#08x"), dwInternetStatus);
	}
}
