#include "pch.h"
#include "Internal.h"

#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "mfplat.lib")
#pragma comment(lib, "mfuuid.lib")

using namespace Twitch;

namespace {
	std::string const nullGuid = "00000000-0000-0000-0000-000000000000";
#ifdef UNITY
	std::string const sdkRuntime = "Unity";
#else
	std::string const sdkRuntime = "C++";
#endif

	std::string GetApplicationName() {
		auto* commandLine = GetCommandLineA();
		if(commandLine[0] == '"') {
			++commandLine;
			auto* quote = strchr(commandLine, '"');
			if(quote != nullptr) {
				*quote = '\0';
			}
		} else {
			auto* space = strchr(commandLine, ' ');
			if(space != nullptr) {
				*space = '\0';
			}
		}
		auto const* separator = strrchr(commandLine, '\\');
		if(separator != nullptr) {
			return std::string(separator + 1);
		}
		return commandLine;
	}

#define ReturnIfError(result) do { if((result) != ERROR_SUCCESS) return std::string(); } while(false)

	std::string GetDeviceId() {
#ifdef _XBOX_ONE
		std::string rv;
		APP_LOCAL_DEVICE_ID deviceId;
		if (XInputOnGameInput::XInputGetDeviceId(0, &deviceId) == ERROR_SUCCESS) {
			std::transform(deviceId.value, deviceId.value + _countof(deviceId.value), std::back_inserter(rv), [](BYTE value) { return AsHexDigit(value); });
		}
		return rv;
#else
		auto const* keyName = "SOFTWARE\\Microsoft\\Cryptography";
		auto const* valueName = "MachineGuid";
		RegKey key;
		auto result = RegOpenKeyExA(HKEY_LOCAL_MACHINE, keyName, 0, KEY_READ, &key);
		if(result == ERROR_ACCESS_DENIED) {
			result = RegOpenKeyExA(HKEY_CURRENT_USER, keyName, 0, KEY_READ, &key);
		}
		ReturnIfError(result);
		DWORD type, n = 0;
		result = RegQueryValueExA(key, valueName, nullptr, &type, nullptr, &n);
		ReturnIfError(result);
		std::string deviceId(n / sizeof(std::string::value_type), '\0');
		result = RegQueryValueExA(key, valueName, nullptr, &type, reinterpret_cast<LPBYTE>(&deviceId[0]), &n);
		ReturnIfError(result);
		if(deviceId != nullGuid) {
			_strlwr_s(&deviceId[0], deviceId.size());
			deviceId.pop_back();
		} else {
			deviceId.clear();
		}
		return deviceId;
#endif
	}
}

#include "Analytics.inl"
