# buffered-cw-logger

This Logrus Hook is to used to buffer your logs and send to cloudwatch. It is created for migrating metrics off statsD. More info could be viewed at the section [migrating high-cardinality metrics](https://docs.google.com/document/d/1V5E8bEhjniEbyhY4K8u4rA2nnCTz5J29o6jN3CKO8OE/edit?usp=sharing) in doc. 

Inspired by [CW Log Hooks implementation](https://github.com/kdar/logrus-cloudwatchlogs), but adding several features to it, including:

- Have the option to follow TwitchTelemetry standards to include "Service, Stage, Substage, Region" as cloudwatch metrics requirements.
- Filter messages to be sent to CloudWatch
- Handle gracefully shutdown server behavior to avoid failing to send the data left in buffer during shutdown behavior

Sample usage from [example](lib/buffered_logger/hook_test.go):

```aidl
	hook, err := NewBufferedCWHookWithDefaultSettings(sess, identifier.ProcessIdentifier{
		Service: "TestService",
		Region:  "us-west-2",
		Stage:   "Development",
	}, LogIdentifier{
		Name:   "TestBusinessMetrics",
		Group:  group,
		Stream: stream,
	})

        hook2, err := NewBufferedCWHookWithDefaultSettings(sess, identifier.ProcessIdentifier{
		Service: "TestService2",
		Region:  "us-west-2",
		Stage:   "Development2",
	}, LogIdentifier{
		Name:   "TestBusinessMetrics2",
		Group:  group,
		Stream: stream2,
	})

	log1 := logrus.New()
	log1.AddHook(hook)
	log1.AddHook(hook2)

        // Should show up in CW logs
	log1.WithFields(logrus.Fields{
		CwLogName:    "TestBusinessMetrics",
		"TwitchID":   "999",
		"Count":      count,
		"TwitchName": "LogTest",
		"Action":     "retrieve_games_report",
	}).Info("Good Info Test Follow")

	// Should show not up in CW logs
	log1.WithFields(logrus.Fields{
		CwLogName:    "BadTestBusinessMetrics",
		"TwitchID":   "456",
		"Count":      count,
		"TwitchName": "BadLogTest",
		"Action":     "bad_download_games_report",
	}).Info("Bad Info Test")

	// Should show up in CW logs2
	log1.WithFields(logrus.Fields{
		CwLogName:    "TestBusinessMetrics2",
		"TwitchID":   "123",
		"Count":      count,
		"TwitchName": "LogTest2",
		"Action":     "upload_games_report",
	}).Info("Second Good Info Test")
```                  
