package buffered_logger

import (
	"errors"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/cloudwatchlogs"
	"github.com/sirupsen/logrus"
)

func (hook *CWLogHook) buildLogEvent(entry *logrus.Entry) (*cloudwatchlogs.InputLogEvent, error) {
	if entry == nil {
		return nil, errors.New("empty log entry")
	}

	// copy over from process_identifier
	entry.Data["region"] = hook.pid.Region
	entry.Data["service"] = hook.pid.Service
	entry.Data["stage"] = hook.pid.Stage
	entry.Data["substage"] = hook.pid.Substage
	entry.Data["version"] = hook.pid.Substage
	entry.Data["machine"] = hook.pid.Substage
	entry.Data["launch_id"] = hook.pid.Substage

	line, err := entry.String()
	if err != nil {
		return nil, err
	}

	event := &cloudwatchlogs.InputLogEvent{
		Message:   aws.String(line),
		Timestamp: aws.Int64(int64(time.Nanosecond) * time.Now().UnixNano() / int64(time.Millisecond)),
	}

	return event, nil
}
