package buffered_logger

import (
	"log"
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
)

// Matching format how TwitchTelemetryMetrics report dropped metrics
func (hook *CWLogHook) logDroppedEvents(error error) {
	if hook.reporter != nil {
		hook.reporter.Report(droppedLogsMetrics, 1.0, telemetry.UnitCount)
	}

	if hook.logger != nil {
		hook.logger.Log(error.Error(),
			droppedLogsKey, len(hook.batch.events),
			timestampKey, time.Now().UTC().Format(time.RFC3339))
	} else {
		log.Printf("%s %s %d. %s %s",
			error.Error(),
			droppedLogsKey,
			len(hook.batch.events),
			timestampKey,
			time.Now().UTC().Format(time.RFC3339))
	}
}
