package buffered_logger

import (
	"github.com/sirupsen/logrus"
)

// reserved field to tell if this hook should fire for the logging event
const CwLogName = "_cw_log_name"

func (hook *CWLogHook) Fire(entry *logrus.Entry) error {
	// If the reserved field doesn't match this hook's name, it should not be responsible to file for it
	// Because not all logging event needs to be sent to CloudWatch
	// And different event might need to send to different stream/group
	if entry.Data[CwLogName] != hook.identifier.Name {
		return nil
	}

	event, err := hook.buildLogEvent(entry)
	if err != nil {
		hook.logger.Log("Unable to build log event for ", entry, "due to: ", err)
	} else {
		hook.buffer <- *event
	}

	return nil
}
